/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.baltic.sax;

import com.cognos.cm.plugin.cps.upgrade.baltic.helper.Pagelet;
import com.cognos.cm.plugin.cps.upgrade.baltic.helper.PortletInstance;
import com.cognos.cm.plugin.cps.upgrade.baltic.sax.PortletHandler;
import com.cognos.cm.plugin.cps.upgrade.baltic.sax.helper.ElementHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PageHandler
extends DefaultHandler {
    private XMLReader reader;
    private Pagelet pagelet;
    private PortletHandler currentPortletHandler;
    private int documentOrder;

    public PageHandler(XMLReader reader) {
        this.reader = reader;
    }

    @Override
    public void startElement(String uri, String local, String qname, Attributes attributes) throws SAXException {
        String tag;
        String string = tag = "".equals(uri) ? qname : local;
        if (tag.equals("page")) {
            this.pagelet = new Pagelet(attributes.getValue("title"));
        } else if (tag.equals("column")) {
            this.pagelet.addColumn(attributes.getValue("width"));
            this.documentOrder = 0;
        } else if (tag.equals("portlet")) {
            this.currentPortletHandler = new PortletHandler(this.reader, this.documentOrder++);
            ElementHandler elementHandler = new ElementHandler(this.reader, this.currentPortletHandler);
            elementHandler.startElement(uri, local, qname, attributes);
        }
    }

    @Override
    public void endElement(String uri, String local, String qname) throws SAXException {
        String tag;
        String string = tag = "".equals(uri) ? qname : local;
        if (!tag.equals("page") && !tag.equals("column") && tag.equals("portlet")) {
            PortletInstance portletInstance = this.currentPortletHandler.getPortletInstance();
            if (portletInstance != null) {
                this.pagelet.addPortletInstance(portletInstance);
            }
            this.currentPortletHandler = null;
        }
    }

    public Pagelet getPagelet() {
        return this.pagelet;
    }
}

