/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.baltic.sax;

import com.cognos.cm.plugin.cps.upgrade.baltic.helper.PortletInstance;
import com.cognos.cm.plugin.cps.upgrade.baltic.sax.helper.ElementHandler;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PortletHandler
extends DefaultHandler {
    private static final String CONTENT_PRODUCER = "/portal/portalPackage[@name = 'Connection']/portletFolder/portletProducer[@name = 'IBM Cognos Content']";
    private static final String UTILITY_PRODUCER = "/portal/portalPackage[@name = 'Connection']/portletFolder/portletProducer[@name = 'IBM Cognos Utility']";
    private PortletInstance portletInstance;
    private StringBuffer charBuf = new StringBuffer();
    private XMLReader reader;
    private int documentOrder;

    public PortletHandler(XMLReader reader, int documentOrder) {
        this.reader = reader;
        this.documentOrder = documentOrder;
    }

    @Override
    public void startElement(String uri, String local, String qname, Attributes attributes) throws SAXException {
        String tag;
        String string = tag = "".equals(uri) ? qname : local;
        if (tag.equals("portlet")) {
            String provider = attributes.getValue("provider");
            this.portletInstance = new PortletInstance(attributes.getValue("name"));
            this.portletInstance.setColumnOrder(attributes.getValue("columnOrder"));
            this.portletInstance.setDocumentOrder(this.documentOrder);
            DefaultHandler innerHandler = null;
            if (provider.equals("folders")) {
                innerHandler = new FoldersPortletHandler();
            } else if (provider.equals("search")) {
                innerHandler = new SearchPortletHandler();
            } else if (provider.equals("report")) {
                innerHandler = new ReportPortletHandler();
            } else if (provider.equals("gen-iframe")) {
                innerHandler = new IframePortletHandler();
            } else if (provider.equals("rss")) {
                innerHandler = new RssPortletHandler();
            } else if (provider.equals("bookmark")) {
                innerHandler = new BookmarkPortletHandler();
            } else {
                this.portletInstance = null;
                return;
            }
            ElementHandler elementHandler = new ElementHandler(this.reader, innerHandler);
            elementHandler.startElement(uri, local, qname, attributes);
        }
    }

    @Override
    public void endElement(String uri, String local, String qname) throws SAXException {
    }

    public PortletInstance getPortletInstance() {
        return this.portletInstance;
    }

    private class FoldersPortletHandler
    extends DefaultHandler {
        public FoldersPortletHandler() {
            PortletHandler.this.portletInstance.setPortletPath("/portal/portalPackage[@name = 'Connection']/portletFolder/portletProducer[@name = 'IBM Cognos Content']/portlet[@name='IBM Cognos Navigator']");
            PortletHandler.this.portletInstance.setHandle("navigator");
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            PortletHandler.this.charBuf.append(arg0, arg1, arg2);
        }

        @Override
        public void endElement(String uri, String qname, String local) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("searchPath") && PortletHandler.this.charBuf.length() > 0) {
                String searchPath = PortletHandler.this.charBuf.toString();
                PortletHandler.this.portletInstance.addDeploymentReference("display_folder", searchPath);
                PortletHandler.this.portletInstance.addParam("display_folder", searchPath, true);
            }
        }

        @Override
        public void startElement(String uri, String qname, String local, Attributes atts) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("searchPath")) {
                PortletHandler.this.charBuf.setLength(0);
            }
        }
    }

    private class SearchPortletHandler
    extends DefaultHandler {
        private int searchCount = 0;

        public SearchPortletHandler() {
            PortletHandler.this.portletInstance.setPortletPath("/portal/portalPackage[@name = 'Connection']/portletFolder/portletProducer[@name = 'IBM Cognos Content']/portlet[@name='IBM Cognos Search']");
            PortletHandler.this.portletInstance.setHandle("search");
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            PortletHandler.this.charBuf.append(arg0, arg1, arg2);
        }

        @Override
        public void endElement(String uri, String qname, String local) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("searchString") && PortletHandler.this.charBuf.length() > 0) {
                PortletHandler.this.portletInstance.addParam("saved_n" + Integer.toString(this.searchCount), PortletHandler.this.charBuf.toString());
                PortletHandler.this.portletInstance.addParam("saved_s" + Integer.toString(this.searchCount), this.createSearchString(PortletHandler.this.charBuf.toString()));
            }
        }

        @Override
        public void startElement(String uri, String qname, String local, Attributes atts) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("searchString")) {
                ++this.searchCount;
                PortletHandler.this.charBuf.setLength(0);
            }
        }

        private String createSearchString(String searchString) {
            Element param = DocumentHelper.createElement((String)"param");
            param.addAttribute("name", "cps_string");
            param.setText(searchString);
            return PortletInstance.web64encode(param.asXML() + "<param name=\"execute\">true</param>", true);
        }
    }

    private class ReportPortletHandler
    extends DefaultHandler {
        public ReportPortletHandler() {
            PortletHandler.this.portletInstance.setPortletPath("/portal/portalPackage[@name = 'Connection']/portletFolder/portletProducer[@name = 'IBM Cognos Content']/portlet[@name='IBM Cognos Viewer']");
            PortletHandler.this.portletInstance.setHandle("viewer");
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            PortletHandler.this.charBuf.append(arg0, arg1, arg2);
        }

        @Override
        public void endElement(String uri, String qname, String local) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("searchPath") && PortletHandler.this.charBuf.length() > 0) {
                String searchPath = PortletHandler.this.charBuf.toString();
                PortletHandler.this.portletInstance.addDeploymentReference("display_id", searchPath);
                PortletHandler.this.portletInstance.addParam("display_id", searchPath, true);
            } else if (tag.equals("height")) {
                PortletHandler.this.portletInstance.addParam("display_height", PortletHandler.this.charBuf.toString(), false);
            }
        }

        @Override
        public void startElement(String uri, String qname, String local, Attributes atts) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("searchPath") || tag.equals("height")) {
                PortletHandler.this.charBuf.setLength(0);
            }
        }
    }

    private class IframePortletHandler
    extends DefaultHandler {
        public IframePortletHandler() {
            PortletHandler.this.portletInstance.setPortletPath("/portal/portalPackage[@name = 'Connection']/portletFolder/portletProducer[@name = 'IBM Cognos Utility']/portlet[@name='HTML Viewer']");
            PortletHandler.this.portletInstance.setHandle("html");
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            PortletHandler.this.charBuf.append(arg0, arg1, arg2);
        }

        @Override
        public void endElement(String uri, String qname, String local) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("URL") && PortletHandler.this.charBuf.length() > 0) {
                PortletHandler.this.portletInstance.addParam("url", PortletHandler.this.charBuf.toString());
            } else if (tag.equals("height")) {
                PortletHandler.this.portletInstance.addParam("html_height", PortletHandler.this.charBuf.toString(), false);
            }
        }

        @Override
        public void startElement(String uri, String qname, String local, Attributes atts) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("URL") || tag.equals("height")) {
                PortletHandler.this.charBuf.setLength(0);
            }
        }
    }

    private class RssPortletHandler
    extends DefaultHandler {
        public RssPortletHandler() {
            PortletHandler.this.portletInstance.setPortletPath("/portal/portalPackage[@name = 'Connection']/portletFolder/portletProducer[@name = 'IBM Cognos Utility']/portlet[@name='RSS Viewer']");
            PortletHandler.this.portletInstance.setHandle("rss");
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            PortletHandler.this.charBuf.append(arg0, arg1, arg2);
        }

        @Override
        public void endElement(String uri, String qname, String local) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("URL") && PortletHandler.this.charBuf.length() > 0) {
                PortletHandler.this.portletInstance.addParam("rss_url", PortletHandler.this.charBuf.toString());
            }
        }

        @Override
        public void startElement(String uri, String qname, String local, Attributes atts) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("URL")) {
                PortletHandler.this.charBuf.setLength(0);
            }
        }
    }

    private class BookmarkPortletHandler
    extends DefaultHandler {
        private int urlCount = 0;
        private int aliasCount = 0;

        public BookmarkPortletHandler() {
            PortletHandler.this.portletInstance.setPortletPath("/portal/portalPackage[@name = 'Connection']/portletFolder/portletProducer[@name = 'IBM Cognos Utility']/portlet[@name='Bookmarks Viewer']");
            PortletHandler.this.portletInstance.setHandle("bookmarks");
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            PortletHandler.this.charBuf.append(arg0, arg1, arg2);
        }

        @Override
        public void endElement(String uri, String qname, String local) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("link") && PortletHandler.this.charBuf.length() > 0) {
                String sUrlCount = this.urlCount < 10 ? "0" + Integer.toString(this.urlCount) : Integer.toString(this.urlCount);
                PortletHandler.this.portletInstance.addParam("boo_url" + sUrlCount, PortletHandler.this.charBuf.toString());
            } else if (tag.equals("alias") && PortletHandler.this.charBuf.length() > 0) {
                String sAliasCount = this.aliasCount < 10 ? "0" + Integer.toString(this.aliasCount) : Integer.toString(this.aliasCount);
                PortletHandler.this.portletInstance.addParam("boo_alias" + sAliasCount, PortletHandler.this.charBuf.toString());
            }
        }

        @Override
        public void startElement(String uri, String qname, String local, Attributes atts) throws SAXException {
            String tag;
            String string = tag = "".equals(uri) ? qname : local;
            if (tag.equals("link")) {
                ++this.urlCount;
                PortletHandler.this.charBuf.setLength(0);
            } else if (tag.equals("alias")) {
                ++this.aliasCount;
                PortletHandler.this.charBuf.setLength(0);
            }
        }
    }
}

