/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.bering;

import com.cognos.cm.constants.CMError;

public class UpdateAdminConsolePageletPolicy {
    private String name_;
    private String policy_;
    private StringBuffer command = new StringBuffer();

    UpdateAdminConsolePageletPolicy(String name, String policy) {
        this.name_ = name;
        this.policy_ = policy;
    }

    public void execute() {
        this.command.append("<cm:update xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        this.command.append("<objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:baseClass[]\">");
        if (this.name_.equals("canUseScheduling")) {
            this.appendCanUseSchedulingPagelet();
        } else if (this.name_.equals("canUseServerAdministrationTool")) {
            this.appendCanUseServerAdministrationTool();
        } else if (this.name_.equals("canUseDirectoryTool")) {
            this.appendCanUseDirectoryTool();
        } else if (this.name_.equals("canUseCapabilitiesTool")) {
            this.appendCanUseCapabilitiesTool();
        } else if (this.name_.equals("canUsePortalAdministrationTool")) {
            this.appendCanUsePortalAdministrationTool();
        } else if (this.name_.equals("canUseContentStoreTool")) {
            this.appendCanUseContentStoreTool();
        } else {
            this.command = null;
            return;
        }
        this.command.append("</objects>");
        this.command.append("</cm:update>");
    }

    private void appendCanUsePortalAdministrationTool() {
        String console = this.getConsoleSearchPath();
        String parentPath = this.getConfigurationSearchPath(console);
        String path = this.getPageletSearchPath(parentPath, "cmInitPageletStyles");
        this.buildItem(path);
        path = this.getPageletSearchPath(parentPath, "cmInitPageletPortletImports");
        this.buildItem(path);
        parentPath = this.getSecuritySearchPath(console);
        path = this.getPageletSearchPath(parentPath, "cmInitPageletCognosAdministrationCapabilities");
        this.buildItem(path);
    }

    private void appendCanUseContentStoreTool() {
        String console = this.getConsoleSearchPath();
        String parentPath = this.getConfigurationSearchPath(console);
        String path = this.getPageletSearchPath(parentPath, "cmInitPageletAdministrativeTasks");
        this.buildItem(path);
    }

    private void appendCanUseCapabilitiesTool() {
        String console = this.getConsoleSearchPath();
        String parentPath = this.getSecuritySearchPath(console);
        String path = this.getPageletSearchPath(parentPath, "cmInitPageletCapabilities");
        this.buildItem(path);
    }

    private void appendCanUseDirectoryTool() {
        String console = this.getConsoleSearchPath();
        String parentPath = this.getConfigurationSearchPath(console);
        String path = this.getPageletSearchPath(parentPath, "cmInitPageletDataSourceConnection");
        this.buildItem(path);
        path = this.getPageletSearchPath(parentPath, "cmInitPageletDistributionListsandContacts");
        this.buildItem(path);
        path = this.getPageletSearchPath(parentPath, "cmInitPageletPrinters");
        this.buildItem(path);
        parentPath = this.getSecuritySearchPath(console);
        path = this.getPageletSearchPath(parentPath, "cmInitPageletUsersGroupsandRoles");
        this.buildItem(path);
    }

    private void appendCanUseServerAdministrationTool() {
        String console = this.getConsoleSearchPath();
        String parentPath = this.getConfigurationSearchPath(console);
        String path = this.getPageletSearchPath(parentPath, "cmInitPageletDispatchersandServices");
        this.buildItem(path);
        parentPath = this.getStatusSearchPath(console);
        path = this.getPageletSearchPath(parentPath, "cmInitPageletSystem");
        this.buildItem(path);
        parentPath = this.getSecuritySearchPath(console);
        path = this.getPageletSearchPath(parentPath, "cmInitPageletUIProfileAdministration");
        this.buildItem(path);
    }

    private void appendCanUseSchedulingPagelet() {
        String console = this.getConsoleSearchPath();
        String parentPath = this.getStatusSearchPath(console);
        String path = this.getPageletSearchPath(parentPath, "cmInitPageletCurrentActivities");
        this.buildItem(path);
        path = this.getPageletSearchPath(parentPath, "cmInitPageletPastActivities");
        this.buildItem(path);
        path = this.getPageletSearchPath(parentPath, "cmInitPageletUpcomingActivities");
        this.buildItem(path);
        path = this.getPageletSearchPath(parentPath, "cmInitPageletSchedules");
        this.buildItem(path);
    }

    private void buildItem(String searchPath) {
        this.command.append("<item xsi:type=\"cm:pagelet\">");
        this.command.append("<searchPath xsi:type=\"cm:stringProp\"><value>");
        this.command.append(searchPath);
        this.command.append("</value></searchPath>");
        this.command.append(this.policy_);
        this.command.append("</item>");
    }

    private String getConsoleSearchPath() {
        StringBuffer buf = new StringBuffer("/portal");
        buf.append("/portalPackage[@name='");
        buf.append(CMError.getMessage("cmInitPortalPackageAdmin", null, null));
        buf.append("']/pageletFolder[@name='");
        buf.append(CMError.getMessage("cmInitPageletFolderPagelets", null, null));
        buf.append("']/pageletFolder[@name='");
        buf.append(CMError.getMessage("cmInitPageletFolderConsole", null, null));
        buf.append("']");
        return buf.toString();
    }

    private String getStatusSearchPath(String path) {
        StringBuffer buf = new StringBuffer(path);
        buf.append("/pageletFolder[@name='");
        buf.append(CMError.getMessage("cmInitPageletFolderStatus", null, null));
        buf.append("']");
        return buf.toString();
    }

    private String getSecuritySearchPath(String path) {
        StringBuffer buf = new StringBuffer(path);
        buf.append("/pageletFolder[@name='");
        buf.append(CMError.getMessage("cmInitPageletFolderSecurity", null, null));
        buf.append("']");
        return buf.toString();
    }

    private String getConfigurationSearchPath(String path) {
        StringBuffer buf = new StringBuffer(path);
        buf.append("/pageletFolder[@name='");
        buf.append(CMError.getMessage("cmInitPageletFolderConfiguration", null, null));
        buf.append("']");
        return buf.toString();
    }

    private String getPageletSearchPath(String parentPath, String initMsgCode) {
        StringBuffer buf = new StringBuffer(parentPath);
        buf.append("/pagelet[@name='");
        buf.append(CMError.getMessage(initMsgCode, null, null));
        buf.append("']");
        return buf.toString();
    }

    public String getCommand() {
        if (this.command == null) {
            return null;
        }
        return this.command.toString();
    }
}

