/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.bering;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cps.upgrade.baltic.helper.base64;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class UpgradeDeploymentReferences
implements CMUpgradePlugin {
    private static final String NAV_ID_MARKER = "_";
    private static final String SYSTEM_DEFAULT_PATH = "/content";
    private static final String USER_DEFAULT_PATH = "~/folder";
    private static final String ROOT_DEFAULT_ID = "rootDefault";
    private static final String SYSTEM_DEFAULT_ID = "systemDefault";
    private static final String USER_DEFAULT_ID = "userDefault";
    private static final List<String> NAV_EXTERNAL_REF_PARAM_LIST;
    private static final Namespace WSRP_NAMESPACE;
    private static final Namespace CPS_EXT_NAMESPACE;
    private static final Namespace CM_NAMESPACE;
    private static final Namespace XSD_NAMESPACE;
    private static final Namespace SOAPENC_NAMESPACE;
    private static final Namespace XSI_NAMESPACE;

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        CMUpgradeResult result = new CMUpgradeResult();
        boolean upgraded = false;
        HashMap<String, String> resultData = null;
        boolean hasError = false;
        try {
            String portletContext = this.getPropertyValue(data, "context");
            if (portletContext != null && data.getPropertyValue("deploymentReferences") == null) {
                byte[] decodedBytes;
                resultData = new HashMap<String, String>();
                Element portletContextRootElem = DocumentHelper.parseText((String)portletContext).getRootElement();
                String portletState = portletContextRootElem.valueOf("*[local-name()='portletState']");
                if (portletState != null && portletState.length() > 0 && (decodedBytes = this.base64Decode(portletState, true)) != null) {
                    String decodedPortletState = new String(decodedBytes, "UTF-8");
                    Element stateElem = DocumentHelper.parseText((String)("<params>" + decodedPortletState + "</params>")).getRootElement();
                    List params = stateElem.selectNodes("param");
                    if (params != null) {
                        HashMap<String, String> externalRefs = null;
                        for (Element param : params) {
                            String name = param.attributeValue("name");
                            if (name == null || name.length() <= 0 || !NAV_EXTERNAL_REF_PARAM_LIST.contains(name)) continue;
                            if (externalRefs == null) {
                                externalRefs = new HashMap<String, String>();
                            }
                            externalRefs.put(name, param.getText());
                        }
                        if (externalRefs != null) {
                            Element externalRefExtensions = DocumentHelper.createElement((QName)new QName("extensions", WSRP_NAMESPACE));
                            Element stateExtension = externalRefExtensions.addElement(new QName("state", CPS_EXT_NAMESPACE));
                            Element deploymentReferences = DocumentHelper.createElement((String)"deploymentReferences");
                            deploymentReferences.add(CM_NAMESPACE);
                            deploymentReferences.add(XSD_NAMESPACE);
                            deploymentReferences.addAttribute(new QName("type", XSI_NAMESPACE), "cm:deploymentReferenceArrayProp");
                            Element deploymentReferencesValue = deploymentReferences.addElement("value");
                            deploymentReferencesValue.addAttribute(new QName("type", XSI_NAMESPACE), "SOAP-ENC:Array");
                            deploymentReferencesValue.addAttribute(new QName("arrayType", SOAPENC_NAMESPACE), "cm:deploymentReference[]");
                            for (Map.Entry entry : externalRefs.entrySet()) {
                                String name = (String)entry.getKey();
                                String value = (String)entry.getValue();
                                Element externalRef = stateExtension.addElement(new QName("externalRef", CPS_EXT_NAMESPACE));
                                externalRef.addAttribute("type", "nav");
                                externalRef.addAttribute("name", name);
                                externalRef.addText(value);
                                String searchPath = this.getSearchPath(externalRefs, name);
                                if (searchPath == null || searchPath.length() <= 0) continue;
                                this.addDeploymentReference(name, searchPath, deploymentReferencesValue);
                            }
                            portletContextRootElem.add(externalRefExtensions);
                            Element context = DocumentHelper.createElement((String)"context");
                            context.addAttribute(new QName("type", XSI_NAMESPACE), "cm:xmlEncodedXMLProp");
                            Element contextValue = context.addElement("value");
                            contextValue.addAttribute(new QName("type", XSI_NAMESPACE), "cm:xmlEncodedXML");
                            contextValue.addText(portletContextRootElem.asXML());
                            resultData.put("context", context.asXML());
                            resultData.put("deploymentReferences", deploymentReferences.asXML());
                            upgraded = true;
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            result.setMessage(t.getMessage());
            hasError = true;
        }
        if (upgraded) {
            result.setUpgradeStatus(1);
            result.setData(resultData);
        } else if (hasError) {
            result.setUpgradeStatus(2);
        } else {
            result.setUpgradeStatus(0);
        }
        result.setNextAction(1);
        return result;
    }

    private void addDeploymentReference(String propName, String propValue, Element deploymentReferencesValue) {
        Element item = deploymentReferencesValue.addElement("item");
        item.addAttribute(new QName("type", XSI_NAMESPACE), "cm:deploymentReference");
        Element name = item.addElement("name");
        name.addAttribute(new QName("type", XSI_NAMESPACE), "SOAP-ENC:Array");
        name.addAttribute(new QName("arrayType", SOAPENC_NAMESPACE), "cm:multilingualToken[1]");
        Element multilingualItem = name.addElement("item");
        multilingualItem.addAttribute(new QName("type", XSI_NAMESPACE), "cm:multilingualToken");
        Element multilingualLocale = multilingualItem.addElement("locale");
        multilingualLocale.addAttribute(new QName("type", XSI_NAMESPACE), "xsd:string");
        multilingualLocale.addText("en");
        Element multilingualValue = multilingualItem.addElement("value");
        multilingualValue.addAttribute(new QName("type", XSI_NAMESPACE), "xsd:string");
        multilingualValue.addText(propName);
        Element objects = item.addElement("objects");
        objects.addAttribute(new QName("type", XSI_NAMESPACE), "SOAP-ENC:Array");
        objects.addAttribute(new QName("arrayType", SOAPENC_NAMESPACE), "cm:baseClass[1]");
        Element objectsItem = objects.addElement("item");
        Element searchPath = objectsItem.addElement("searchPath");
        searchPath.addAttribute(new QName("type", XSI_NAMESPACE), "cm:stringProp");
        Element searchPathValue = searchPath.addElement("value");
        searchPathValue.addAttribute(new QName("type", XSI_NAMESPACE), "xsd:string");
        searchPathValue.addText(propValue);
    }

    public void initialize(CMPluginDescriptor arg0, ICCLConfiguration arg1) throws Exception {
    }

    public void terminate() throws Exception {
    }

    private String getSearchPath(Map<String, String> externalRefs, String propName) {
        String value = null;
        if (!propName.endsWith("_dep")) {
            value = externalRefs.get(propName + "_dep");
        }
        if (value == null) {
            value = externalRefs.get(propName);
        }
        if (value != null) {
            value = this.getSearchPathFromNavId(value);
        }
        return value;
    }

    private String getSearchPathFromNavId(String id) {
        String path = null;
        if (ROOT_DEFAULT_ID.equals(id)) {
            return null;
        }
        if (SYSTEM_DEFAULT_ID.equals(id)) {
            path = SYSTEM_DEFAULT_PATH;
        } else if (USER_DEFAULT_ID.equals(id)) {
            path = USER_DEFAULT_PATH;
        } else if (id.startsWith("path:")) {
            path = id.substring(5);
        } else if (id.startsWith(NAV_ID_MARKER)) {
            path = "storeID(\"" + id.substring(NAV_ID_MARKER.length(), id.length()) + "\")";
        } else {
            try {
                byte[] bytes = this.web64Decode(id, false);
                if (bytes != null) {
                    path = new String(bytes, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return path;
    }

    private String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && propXML.length() > 0 && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] base64Decode(String value, boolean decompress) {
        byte[] b = base64.decode(0, value);
        if (decompress) {
            GZIPInputStream gzis = null;
            ByteArrayOutputStream bos = null;
            try {
                gzis = new GZIPInputStream(new ByteArrayInputStream(b));
                bos = new ByteArrayOutputStream();
                int nByteRead = 0;
                byte[] buf = new byte[256];
                while ((nByteRead = gzis.read(buf, 0, 256)) != -1) {
                    bos.write(buf, 0, nByteRead);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (gzis != null) {
                    try {
                        gzis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] web64Decode(String value, boolean decompress) {
        byte[] b = base64.decode(1, value);
        if (decompress) {
            GZIPInputStream gzis = null;
            ByteArrayOutputStream bos = null;
            try {
                gzis = new GZIPInputStream(new ByteArrayInputStream(b));
                bos = new ByteArrayOutputStream();
                int nByteRead = 0;
                byte[] buf = new byte[256];
                while ((nByteRead = gzis.read(buf, 0, 256)) != -1) {
                    bos.write(buf, 0, nByteRead);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (gzis != null) {
                    try {
                        gzis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return b;
    }

    static {
        WSRP_NAMESPACE = new Namespace("wsrp", "urn:oasis:names:tc:wsrp:v1:types");
        CPS_EXT_NAMESPACE = new Namespace("cpsext", "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/");
        CM_NAMESPACE = DocumentHelper.createNamespace((String)"cm", (String)"http://developer.cognos.com/schemas/bibus/3/");
        XSD_NAMESPACE = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
        SOAPENC_NAMESPACE = DocumentHelper.createNamespace((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
        XSI_NAMESPACE = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        NAV_EXTERNAL_REF_PARAM_LIST = new ArrayList<String>();
        NAV_EXTERNAL_REF_PARAM_LIST.add("display_id");
        NAV_EXTERNAL_REF_PARAM_LIST.add("display_id_dep");
        NAV_EXTERNAL_REF_PARAM_LIST.add("display_folder");
        NAV_EXTERNAL_REF_PARAM_LIST.add("display_folder_dep");
    }
}

