/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.bering;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class UpgradePageletLayout
implements CMUpgradePlugin {
    private static final Namespace XSI_NAMESPACE = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");

    public void initialize(CMPluginDescriptor arg0, ICCLConfiguration arg1) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        boolean upgraded = false;
        HashMap<String, String> resultData = null;
        String errorMessage = null;
        try {
            Element layoutElement;
            List columns;
            String layout = this.getPropertyValue(data, "layout");
            if (layout != null && (columns = (layoutElement = DocumentHelper.parseText((String)layout).getRootElement()).selectNodes("*[local-name()='column']")) != null && columns.size() > 0) {
                int totalWidths = 0;
                for (Element col : columns) {
                    String width = col.attributeValue("width");
                    if (width == null || "".equals(width)) continue;
                    totalWidths += Integer.parseInt(col.attributeValue("width"));
                }
                Element row = DocumentHelper.createElement((String)"row");
                layoutElement.add(row);
                for (Element col : columns) {
                    String width;
                    Attribute widthAttr;
                    if (totalWidths > 0 && (widthAttr = col.attribute("width")) != null && (width = widthAttr.getValue()) != null && !"".equals(width)) {
                        int newWidth = Integer.parseInt(width);
                        newWidth = newWidth * 100 / totalWidths;
                        widthAttr.setValue(Integer.toString(newWidth));
                    }
                    col.detach();
                    row.add(col);
                }
                Attribute versionAttr = layoutElement.attribute("version");
                if (versionAttr != null) {
                    versionAttr.setValue("1.1");
                }
                Element layoutUpdate = DocumentHelper.createElement((String)"layout");
                layoutUpdate.addAttribute(new QName("type", XSI_NAMESPACE), "cm:xmlEncodedXMLProp");
                Element layoutUpdateValue = layoutUpdate.addElement("value");
                layoutUpdateValue.addAttribute(new QName("type", XSI_NAMESPACE), "cm:xmlEncodedXML");
                layoutUpdateValue.addText(layoutElement.asXML());
                resultData = new HashMap<String, String>();
                resultData.put("layout", layoutUpdate.asXML());
                upgraded = true;
            }
        }
        catch (Throwable t) {
            errorMessage = t.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (upgraded) {
            result.setUpgradeStatus(1);
            result.setData(resultData);
        } else if (errorMessage != null) {
            result.setUpgradeStatus(2);
            ArrayList<CMUpgradeMessage> messages = new ArrayList<CMUpgradeMessage>();
            messages.add(new CMUpgradeMessage(errorMessage, 40000));
            result.setMessages(messages);
        } else {
            result.setUpgradeStatus(0);
        }
        result.setNextAction(1);
        return result;
    }

    private String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && propXML.length() > 0 && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }
}

