/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.bering;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cps.upgrade.bering.UpdateAdminConsolePageletPolicy;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;

public class UpgradePagelets
implements CMUpgradePlugin {
    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String errorMessage = null;
        boolean abortUpgrade = false;
        try {
            String capability = this.getPropertyValue(data, "userCapability");
            String policiesXML = (String)data.getPropertyValue("policies");
            if (capability == null || policiesXML == null || policiesXML.length() <= 0) {
                return null;
            }
            UpdateAdminConsolePageletPolicy upgradePagelet = new UpdateAdminConsolePageletPolicy(capability, policiesXML);
            upgradePagelet.execute();
            String command = upgradePagelet.getCommand();
            if (command == null) {
                return null;
            }
            String response = ContentManager.getInstance().ExecuteStaticRequest(command, false, true);
            if (response == null) {
                abortUpgrade = true;
                errorMessage = "CM has been shutdown. Abort data upgrade!";
            } else if (response.indexOf("<SOAP-ENV:Fault") != -1) {
                errorMessage = response;
            }
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else {
            result.setUpgradeStatus(1);
        }
        if (abortUpgrade) {
            result.setNextAction(2);
        } else {
            result.setNextAction(1);
        }
        return result;
    }

    private String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && propXML.length() > 0 && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }
}

