/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.bering;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class UpgradePortletNames
implements CMUpgradePlugin {
    static Map<String, String> upgradeHandles = new HashMap<String, String>();
    static final String serviceDescriptionsFile = "com/cognos/cm/plugin/cps/upgrade/bering/portletnamesupgrade.xml";
    private Element docRoot = null;
    private static final Namespace XSI_NAMESPACE;
    private static Resources resourcesSingleton;
    private static Map<String, String> portletInstanceSearchPathMappings;
    private static boolean portletInstanceSearchPathMappings_built;

    public boolean isUpgradeProperty(String handle, String propName) {
        String v = upgradeHandles.get(handle);
        return v != null ? v.indexOf("|" + propName) != -1 : false;
    }

    public String lookupHandle(String objectClass, String handle, String bindingXML) {
        if (objectClass == null || "".equals(objectClass)) {
            return null;
        }
        if ("portlet".equals(objectClass)) {
            int idx;
            if (handle != null && (idx = handle.indexOf("#")) != -1) {
                handle = handle.substring(0, idx);
            }
        } else if ("portletProducer".equals(objectClass)) {
            if (bindingXML != null) {
                if (bindingXML.indexOf("/wsrp/cps4/portlets/nav") != -1) {
                    handle = "/wsrp/cps4/portlets/nav";
                } else if (bindingXML.indexOf("/wsrp/cps4/portlets/utility") != -1) {
                    handle = "/wsrp/cps4/portlets/utility";
                } else if (bindingXML.indexOf("/wsrp/cps4/portlets/sdk") != -1) {
                    handle = "/wsrp/cps4/portlets/sdk";
                } else if (bindingXML.indexOf("/wsrp/fragments/markup/handle/dashboardportlets") != -1) {
                    handle = "/wsrp/fragments/markup/handle/dashboardportlets";
                } else if (bindingXML.indexOf("/wsrp/fragments/markup/handle/cmm") != -1) {
                    handle = "/wsrp/fragments/markup/handle/cmm";
                } else if (bindingXML.indexOf("/wsrp/cps4/portlets/cmm") != -1) {
                    handle = "/wsrp/cps4/portlets/cmm";
                }
            }
        } else if ("portletInstance".equals(objectClass)) {
            handle = "portletInstance";
        }
        return upgradeHandles.containsKey(handle) ? handle : null;
    }

    public void initialize(CMPluginDescriptor arg0, ICCLConfiguration arg1) throws Exception {
        resourcesSingleton = new Resources();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(serviceDescriptionsFile);
            SAXReader reader = new SAXReader();
            Document document = reader.read(is);
            this.docRoot = document.getRootElement();
            this.prebuildPortletInstanceSearchPathMappings();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void terminate() throws Exception {
    }

    private void prebuildPortletInstanceSearchPathMappings() {
        portletInstanceSearchPathMappings.put("/portletProducer[@name='Dashboard Portlets']/portlet[@name='Booklet Viewer']", "/portletProducer[@name='Dashboard']/portlet[@name='Multi-page']");
        portletInstanceSearchPathMappings.put("/portletProducer[@name='Metric Studio Portlets']/portlet[@name='Metric Watch List Portlet']", "/portletProducer[@name='Cognos Metrics']/portlet[@name='Metric List']");
        portletInstanceSearchPathMappings.put("/portletProducer[@name='Metric Studio Portlets']/portlet[@name='History Chart']", "/portletProducer[@name='Cognos Metrics']/portlet[@name='Metric History Chart']");
    }

    private String getPortletInstancePortletOrProducerName(int index, String localeStr, List nodes) {
        Element locale;
        Element item;
        if (index >= 0 && index < nodes.size() && (item = (Element)nodes.get(index)) != null && localeStr.equals((locale = (Element)item.selectSingleNode("locale")).getText())) {
            return ((Element)item.selectSingleNode("value")).getText();
        }
        for (int i = 0; i < nodes.size(); ++i) {
            Element item2 = (Element)nodes.get(i);
            Element locale2 = (Element)item2.selectSingleNode("locale");
            if (!localeStr.equals(locale2.getText())) continue;
            return ((Element)item2.selectSingleNode("value")).getText();
        }
        return "";
    }

    private void addPortletInstanceSearchPathMappings(String producerHandle, String portletHandle) {
        List oldProducer = UpgradePortletNames.resourcesSingleton.getResourceList("old", "name", this.docRoot, "portletProducer", producerHandle);
        List newProducer = UpgradePortletNames.resourcesSingleton.getResourceList("new", "name", this.docRoot, "portletProducer", producerHandle);
        List oldPortlet = UpgradePortletNames.resourcesSingleton.getResourceList("old", "name", this.docRoot, "portlet", portletHandle);
        List newPortlet = UpgradePortletNames.resourcesSingleton.getResourceList("new", "name", this.docRoot, "portlet", portletHandle);
        if (oldProducer != null && newProducer != null && oldPortlet != null && newPortlet != null) {
            for (int i = 0; i < oldProducer.size(); ++i) {
                Element item = (Element)oldProducer.get(i);
                Element locale = (Element)item.selectSingleNode("locale");
                Element name = (Element)item.selectSingleNode("value");
                String localeStr = locale.getText();
                String oldProducerName = name.getText();
                String newProducerName = this.getPortletInstancePortletOrProducerName(i, localeStr, newProducer);
                String oldPortletName = this.getPortletInstancePortletOrProducerName(i, localeStr, oldPortlet);
                String newPortletName = this.getPortletInstancePortletOrProducerName(i, localeStr, newPortlet);
                String oldSearchPath = "/portletProducer[@name='" + oldProducerName + "']/portlet[@name='" + oldPortletName + "']";
                String newSearchPath = "/portletProducer[@name='" + newProducerName + "']/portlet[@name='" + newPortletName + "']";
                if (portletInstanceSearchPathMappings.containsKey(oldSearchPath)) continue;
                portletInstanceSearchPathMappings.put(oldSearchPath, newSearchPath);
            }
        }
    }

    private String upgradePortletInstanceSearchPath(String oldSearchPath) {
        String newSearchPath = null;
        int idx = oldSearchPath.indexOf("/portletProducer");
        if (idx != -1) {
            String oldSearchPathPrefix = oldSearchPath.substring(0, idx);
            String oldSearchPathSuffix = oldSearchPath.substring(idx);
            newSearchPath = portletInstanceSearchPathMappings.get(oldSearchPathSuffix);
            if (newSearchPath != null) {
                newSearchPath = oldSearchPathPrefix + newSearchPath;
            } else if (!portletInstanceSearchPathMappings_built) {
                portletInstanceSearchPathMappings_built = true;
                this.addPortletInstanceSearchPathMappings("/wsrp/fragments/markup/handle/dashboardportlets", "booklet");
                this.addPortletInstanceSearchPathMappings("/wsrp/fragments/markup/handle/cmm", "watchlist");
                this.addPortletInstanceSearchPathMappings("/wsrp/fragments/markup/handle/cmm", "history_chart");
                newSearchPath = this.upgradePortletInstanceSearchPath(oldSearchPath);
            }
        }
        return newSearchPath;
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String errorMessage = null;
        String upgradeFrom = (String)data.getPropertyValue("UPGRADE_FROM");
        String searchPath = this.getPropertyValue(data, "searchPath");
        String handle = this.getPropertyValue(data, "handle");
        String bindingXML = (String)data.getPropertyValue("binding");
        String portletXML = (String)data.getPropertyValue("portlet");
        String objectClass = bindingXML != null ? "portletProducer" : (portletXML != null ? "portletInstance" : "portlet");
        handle = this.lookupHandle(objectClass, handle, bindingXML);
        if (handle == null) {
            return null;
        }
        Resources r = resourcesSingleton.getResources(this.docRoot, objectClass, handle);
        String upgrade_nameXML = null;
        String upgrade_descriptionXML = null;
        String upgrade_serviceDescriptionXML = null;
        String upgrade_handleXML = null;
        String upgrade_bindingXML = null;
        String upgrade_registrationXML = null;
        String upgrade_portletInstanceXML = null;
        boolean skipImportingObjectDuringDeployment = false;
        try {
            if (this.isUpgradeProperty(handle, "delete")) {
                if (upgradeFrom != null) {
                    if ("DB".equals(upgradeFrom)) {
                        this.delete(searchPath);
                        return null;
                    }
                    if ("DEPLOYMENT".equals(upgradeFrom)) {
                        skipImportingObjectDuringDeployment = true;
                    }
                }
            } else if ("portletInstance".equals(handle) && this.isUpgradeProperty(handle, "searchPath")) {
                upgrade_portletInstanceXML = this.updatePortletInstanceXMLproperty(null, null, portletXML);
            } else {
                if (this.isUpgradeProperty(handle, "name") && (upgrade_nameXML = (String)data.getPropertyValue("name")) != null) {
                    upgrade_nameXML = this.updateName(r, upgrade_nameXML);
                }
                if (this.isUpgradeProperty(handle, "description")) {
                    upgrade_descriptionXML = (String)data.getPropertyValue("description");
                    if (upgrade_descriptionXML != null) {
                        upgrade_descriptionXML = this.updateDescription(r, upgrade_descriptionXML);
                    } else if (r.newDescriptions.size() > 0) {
                        // empty if block
                    }
                }
                if (this.isUpgradeProperty(handle, "handle") && (upgrade_handleXML = (String)data.getPropertyValue("handle")) != null) {
                    upgrade_handleXML = this.updateHandle(upgrade_handleXML, handle);
                }
                if (this.isUpgradeProperty(handle, "serviceDescription")) {
                    upgrade_serviceDescriptionXML = (String)data.getPropertyValue("serviceDescription");
                    String newServiceDescription = resourcesSingleton.getProperty(handle, objectClass, "new", "serviceDescription");
                    upgrade_serviceDescriptionXML = this.updateServiceDescription(handle, newServiceDescription, upgrade_serviceDescriptionXML);
                }
                if (this.isUpgradeProperty(handle, "binding")) {
                    upgrade_bindingXML = (String)data.getPropertyValue("binding");
                    String newBinding = resourcesSingleton.getProperty(handle, objectClass, "new", "binding");
                    upgrade_bindingXML = this.updateBinding(handle, newBinding, upgrade_bindingXML);
                }
                if (this.isUpgradeProperty(handle, "registration")) {
                    upgrade_registrationXML = (String)data.getPropertyValue("registration");
                    String newRegistration = resourcesSingleton.getProperty(handle, objectClass, "new", "registration");
                    upgrade_registrationXML = this.updateRegistration(handle, newRegistration, upgrade_registrationXML);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            errorMessage = t.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setUpgradeStatus(2);
            ArrayList<CMUpgradeMessage> messages = new ArrayList<CMUpgradeMessage>();
            messages.add(new CMUpgradeMessage(errorMessage, 40000));
            result.setMessages(messages);
        } else if (skipImportingObjectDuringDeployment) {
            result.setUpgradeStatus(3);
        } else if (upgrade_nameXML != null || upgrade_descriptionXML != null || upgrade_serviceDescriptionXML != null || upgrade_bindingXML != null || upgrade_registrationXML != null || upgrade_portletInstanceXML != null) {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            if (upgrade_nameXML != null) {
                upgradedData.put("name", upgrade_nameXML);
            }
            if (upgrade_descriptionXML != null) {
                upgradedData.put("description", upgrade_descriptionXML);
            }
            if (upgrade_serviceDescriptionXML != null) {
                upgradedData.put("serviceDescription", upgrade_serviceDescriptionXML);
            }
            if (upgrade_handleXML != null) {
                upgradedData.put("handle", upgrade_handleXML);
            }
            if (upgrade_bindingXML != null) {
                upgradedData.put("binding", upgrade_bindingXML);
            }
            if (upgrade_registrationXML != null) {
                upgradedData.put("registration", upgrade_registrationXML);
            }
            if (upgrade_portletInstanceXML != null) {
                upgradedData.put("portlet", upgrade_portletInstanceXML);
            }
            result.setData(upgradedData);
            result.setUpgradeStatus(1);
        } else {
            result.setUpgradeStatus(0);
        }
        result.setNextAction(1);
        return result;
    }

    private String updateName(Resources r, String nameXML) throws Exception {
        return this.updateXMLproperty(r.oldNames, r.newNames, nameXML);
    }

    protected String updateDescription(Resources r, String descriptionXML) throws Exception {
        return this.updateXMLproperty(r.oldDescriptions, r.newDescriptions, descriptionXML);
    }

    private String wrapXMLPropertyForUpdate(String name, String xmlValue) {
        if (xmlValue != null) {
            Element wrap = DocumentHelper.createElement((String)name);
            wrap.addAttribute(new QName("type", XSI_NAMESPACE), "cm:xmlEncodedXMLProp");
            Element updateValue = wrap.addElement("value");
            updateValue.addAttribute(new QName("type", XSI_NAMESPACE), "cm:xmlEncodedXML");
            updateValue.addText(xmlValue);
            xmlValue = wrap.asXML();
        }
        return xmlValue;
    }

    protected String updateServiceDescription(String producerHandle, String newServiceDescription, String oldServiceDescription) throws Exception {
        String portletHandle;
        boolean portletExists;
        if ("/wsrp/cps4/portlets/utility".equals(producerHandle) && !(portletExists = this.checkIfPortletExists(portletHandle = "htmlsource"))) {
            Element sd = DocumentHelper.parseText((String)newServiceDescription).getRootElement();
            StringBuffer xpath = new StringBuffer();
            xpath.append("./*[local-name()='offeredPortlets'][./*[local-name()='portletHandle' and .='").append(portletHandle).append("']]");
            Element offeredPortlet = (Element)sd.selectSingleNode(xpath.toString());
            if (offeredPortlet != null) {
                offeredPortlet.detach();
                newServiceDescription = sd.asXML();
            }
        }
        if (newServiceDescription != null && !newServiceDescription.equals(oldServiceDescription)) {
            return this.wrapXMLPropertyForUpdate("serviceDescription", newServiceDescription);
        }
        return null;
    }

    private String updateBinding(String handle, String newBinding, String oldBinding) {
        if (newBinding != null && !newBinding.equals(oldBinding)) {
            return this.wrapXMLPropertyForUpdate("binding", newBinding);
        }
        return null;
    }

    private String updateRegistration(String handle, String newRegistration, String oldRegistration) {
        if (newRegistration != null && !newRegistration.equals(oldRegistration)) {
            return this.wrapXMLPropertyForUpdate("registration", newRegistration);
        }
        return null;
    }

    private String updateHandle(String handleXML, String newHandle) throws CMException {
        XMLElement valueEl;
        XMLElement propEl;
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(handleXML);
        if (rootEl != null && (propEl = rootEl.getChild(0)) != null && (valueEl = propEl.getChild(0)) != null) {
            valueEl.value_ = newHandle;
            return propEl.makeXML("", true, false, false);
        }
        return null;
    }

    private boolean checkIfPortletExists(String portletHandle) throws Exception {
        StringBuffer query2 = new StringBuffer();
        String searchpath = "/portal/portalPackage//portlet";
        query2.append("<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n").append("   <search xsi:type=\"xsd:string\">").append(searchpath).append("</search>\n").append("   <properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[").append("1").append("]\">\n").append("       <item xsi:type=\"cm:propEnum\">handle</item>\n").append("   </properties>\n").append("</cm:query>");
        String response = ContentManager.getInstance().ExecuteStaticRequest(query2.toString(), false, true);
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(response));
        Element root = document.getRootElement();
        StringBuffer xpath = new StringBuffer();
        xpath.append(".//*[local-name()='queryResponse']/*[local-name()='queryResult']/*[local-name()='item']").append("/*[local-name()='handle'][./*[local-name()='value' and .='").append(portletHandle).append("']]");
        Node portlet = root.selectSingleNode(xpath.toString());
        return portlet != null;
    }

    private String updateXMLproperty(Map<String, String> oldProps, Map<String, String> newProps, String propXML) throws CMException {
        XMLElement propEl;
        String updatedPropXML = null;
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(propXML);
        if (rootEl != null && (propEl = rootEl.getChild(0)) != null) {
            XMLElement propValueEl = propEl.getOptionalChildWithName("value");
            if (propValueEl != null && propValueEl.children_ != null) {
                for (XMLElement nameEl : propValueEl.children_) {
                    XMLElement nameValueEl = nameEl.getOptionalChildWithName("value");
                    XMLElement localeEl = nameEl.getOptionalChildWithName("locale");
                    String lang = localeEl.value_;
                    if (nameValueEl == null || "".equals(lang)) continue;
                    String oldName = oldProps.get(lang);
                    String newName = newProps.get(lang);
                    if (newName == null || nameValueEl.value_ != null && oldName != null && !nameValueEl.value_.trim().equals(oldName.trim())) continue;
                    nameValueEl.value_ = newName;
                }
            }
            updatedPropXML = propEl.makeXML("", true, false, false);
        }
        return updatedPropXML;
    }

    private String updatePortletInstanceXMLproperty(Map zzzoldProps, Map zzznewProps, String propXML) throws CMException {
        XMLElement portletEl;
        String updatedPropXML = null;
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(propXML);
        if (rootEl != null && (portletEl = rootEl.getChild(0)) != null) {
            XMLElement searchPathValueEl;
            XMLElement searchPathEl;
            XMLElement itemEl;
            XMLElement valueEl = portletEl.getOptionalChildWithName("value");
            if (valueEl != null && (itemEl = valueEl.getOptionalChildWithName("item")) != null && (searchPathEl = itemEl.getOptionalChildWithName("searchPath")) != null && (searchPathValueEl = searchPathEl.getOptionalChildWithName("value")) != null && searchPathValueEl.value_ != null) {
                String upgradedSearchPath = this.upgradePortletInstanceSearchPath(searchPathValueEl.value_);
                if (upgradedSearchPath == null) {
                    return null;
                }
                searchPathValueEl.value_ = upgradedSearchPath;
            }
            updatedPropXML = portletEl.makeXML("", true, false, false);
        }
        return updatedPropXML;
    }

    private void delete(String searchPath) throws Exception {
        String deleteRequest = CMDataUpgradeUtils.buildDelete(searchPath, false);
        String response = ContentManager.getInstance().ExecuteStaticRequest(deleteRequest, false, true);
        if (response == null || response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new Exception("Delete failed:\n" + (response != null ? response : ""));
        }
    }

    private String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && propXML.length() > 0 && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }

    static {
        upgradeHandles.put("/wsrp/cps4/portlets/utility", "|serviceDescription");
        upgradeHandles.put("htmlviewer", "|delete");
        upgradeHandles.put("/wsrp/fragments/markup/handle/dashboardportlets", "|name|description|serviceDescription");
        upgradeHandles.put("booklet", "|name|description|handle");
        upgradeHandles.put("portletInstance", "|searchPath");
        upgradeHandles.put("/wsrp/fragments/markup/handle/cmm", "|name|description|serviceDescription|binding|registration");
        upgradeHandles.put("/wsrp/cps4/portlets/cmm", "|name|description|serviceDescription|binding|registration");
        upgradeHandles.put("watchlist", "|name|description");
        upgradeHandles.put("history_chart", "|name|description");
        XSI_NAMESPACE = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        resourcesSingleton = null;
        portletInstanceSearchPathMappings = new HashMap<String, String>();
        portletInstanceSearchPathMappings_built = false;
    }

    private class Resources {
        public Map<String, String> oldNames = new HashMap<String, String>();
        public Map<String, String> newNames = new HashMap<String, String>();
        public Map<String, String> oldDescriptions = new HashMap<String, String>();
        public Map<String, String> newDescriptions = new HashMap<String, String>();

        private Resources() {
        }

        private List getResourceList(String version, String resourcePropertyName, Element docRoot, String objectClass, String handle) {
            if (handle != null) {
                StringBuffer xpath = new StringBuffer();
                if ("portlet".equals(objectClass)) {
                    xpath.append("/root/cm-resourceList/").append(version).append("/*[local-name()='item'][@xsi:type='cm:portlet'][./*[local-name()='handle']").append("[./*[local-name()='value' and .='").append(handle).append("']]]").append("/*[local-name()='").append(resourcePropertyName).append("']").append("/*[local-name()='value']/*[local-name()='item']");
                } else if ("portletProducer".equals(objectClass)) {
                    xpath.append("/root/cm-resourceList/").append(version).append("/*[local-name()='item'][@xsi:type='cm:portletProducer']").append("[./handle='").append(handle).append("']").append("/*[local-name()='").append(resourcePropertyName).append("']").append("/*[local-name()='value']/*[local-name()='item']");
                }
                return xpath.length() > 0 ? docRoot.selectNodes(xpath.toString()) : null;
            }
            return null;
        }

        private void getResource(Map<String, String> map, String version, String resourcePropertyName, Element docRoot, String objectClass, String handle) {
            List resourceItems = this.getResourceList(version, resourcePropertyName, docRoot, objectClass, handle);
            if (resourceItems != null) {
                for (int i = 0; i < resourceItems.size(); ++i) {
                    Element item = (Element)resourceItems.get(i);
                    Element locale = (Element)item.selectSingleNode("locale");
                    Element name = (Element)item.selectSingleNode("value");
                    String localeStr = locale.getText();
                    String nameStr = name.getText();
                    map.put(localeStr, nameStr);
                }
            }
        }

        public Resources getResources(Element docRoot, String objectClass, String handle) {
            Resources r = new Resources();
            this.getResource(r.oldNames, "old", "name", docRoot, objectClass, handle);
            this.getResource(r.oldDescriptions, "old", "description", docRoot, objectClass, handle);
            this.getResource(r.newNames, "new", "name", docRoot, objectClass, handle);
            this.getResource(r.newDescriptions, "new", "description", docRoot, objectClass, handle);
            return r;
        }

        public String getProperty(String handle, String objectClass, String version, String propertyName) {
            if (handle != null && "portletProducer".equals(objectClass)) {
                StringBuffer xpath = new StringBuffer();
                xpath.append("/root/cm-resourceList/").append(version).append("/*[local-name()='item'][@xsi:type='cm:portletProducer']").append("[./handle='").append(handle).append("']").append("/*[local-name()='").append(propertyName).append("']").append("/*[local-name()='value']");
                Element propertyEle = (Element)UpgradePortletNames.this.docRoot.selectSingleNode(xpath.toString());
                if (propertyEle != null) {
                    return propertyEle.getText();
                }
            }
            return null;
        }
    }
}

