/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.bering;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class UpgradeWSRPPortletToFragment
implements CMUpgradePlugin {
    private static final Namespace CPS_ROUTING_NAMESPACE = new Namespace("r", "http://developer.cognos.com/schemas/fragments/routing/1/");
    private static final Namespace CPS_WSDL_EXT_NAMESPACE = new Namespace("cpsext", "http://developer.cognos.com/schemas/cps/wsdl/extensions/1/");
    private static final Namespace XSI_NAMESPACE = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");

    public void initialize(CMPluginDescriptor arg0, ICCLConfiguration arg1) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        boolean upgraded = false;
        HashMap<String, String> resultData = null;
        String errorMessage = null;
        try {
            String address;
            Element wsrpBaseServicePort;
            Element bindingElement;
            Element wsrpService;
            String binding = this.getPropertyValue(data, "binding");
            if (binding != null && (wsrpService = (Element)(bindingElement = DocumentHelper.parseText((String)binding).getRootElement()).selectSingleNode("*[local-name()='service']")) != null && (wsrpBaseServicePort = (Element)wsrpService.selectSingleNode("*[local-name()='port' and @name='WSRPBaseService']")) != null && ((address = wsrpBaseServicePort.valueOf("*[local-name()='address']/@location")).endsWith("wsrp/cps4/portlets/nav") || address.endsWith("wsrp/cps4/portlets/utility"))) {
                this.addCPSPortletAddress(wsrpBaseServicePort, address);
                this.addFragmentRouting(wsrpService, address);
                Element bindingUpdate = DocumentHelper.createElement((String)"binding");
                bindingUpdate.addAttribute(new QName("type", XSI_NAMESPACE), "cm:xmlEncodedXMLProp");
                Element bindingUpdateValue = bindingUpdate.addElement("value");
                bindingUpdateValue.addAttribute(new QName("type", XSI_NAMESPACE), "cm:xmlEncodedXML");
                bindingUpdateValue.addText(bindingElement.asXML());
                resultData = new HashMap<String, String>();
                resultData.put("binding", bindingUpdate.asXML());
                upgraded = true;
            }
        }
        catch (Throwable t) {
            errorMessage = t.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (upgraded) {
            result.setUpgradeStatus(1);
            result.setData(resultData);
        } else if (errorMessage != null) {
            result.setUpgradeStatus(2);
        } else {
            result.setUpgradeStatus(0);
        }
        result.setNextAction(1);
        return result;
    }

    private void addFragmentRouting(Element wsrpService, String address) {
        Element subSegment;
        QName segmentQName = new QName("segment", CPS_ROUTING_NAMESPACE);
        List elements = wsrpService.elements(segmentQName);
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                wsrpService.remove((Element)it.next());
            }
        }
        Element routing = DocumentHelper.createElement((QName)segmentQName);
        routing.addAttribute("name", "dashboardportlets");
        if (address.endsWith("wsrp/cps4/portlets/nav")) {
            subSegment = routing.addElement(segmentQName);
            subSegment.addAttribute("name", "viewer");
            subSegment.addAttribute("set", "/fragmentproducer/utilities/universal-viewer$path");
            subSegment = routing.addElement(segmentQName);
            subSegment.addAttribute("name", "navigator");
            subSegment.addAttribute("set", "/wsrp/$segment[1]");
            subSegment = routing.addElement(segmentQName);
            subSegment.addAttribute("name", "search");
            subSegment.addAttribute("set", "/wsrp/$segment[1]");
        } else if (address.endsWith("wsrp/cps4/portlets/utility")) {
            subSegment = routing.addElement(segmentQName);
            subSegment.addAttribute("name", "htmlsource");
            subSegment.addAttribute("set", "/fragmentproducer/utilities/htmlviewer$path");
            subSegment = routing.addElement(segmentQName);
            subSegment.addAttribute("name", "html");
            subSegment.addAttribute("set", "/wsrp/$segment[1]");
            subSegment = routing.addElement(segmentQName);
            subSegment.addAttribute("name", "bookmarks");
            subSegment.addAttribute("set", "/wsrp/$segment[1]");
            subSegment = routing.addElement(segmentQName);
            subSegment.addAttribute("name", "image");
            subSegment.addAttribute("set", "/wsrp/$segment[1]");
            subSegment = routing.addElement(segmentQName);
            subSegment.addAttribute("name", "rss");
            subSegment.addAttribute("set", "/wsrp/$segment[1]");
        }
        List content = wsrpService.content();
        content.add(0, routing);
        wsrpService.setContent(content);
    }

    private void addCPSPortletAddress(Element wsdlPort, String address) {
        QName portletAddressQName = new QName("portletAddress", CPS_WSDL_EXT_NAMESPACE);
        List elements = wsdlPort.elements(portletAddressQName);
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                wsdlPort.remove((Element)it.next());
            }
        }
        Element portletAddress = wsdlPort.addElement(portletAddressQName);
        portletAddress.addAttribute("location", "bus://wsrp/fragments/markup/handle/dashboardportlets");
        if (address.endsWith("wsrp/cps4/portlets/nav")) {
            portletAddress.addAttribute("handle", "viewer");
        } else if (address.endsWith("wsrp/cps4/portlets/utility")) {
            portletAddress.addAttribute("handle", "htmlsource");
        }
    }

    private String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && propXML.length() > 0 && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }
}

