/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.danube;

import com.cognos.cm.plugin.cps.upgrade.BaseUpgradeCogadminTabSequence;
import com.cognos.cm.server.CMException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeCogadminTabSequence
extends BaseUpgradeCogadminTabSequence {
    private static Pattern SP_PATTERN = Pattern.compile("portalPackage.*/pageletFolder.*/pageletFolder.*/pageletFolder.*/pagelet");

    @Override
    protected String upgradeToNewValue(String searchPath, String nameXML, String displaySequenceXML) throws CMException {
        String upgradeNewValue = null;
        boolean foundPagelet = false;
        if (searchPath != null) {
            Matcher m = SP_PATTERN.matcher(searchPath);
            boolean bl = foundPagelet = m != null ? m.find() : false;
        }
        if (foundPagelet && nameXML != null && displaySequenceXML != null) {
            if (this.isMatched("Current Activities", nameXML)) {
                upgradeNewValue = "60";
            } else if (this.isMatched("Past Activities", nameXML)) {
                upgradeNewValue = "50";
            } else if (this.isMatched("Upcoming Activities", nameXML)) {
                upgradeNewValue = "40";
            } else if (this.isMatched("Data Stores", nameXML) || this.isMatched("Dynamic Cubes", nameXML)) {
                upgradeNewValue = "30";
            } else if (this.isMatched("System", nameXML)) {
                upgradeNewValue = "20";
            } else if (this.isMatched("Schedules", nameXML)) {
                upgradeNewValue = "10";
            }
        }
        return upgradeNewValue;
    }
}

