/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.titan;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;

public class RemoveGoSearchAdminPortlets
implements CMUpgradePlugin {
    private static final String GO_SEARCH_PAGELET_FOLDER_NAME = "Index Search";
    private static final String GO_SEARCH_PORTLET_PRODUCER_NAME = "IBM Cognos Go! Search";
    private static final String GO_SEARCH_ADMIN_PORTLET_PRODUCER_NAME = "IBM Cognos Go! Search Admin";

    public void initialize(CMPluginDescriptor arg0, ICCLConfiguration arg1) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String upgradeFrom = (String)data.getPropertyValue("UPGRADE_FROM");
        String searchPath = this.getPropertyValue(data, "searchPath");
        CMUpgradeResult result = new CMUpgradeResult();
        String errorMessage = null;
        boolean toUpgrade = false;
        try {
            toUpgrade = this.checkForUpgrade(data, upgradeFrom);
        }
        catch (Exception ex) {
            errorMessage = ex.getMessage();
        }
        if (errorMessage != null) {
            result.setUpgradeStatus(2);
            ArrayList<CMUpgradeMessage> messages = new ArrayList<CMUpgradeMessage>();
            messages.add(new CMUpgradeMessage(errorMessage, 40000));
            result.setMessages(messages);
        } else if (toUpgrade) {
            if ("DEPLOYMENT".equals(upgradeFrom)) {
                result.setUpgradeStatus(3);
            } else {
                this.delete(searchPath);
                result.setUpgradeStatus(1);
            }
        } else {
            result.setUpgradeStatus(0);
        }
        result.setNextAction(1);
        return result;
    }

    private String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && propXML.length() > 0 && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }

    private void delete(String searchPath) throws Exception {
        String deleteRequest = CMDataUpgradeUtils.buildDelete(searchPath, true);
        String response = ContentManager.getInstance().ExecuteStaticRequest(deleteRequest, false, true);
        if (response == null || response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new Exception("Delete failed:\n" + (response != null ? response : ""));
        }
    }

    private boolean checkForUpgrade(CMUpgradeData data, String upgradeFrom) throws Exception {
        boolean found = false;
        String objectClass = "DB".equals(upgradeFrom) ? this.getPropertyValue(data, "objectClass") : (String)data.getPropertyValue("objectClass");
        if (objectClass.equals("indexUpdateTask")) {
            found = true;
        } else {
            String name;
            String nameXML = (String)data.getPropertyValue("name");
            if (nameXML != null && !nameXML.isEmpty() && (name = this.extractNameStartsWithLocalPrefix(nameXML, "en")) != null && (objectClass.equals("pageletFolder") && name.equals(GO_SEARCH_PAGELET_FOLDER_NAME) || objectClass.equals("portletProducer") && (name.equals(GO_SEARCH_PORTLET_PRODUCER_NAME) || name.equals(GO_SEARCH_ADMIN_PORTLET_PRODUCER_NAME)))) {
                found = true;
            }
        }
        return found;
    }

    private String extractNameStartsWithLocalPrefix(String propXML, String locale) throws CMException {
        XMLElement propValueEl;
        XMLElement propEl;
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(propXML);
        if (rootEl != null && (propEl = rootEl.getChild(0)) != null && (propValueEl = propEl.getOptionalChildWithName("value")) != null && propValueEl.children_ != null) {
            for (XMLElement nameEl : propValueEl.children_) {
                XMLElement nameValueEl = nameEl.getOptionalChildWithName("value");
                XMLElement localeEl = nameEl.getOptionalChildWithName("locale");
                String lang = localeEl.value_;
                if (nameValueEl == null || nameValueEl.value_ == null || !lang.startsWith(locale)) continue;
                return nameValueEl.value_;
            }
        }
        return null;
    }
}

