/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.qs;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.qfw.V4toV5.IntraBeringMunConversion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class QSUpgradeMiniQuery
implements CMUpgradePlugin {
    private static final String PROP_SPECIFICATION = "specification";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static String UPGRADE_TEMPLATE = "QSUpgrade.xsl";
    private static TransformerFactory tFactory = null;
    private static Templates templates = null;

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration cfg) throws Exception {
        if (tFactory == null || templates == null) {
            String str;
            String sUpgradeTemplate = UPGRADE_TEMPLATE;
            if (desc != null && (str = desc.getCLibName()) != null) {
                sUpgradeTemplate = str;
            }
            try {
                tFactory = TransformerFactory.newInstance();
                if (cfg != null) {
                    String folder = cfg.resolveEffectivePath("../bin");
                    File libFile = new File(folder, sUpgradeTemplate);
                    templates = tFactory.newTemplates(new StreamSource(libFile));
                } else {
                    templates = tFactory.newTemplates(new StreamSource(new File(sUpgradeTemplate)));
                }
            }
            catch (TransformerConfigurationException e) {
                throw new Exception("Upgrade templates missing. Query Studio is not installed.");
            }
        }
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String sMiniQuerySpec = (String)data.getPropertyValue(PROP_SPECIFICATION);
        if (sMiniQuerySpec == null) {
            return null;
        }
        boolean hasError = false;
        boolean upgraded = false;
        CMUpgradeResult result = new CMUpgradeResult();
        try {
            int iMajorVersion = this.retrieveVersion("majorVersion", sMiniQuerySpec);
            if (iMajorVersion < 2) {
                if (data.getProperties().contains("UPGRADE_REPORT")) {
                    sMiniQuerySpec = this.migrate(sMiniQuerySpec);
                    upgraded = true;
                }
            } else if (data.getProperties().contains("PLUGIN_VERSION")) {
                int iMinorVersion = this.retrieveVersion("minorVersion", sMiniQuerySpec);
                if (iMajorVersion == 2 && iMinorVersion < 11) {
                    sMiniQuerySpec = this.upgradeMUNs(sMiniQuerySpec);
                }
                sMiniQuerySpec = this.migrate(sMiniQuerySpec);
                upgraded = true;
            }
        }
        catch (Throwable t) {
            hasError = true;
            result.setMessage(t.getMessage());
        }
        if (upgraded) {
            result.setUpgradeStatus(1);
            HashMap<String, String> mapV5Spec = new HashMap<String, String>();
            mapV5Spec.put(PROP_SPECIFICATION, sMiniQuerySpec);
            result.setData(mapV5Spec);
        } else if (hasError) {
            result.setUpgradeStatus(2);
        } else {
            result.setUpgradeStatus(0);
        }
        result.setNextAction(1);
        return result;
    }

    public int retrieveVersion(String sVersionType, String sMiniQuery) throws NumberFormatException {
        int iVersion = -1;
        sVersionType = sVersionType + "=\"";
        int iVersionStart = sMiniQuery.indexOf(sVersionType) + sVersionType.length();
        int iVersionEnd = sMiniQuery.indexOf(34, iVersionStart);
        sVersionType = sMiniQuery.substring(iVersionStart, iVersionEnd);
        iVersion = Integer.parseInt(sVersionType);
        return iVersion;
    }

    private String transform(String sSrc) throws Exception {
        Transformer transformer = templates.newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(sSrc)), new StreamResult(writer));
        return writer.toString();
    }

    public String upgradeMUNs(String sSrc) throws Exception {
        String sMUNs = this.collectMUNs(sSrc);
        IntraBeringMunConversion oIntraBeringMunConversion = new IntraBeringMunConversion();
        sMUNs = oIntraBeringMunConversion.doMUNListConversion(sMUNs);
        HashMap<String, String> hmssMUNMap = this.createMUNMap(sMUNs);
        Set<String> arKeys = hmssMUNMap.keySet();
        for (String sKey : arKeys) {
            String sValue = hmssMUNMap.get(sKey);
            sKey = this.xmlencode(sKey);
            sValue = this.xmlencode(sValue);
            sSrc = this.doReplace(sSrc, sKey, sValue);
        }
        return sSrc;
    }

    public String collectMUNs(String sSrc) throws Exception {
        if (sSrc.length() <= 0) {
            return "<upgradeMembers><members></members></upgradeMembers>";
        }
        SAXParserFactory oParserFactory = SAXParserFactory.newInstance();
        SAXParser oParser = oParserFactory.newSAXParser();
        MUNHandler oMUNCollectionHandler = new MUNHandler();
        oParser.parse(new InputSource(new StringReader(sSrc)), (DefaultHandler)oMUNCollectionHandler);
        return oMUNCollectionHandler.getMUNXML();
    }

    public HashMap<String, String> createMUNMap(String sMUNConversionXML) throws Exception {
        SAXParserFactory oParserFactory = SAXParserFactory.newInstance();
        SAXParser oParser = oParserFactory.newSAXParser();
        MUNConversionHandler oMUNConversionHandler = new MUNConversionHandler();
        oParser.parse(new InputSource(new StringReader(sMUNConversionXML)), (DefaultHandler)oMUNConversionHandler);
        return oMUNConversionHandler.getMUNMap();
    }

    private String xmlencode(String value) {
        int rsize = value.length() * 4;
        StringBuffer sbuf = new StringBuffer(rsize);
        block7: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\'': {
                    sbuf.append("&apos;");
                    continue block7;
                }
                case '<': {
                    sbuf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block7;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
        return sbuf.toString();
    }

    private String doReplace(String sSource, String sOrigString, String sNewString) {
        if (sSource == null) {
            return "";
        }
        if (sOrigString == null || sNewString == null) {
            return sSource;
        }
        int iLen = sOrigString.length();
        StringBuffer sSourceBuf = new StringBuffer();
        int iFound = -1;
        int iStart = 0;
        while ((iFound = sSource.indexOf(sOrigString, iStart)) >= 0) {
            sSourceBuf.append(sSource.substring(iStart, iFound));
            sSourceBuf.append(sNewString);
            iStart = iFound + iLen;
        }
        sSourceBuf.append(sSource.substring(iStart));
        return sSourceBuf.toString();
    }

    private String migrate(String sMiniQuery) throws Exception {
        return this.transform(sMiniQuery);
    }

    public static void main(String[] args) {
        try {
            String line;
            if (args.length < 3 || args[0].equals("-h")) {
                System.out.println("\nUsage:\n\tjava com.cognos.cm.plugin.qs.QSUpgradeMiniQuery FILE SOURCEDIR DESTDIR\n");
                System.out.println("FILE: input mini-query file name, .xml will automatically be appended");
                System.out.println("SOURCEDIR: directory where the mini-query exists");
                System.out.println("DESTDIR: directory to write out upgraded mini-query");
                System.exit(1);
            }
            String sFile = args[0];
            String sSrcDir = args[1];
            String sDestDir = args[2];
            StringBuffer sb = new StringBuffer(sSrcDir);
            String sSrcFile = sb.append(FILE_SEPARATOR).append(sFile).append(".xml").toString();
            sb.setLength(0);
            String sDestFile = sb.append(sDestDir).append(FILE_SEPARATOR).append(sFile).append("_migrated.xml").toString();
            StringBuffer sbMiniSpec = new StringBuffer();
            BufferedReader brMiniSpec = new BufferedReader(new FileReader(sSrcFile));
            while ((line = brMiniSpec.readLine()) != null) {
                sbMiniSpec.append(line);
            }
            QSUpgradeMiniQuery m = new QSUpgradeMiniQuery();
            m.initialize(null, null);
            String sMiniSpec = sbMiniSpec.toString();
            int iMajorVersion = m.retrieveVersion("majorVersion", sMiniSpec);
            int iMinorVersion = m.retrieveVersion("minorVersion", sMiniSpec);
            String sResult = m.migrate(sMiniSpec);
            if (iMajorVersion == 2 && iMinorVersion < 11) {
                sResult = m.upgradeMUNs(sResult);
            }
            m.terminate();
            BufferedWriter bw = new BufferedWriter(new FileWriter(sDestFile));
            bw.write(sResult);
            bw.flush();
            bw.close();
            System.out.println("Migration successful!\nResult in " + sDestFile);
            System.out.println("---------------------------------------------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class MUNHandler
    extends DefaultHandler {
        private String m_sMUNXML = "<upgradeMembers><members>";
        private String m_sListSeparator = ",";
        private boolean m_bIsFEWithMUN = false;

        private MUNHandler() {
        }

        @Override
        public void startElement(String sUri, String sLocalName, String sQname, Attributes oAttributes) {
            if (sQname == null) {
                return;
            }
            int iAttributeIdx = 0;
            if (sQname.equals("CRQReport")) {
                iAttributeIdx = oAttributes.getIndex("listSeparator");
                if (iAttributeIdx >= 0) {
                    this.m_sListSeparator = oAttributes.getValue(iAttributeIdx);
                }
            } else if (sQname.equals("Column") && this.isMUN(oAttributes)) {
                String sExpressionMUN = oAttributes.getValue("expression");
                if (sExpressionMUN == null) {
                    return;
                }
                if (sExpressionMUN.indexOf("_memberCaption") >= 0) {
                    int iMUNLocation = this.findMUNLocationInExpression(sExpressionMUN);
                    if (iMUNLocation < 0) {
                        return;
                    }
                    int iEndMUNLocation = sExpressionMUN.indexOf(")" + this.m_sListSeparator, iMUNLocation);
                    if (iEndMUNLocation < 0) {
                        return;
                    }
                    sExpressionMUN = sExpressionMUN.substring(iMUNLocation, iEndMUNLocation);
                }
                if (sExpressionMUN.indexOf("children") >= 0) {
                    int iOpenBracket = sExpressionMUN.indexOf(40);
                    if (iOpenBracket < 0) {
                        return;
                    }
                    int iCloseBracket = sExpressionMUN.lastIndexOf(41);
                    if (iCloseBracket < 0 || iCloseBracket < iOpenBracket) {
                        return;
                    }
                    this.addMUNToXML(sExpressionMUN.substring(iOpenBracket + 1, iCloseBracket));
                } else {
                    this.addMUNToXML(sExpressionMUN);
                }
            } else if (sQname.equals("FE") && this.isMUN(oAttributes)) {
                this.m_bIsFEWithMUN = true;
            } else if (sQname.equals("Value") && this.m_bIsFEWithMUN && (iAttributeIdx = oAttributes.getIndex("use")) >= 0) {
                this.addMUNToXML(oAttributes.getValue(iAttributeIdx));
            }
        }

        @Override
        public void endElement(String sUri, String sLocalName, String sQname) {
            if (sQname != null && sQname.equals("FE")) {
                this.m_bIsFEWithMUN = false;
            }
        }

        public boolean isMUN(Attributes oAttributes) {
            int iAttributeIdx = -1;
            iAttributeIdx = oAttributes.getIndex("dataType");
            if (iAttributeIdx >= 0 && oAttributes.getValue(iAttributeIdx).equals("MUN")) {
                return true;
            }
            iAttributeIdx = oAttributes.getIndex("originalExpression");
            if (iAttributeIdx >= 0) {
                return true;
            }
            iAttributeIdx = oAttributes.getIndex("metadataType");
            if (iAttributeIdx >= 0) {
                String sExpression;
                if (oAttributes.getValue(iAttributeIdx).equals("member")) {
                    return true;
                }
                if (oAttributes.getValue(iAttributeIdx).equals("calculation") && (sExpression = oAttributes.getValue("expression")) != null && sExpression.indexOf("_memberCaption") >= 0) {
                    return true;
                }
            }
            return false;
        }

        public void addMUNToXML(String sMUN) {
            this.m_sMUNXML = this.m_sMUNXML + "<member>" + QSUpgradeMiniQuery.this.xmlencode(sMUN) + "</member>";
        }

        public String getMUNXML() throws Exception {
            this.m_sMUNXML = this.m_sMUNXML + "</members></upgradeMembers>";
            return this.m_sMUNXML;
        }

        private int findMUNLocationInExpression(String sExpression) {
            if (sExpression == null) {
                return -1;
            }
            String sSearchFor = "_memberCaption'" + this.m_sListSeparator;
            int iLocation = sExpression.indexOf(sSearchFor);
            if (iLocation < 0 && (iLocation = sExpression.indexOf(sSearchFor = "_memberCaption&apos;" + this.m_sListSeparator)) < 0) {
                return -1;
            }
            if ((iLocation += sSearchFor.length()) > sExpression.length()) {
                return -1;
            }
            while (iLocation < sExpression.length() && sExpression.charAt(iLocation) == ' ') {
                ++iLocation;
            }
            return iLocation;
        }
    }

    private class MUNConversionHandler
    extends DefaultHandler {
        HashMap<String, String> m_hmssMUNMap = new HashMap();

        private MUNConversionHandler() {
        }

        @Override
        public void startElement(String sUri, String sLocalName, String sQname, Attributes oAttributes) {
            if (sQname.equals("member")) {
                int iOrigMUNIdx = oAttributes.getIndex("mun");
                int iRepMUNIdx = oAttributes.getIndex("replacement");
                if (iOrigMUNIdx >= 0 && iRepMUNIdx >= 0) {
                    this.m_hmssMUNMap.put(oAttributes.getValue(iOrigMUNIdx), oAttributes.getValue(iRepMUNIdx));
                }
            }
        }

        public HashMap<String, String> getMUNMap() {
            return this.m_hmssMUNMap;
        }
    }
}

