/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.properties;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cmutils.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMMembers {
    private String membersString_;

    public CMMembers(String members) {
        this.membersString_ = members;
    }

    public static CMMembers parseDOMElement(Element membersElement) throws CMException {
        NodeList children = membersElement.getChildNodes();
        CMObjectClasses classes = CMExecutionContext.get().getStore().getObjectClasses();
        StringBuffer membersString = new StringBuffer(1024);
        for (int i = 0; i < children.getLength(); ++i) {
            Node idAttr;
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            String elName = node.getLocalName();
            NamedNodeMap attrs = node.getAttributes();
            CMObjectClass objectClass = classes.getClassByName(elName);
            if (objectClass == null || attrs == null) {
                throw new CMException("cmPropInvalidContent", new CMException.Parm("Property", CMProperty.MEMBERS.getName()));
            }
            Node node2 = idAttr = attrs.getNamedItem("id") == null ? attrs.getNamedItem("path") : attrs.getNamedItem("id");
            if (idAttr == null) {
                throw new CMException("cmPropMissingAttr", new CMException.Parm("Property", CMProperty.MEMBERS.getName()), new CMException.Parm("Attribute", "id"));
            }
            membersString.append("<");
            membersString.append(objectClass.getName());
            membersString.append(" ");
            membersString.append(idAttr.getLocalName());
            membersString.append("=\"");
            membersString.append(XMLUtils.encode((String)idAttr.getNodeValue()));
            membersString.append("\"/>");
        }
        return new CMMembers(membersString.toString());
    }

    public String toString() {
        return this.membersString_;
    }
}

