/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.properties;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMNamedReference;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMRepositoryRule;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cmutils.path.SearchPathEncoder;
import com.cognos.cmutils.xml.XMLUtils;
import java.util.ArrayList;

public class CMPropertyTypeRender {
    public static final String renderStringValueAsXML(String value) {
        return XMLUtils.escape((String)value, (boolean)false);
    }

    private static void renderArrayIntoBuffer(StringBuffer buffer, String tag, String type, CMArrayPropertyValue arrayValue, CMProperty prop, int nTabs) {
        String tabs = CMStringUtils.getTabs(nTabs);
        String tabs1 = CMStringUtils.getTabs(nTabs + 1);
        buffer.append("\r\n").append(tabs).append('<').append(tag);
        if (arrayValue == null || arrayValue.getSize() == 0) {
            buffer.append(" xsi:nil=\"true\"/>");
        } else {
            buffer.append(" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"").append(type).append("[]\">");
            int n = arrayValue.getSize();
            for (int i = 0; i < n; ++i) {
                buffer.append("\r\n").append(tabs1).append("<item xsi:type=\"").append(type).append("\">").append(arrayValue.getXMLItemContent(i, prop, 0)).append("\r\n").append(tabs1).append("</item>");
            }
            buffer.append("\r\n").append(tabs).append("</").append(tag).append(">");
        }
    }

    private static void renderBaseClassArrayIntoBuffer(StringBuffer buffer, String tag, CMBaseClassArray array, CMProperty prop, int nTabs) {
        String tabs = CMStringUtils.getTabs(nTabs);
        String tabs1 = CMStringUtils.getTabs(nTabs + 1);
        buffer.append("\r\n").append(tabs).append("<").append(tag);
        if (array == null || array.getSize() == 0 || array.getSize() > 0 && array.getItem(0) == null) {
            buffer.append(" xsi:nil=\"true\"/>");
        } else {
            buffer.append(" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:baseClass[]\">");
            int bcCount = array.getSize();
            for (int bcIdx = 0; bcIdx < bcCount; ++bcIdx) {
                String className = "nil";
                CMObjectClass objClass = array.getReference(bcIdx).getObjectClass();
                if (objClass != null) {
                    className = objClass.getName();
                }
                buffer.append("\r\n").append(tabs1).append("<item xsi:type=\"cm:").append(className).append("\">").append("\r\n");
                buffer.append(array.getXMLItemContent(bcIdx, prop, nTabs + 2));
                buffer.append("\r\n").append(tabs1).append("</item>");
            }
            buffer.append("\r\n").append(tabs).append("</").append(tag).append('>');
        }
    }

    public static CMProperty getBaseClassArraySubproperty(CMProperty prop) {
        ArrayList<? extends CMProperty> subproperties = prop.getSubproperties();
        for (int i = 0; i < subproperties.size(); ++i) {
            CMProperty subProp = subproperties.get(i);
            if (subProp.getType() != CMPropertyTypes.BIBUS_BASECLASSARRAY) continue;
            return subProp;
        }
        throw new IllegalStateException("Unexpected: Can't find baseClassArray subproperty");
    }

    public static final String renderNamedReferenceAsXML(CMNamedReference namedReference, CMProperty prop, int nTabs) {
        if (namedReference == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        CMPropertyTypeRender.renderArrayIntoBuffer(buffer, "name", "cm:multilingualToken", namedReference.getName(), prop, nTabs);
        CMProperty objectsProp = CMPropertyTypeRender.getBaseClassArraySubproperty(prop);
        CMBaseClassArray objects = namedReference.getObjects();
        CMPropertyTypeRender.renderBaseClassArrayIntoBuffer(buffer, objectsProp.getName(), objects, objectsProp, nTabs);
        return buffer.toString();
    }

    public static final String renderAncestorItemValueAsXML(String title, String searchPath, String objClass, String storeID) {
        if (title == null) {
            title = "";
        }
        if (searchPath == null) {
            searchPath = "";
        }
        StringBuffer buffer = new StringBuffer(title.length() + searchPath.length() + 128);
        buffer.append("<objectClass xsi:type=\"cm:classEnum\">").append(objClass).append("</objectClass>");
        buffer.append("<searchPath xsi:type=\"xsd:string\">");
        buffer.append(XMLUtils.escape((String)searchPath));
        buffer.append("</searchPath>");
        buffer.append("<storeID xsi:type=\"cm:").append(CMProperty.STOREID.getType().getName()).append("\">");
        buffer.append(XMLUtils.escape((String)storeID));
        buffer.append("</storeID>");
        buffer.append("<title xsi:type=\"xsd:string\">");
        buffer.append(XMLUtils.escape((String)title));
        buffer.append("</title>");
        return buffer.toString();
    }

    public static final String renderRetentionRuleAsXML(CMRetentionRule rule) {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("<objectClass xsi:type=\"cm:classEnum\">");
        buffer.append(rule.getObjectClass().getName());
        buffer.append("</objectClass><prop xsi:type=\"cm:propEnum\">");
        buffer.append(rule.getProperty().getName());
        buffer.append("</prop>");
        if (rule.getMaxObjects() >= 0) {
            buffer.append("<maxObjects xsi:type=\"xsd:integer\">");
            buffer.append(rule.getMaxObjects());
            buffer.append("</maxObjects>");
        }
        if (rule.getMaxDuration() != null) {
            buffer.append("<maxDuration xsi:type=\"xsd:string\">");
            buffer.append(rule.getMaxDuration());
            buffer.append("</maxDuration>");
        }
        return buffer.toString();
    }

    public static final String renderRepositoryRuleAsXML(CMRepositoryRule rule) {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("<objectClass xsi:type=\"cm:classEnum\">");
        buffer.append(rule.getObjectClass().getName());
        buffer.append("</objectClass><dataSourceName xsi:type=\"xsd:string\">");
        buffer.append(rule.getDataSourceName());
        buffer.append("</dataSourceName>");
        return buffer.toString();
    }

    public static final String renderBaseClassSearchPathAsXML(String value, int nTabs) {
        if (value == null) {
            value = "";
        }
        StringBuffer buffer = new StringBuffer(value.length() + 120);
        buffer.append(CMStringUtils.getTabs(nTabs)).append("<searchPath xsi:type=\"cm:stringProp\">").append("\r\n").append(CMStringUtils.getTabs(nTabs + 1)).append("<value xsi:type=\"xsd:string\" xml:space=\"preserve\">").append(CMPropertyTypeRender.renderStringValueAsXML(value)).append("</value>").append("\r\n").append(CMStringUtils.getTabs(nTabs)).append("</searchPath>");
        return buffer.toString();
    }

    public static final String renderStoreIDAsXML(String value, int nTabs) {
        if (value == null) {
            value = "";
        }
        StringBuffer buffer = new StringBuffer(value.length() + 120);
        buffer.append(CMStringUtils.getTabs(nTabs)).append("<storeID xsi:type=\"cm:").append(CMProperty.STOREID.getType().getName()).append("Prop\">").append("\r\n").append(CMStringUtils.getTabs(nTabs + 1)).append("<value xsi:type=\"cm:").append(CMProperty.STOREID.getType().getName()).append("\" xml:space=\"preserve\">").append(CMPropertyTypeRender.renderStringValueAsXML(value)).append("</value>").append("\r\n").append(CMStringUtils.getTabs(nTabs)).append("</storeID>");
        return buffer.toString();
    }

    public static final String renderObjectReferenceAsXML(CMProperty prop, CMObjectReference ref, int nTabs, boolean outputSearchPathAsStoreId) {
        if (ref == null) {
            ref = new CMDbStoreObjectReference("");
        }
        String storeID = ref.getStoreID();
        String xml = outputSearchPathAsStoreId && storeID != null ? CMPropertyTypeRender.renderBaseClassSearchPathAsXML(CMConstants.FUNC_STOREID_DEF.getName() + "(" + SearchPathEncoder.quoteString((String)storeID) + ")", nTabs) : CMPropertyTypeRender.renderBaseClassSearchPathAsXML(ref.getSearchPath(), nTabs);
        if (storeID == null && prop.getType() == CMPropertyTypes.BIBUS_BASECLASSARRAY) {
            storeID = "";
        }
        if (storeID != null) {
            xml = xml + "\r\n" + CMPropertyTypeRender.renderStoreIDAsXML(storeID, nTabs);
        }
        return xml;
    }

    public static final String renderNameValuePairAsXML(String name, String value) {
        if (name == null) {
            name = "";
        }
        int valueLength = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(name.length() + valueLength + 128);
        buffer.append("<name xsi:type=\"xsd:string\">");
        buffer.append(CMPropertyTypeRender.renderStringValueAsXML(name));
        buffer.append("</name>");
        if (value != null && value.startsWith("<value")) {
            buffer.append(value);
        } else if (value != null) {
            buffer.append("<value xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:parmValueItem[1]\"><item xsi:type=\"simpleParmValueItem\">");
            String valueAsXML = CMPropertyTypeRender.renderStringValueAsXML(value);
            buffer.append("<display xsi:type=\"xsd:string\">");
            buffer.append(valueAsXML);
            buffer.append("</display><use xsi:type=\"xsd:string\">");
            buffer.append(valueAsXML);
            buffer.append("</use></item></value>");
        }
        return buffer.toString();
    }

    public static final String renderLocalizedStringAsXML(CMStringLocale locale, String value) {
        String localeID = locale == null ? "" : locale.getLocaleID();
        if (value == null) {
            value = "";
        }
        int nLen = value.length();
        StringBuffer buffer = new StringBuffer(localeID.length() + nLen + 128);
        buffer.append("<locale xsi:type=\"xsd:string\">");
        buffer.append(localeID);
        buffer.append("</locale><value xsi:type=\"xsd:string\">");
        if (nLen > 0) {
            buffer.append(CMPropertyTypeRender.renderStringValueAsXML(value));
        }
        buffer.append("</value>");
        return buffer.toString();
    }
}

