/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.properties;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMXMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CMRetention {
    String retentionString_;
    List entries_ = new ArrayList();

    public CMRetention() {
    }

    public CMRetention(String retention) {
        this();
        this.retentionString_ = retention;
    }

    public Policy getPolicy(CMObjectClass forClass) throws CMException {
        if (this.entries_.size() == 0 && this.retentionString_ != null) {
            this.parseString();
        }
        for (int i = 0; i < this.entries_.size(); ++i) {
            if (((Policy)this.entries_.get(i)).getObjectClass() != forClass) continue;
            return (Policy)this.entries_.get(i);
        }
        return null;
    }

    public String toString() {
        if (this.retentionString_ == null && this.entries_.size() > 0) {
            StringBuffer value = new StringBuffer(this.entries_.size() * 128);
            for (int i = 0; i < this.entries_.size(); ++i) {
                value.append(this.entries_.get(i).toString());
            }
            this.retentionString_ = value.toString();
        }
        return this.retentionString_;
    }

    private void parseString() throws CMException {
        String docStr = "<a>" + this.retentionString_ + "</a>";
        try {
            Document doc = CMXMLUtils.parse(new InputSource(new StringReader(docStr)));
            Element rootEl = doc.getDocumentElement();
            NodeList retentionNodes = rootEl.getChildNodes();
            for (int i = 0; i < retentionNodes.getLength(); ++i) {
                Node node = retentionNodes.item(i);
                if (node.getNodeType() != 1) continue;
                if (this.entries_ == null) {
                    this.entries_ = new ArrayList();
                }
                this.entries_.add(Policy.parseDOMElement((Element)node));
            }
        }
        catch (SAXException ex) {
            throw new CMException(ex, "cmUnexpectedError");
        }
        catch (IOException ex) {
            throw new CMException(ex, "cmUnexpectedError");
        }
    }

    public static CMRetention parseDOMElement(Element retentionElem) throws CMException {
        if (retentionElem.getNamespaceURI() == null && !retentionElem.getTagName().equals("retention")) {
            throw new IllegalStateException("This method should only get called for retention properties.");
        }
        CMRetention value = null;
        NodeList children = retentionElem.getChildNodes();
        int childCount = children.getLength();
        for (int idx = 0; idx < childCount; ++idx) {
            Node child = children.item(idx);
            if (child.getNodeType() != 1) continue;
            if (value == null) {
                value = new CMRetention();
            }
            value.entries_.add(Policy.parseDOMElement((Element)child));
        }
        return value;
    }

    public static class Policy {
        private CMObjectClass selectClass_;
        private CMProperty selectProperty_;
        private int maxNumber_;
        private String maxDuration_;

        Policy(String select, String maxNumber, String maxDuration) throws CMException {
            int slashIdx = select.indexOf(47);
            if (slashIdx == -1) {
                Policy.throwBadAttrException(null, "retention", "select");
            }
            if (select.length() <= slashIdx + 2 || select.charAt(slashIdx + 1) != '@') {
                Policy.throwBadAttrException(null, "retention", "select");
            }
            String objectClass = select.substring(0, slashIdx);
            String property = select.substring(slashIdx + 2);
            CMStore store = CMExecutionContext.get().getStore();
            this.selectClass_ = store.getObjectClasses().getClassByName(objectClass);
            if (this.selectClass_ == null) {
                Policy.throwBadAttrException(new CMException("cmBadClass", new CMException.Parm("Class", objectClass)), "retention", "select");
            }
            this.selectProperty_ = store.getPropertySets().getPropertySetAt(0).getProperty(property, this.selectClass_);
            if (this.selectProperty_ == null) {
                Policy.throwBadAttrException(new CMException("cmBadProp", new CMException.Parm("Value", property)), "retention", "select");
            }
            if (maxNumber != null && maxNumber.length() > 0) {
                try {
                    this.maxNumber_ = Integer.parseInt(maxNumber);
                }
                catch (NumberFormatException ex) {
                    Policy.throwBadAttrException(null, "retention", "maxNumber");
                }
            }
        }

        public static Policy parseDOMElement(Element el) throws CMException {
            if (el.getNamespaceURI() == null && !el.getTagName().equals("retentionPolicy") || el.getNamespaceURI() != null && (!el.getNamespaceURI().equals("http://developer.cognos.com/schemas/bibus/3/") || !el.getLocalName().equals("retentionPolicy"))) {
                throw new CMException("cmPropInvalidContent", new CMException.Parm("Property", "retention"));
            }
            if (el.hasChildNodes()) {
                throw new CMException("cmPropInvalidContent", new CMException.Parm("Property", "retention"));
            }
            NamedNodeMap attrs = el.getAttributes();
            String select = null;
            String maxNumber = null;
            String maxDuration = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr item = (Attr)attrs.item(i);
                if (item.getName().equals("select")) {
                    select = item.getValue();
                    continue;
                }
                if (item.getName().equals("maxDuration")) {
                    maxDuration = item.getValue();
                    continue;
                }
                if (item.getName().equals("maxNumber")) {
                    maxNumber = item.getValue();
                    continue;
                }
                throw new CMException("cmPropAttrUnknown", new CMException.Parm("Property", "retention"), new CMException.Parm("Attribute", item.getName()));
            }
            if (select == null) {
                throw new CMException("cmPropMissingAttr", new CMException.Parm("Property", "retention"), new CMException.Parm("Attribute", "select"));
            }
            return new Policy(select, maxNumber, maxDuration);
        }

        public int getMaxNumber() {
            return this.maxNumber_;
        }

        public CMProperty getDateTimeProperty() {
            return this.selectProperty_;
        }

        public CMObjectClass getObjectClass() {
            return this.selectClass_;
        }

        public String toString() {
            StringBuffer value = new StringBuffer(128);
            value.append("<retentionPolicy select=\"");
            value.append(this.selectClass_.getName());
            value.append("/@");
            value.append(this.selectProperty_.getName());
            value.append("\" maxNumber=\"");
            value.append(this.maxNumber_);
            value.append("\"");
            if (this.maxDuration_ != null) {
                value.append(" maxDuration=\"");
                value.append(this.maxDuration_);
                value.append("\"");
            }
            value.append("/>");
            return value.toString();
        }

        private static void throwBadAttrException(CMException ex, String property, String attribute) throws CMException {
            throw new CMException((Exception)ex, "cmPropBadAttr", new CMException.Parm("Property", property), new CMException.Parm("Attribute", attribute));
        }
    }
}

