/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.properties;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.util.CMTempFileCache;
import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.cmutils.tempcache.CMTempFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class DataPropertyHelper {
    private CMTempFileCache tempFileCache;
    private CMStoreQueryResults queryResults;
    private CMProperty prop;
    private Object propValueObject;
    private CMTempFile tempfile;
    private Object key;
    private String contentType;
    private boolean internalDataCompressed;
    private long uncompressedDataSize;

    public DataPropertyHelper(CMTempFileCache tempfileCache, CMStoreQueryResults iter, CMProperty prop, Object propValueObject, String contentType, boolean internalDataCompressed) throws CMException {
        this.tempFileCache = tempfileCache;
        this.queryResults = iter;
        this.prop = prop;
        this.propValueObject = propValueObject;
        this.contentType = contentType;
        this.internalDataCompressed = internalDataCompressed;
        this.uncompressedDataSize = -1L;
        this.fetchTempFile();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getInlineData(int nmaxDataBytes, long nfirstDataByte) throws CMException {
        InputStream is = null;
        byte[] inputData = null;
        try {
            inputData = new byte[nmaxDataBytes];
            is = this.getInputStream(true);
            is = new BufferedInputStream(is);
            this.skipBytes(nfirstDataByte, is);
            int nRead = 0;
            int nReturned = 0;
            for (long maxRead = (long)nmaxDataBytes; nReturned >= 0 && maxRead > 0L; maxRead -= (long)nReturned, nRead += nReturned) {
                nReturned = is.read(inputData, nRead, (int)maxRead);
            }
            this.tempfile.release();
        }
        catch (IOException exio) {
            try {
                throw new CMException((Exception)exio, "cmPropReadFail", new CMException.Parm("Prop", this.prop.getName()));
                catch (CAMCryptoException exio2) {
                    throw new CMException((Exception)((Object)exio2), "cmPropReadFail", new CMException.Parm("Prop", this.prop.getName()));
                }
            }
            catch (Throwable throwable) {
                CMStreamUtils.quietClose(is);
                throw throwable;
            }
        }
        CMStreamUtils.quietClose((InputStream)is);
        return Base64.encode(inputData, 0, nmaxDataBytes);
    }

    private void skipBytes(long nfirstDataByte, InputStream is) throws IOException {
        if (nfirstDataByte > 0L) {
            int c = 0;
            for (long skipped = is.skip(nfirstDataByte); c >= 0 && skipped < nfirstDataByte; ++skipped) {
                c = is.read();
            }
        }
    }

    private void fetchTempFile() throws CMException {
        this.key = this.tempFileCache.getNewTempFileCacheKey(this.queryResults.getObjectID(), this.prop);
        this.tempfile = this.tempFileCache.get(this.key);
        if (this.tempfile == null && this.propValueObject != null) {
            InputStream propData = null;
            if (this.propValueObject instanceof InputStream) {
                propData = (InputStream)this.propValueObject;
            } else if (this.propValueObject instanceof byte[]) {
                propData = new ByteArrayInputStream((byte[])this.propValueObject);
            }
            if (propData != null) {
                this.tempfile = this.createTempFile(this.prop, this.key, propData);
            }
        }
    }

    private CMTempFile createTempFile(CMProperty prop, Object key, InputStream propData) throws CMException {
        String contentType = this.getContentType();
        CMTempFile tempfile = this.tempFileCache.add(key, propData, prop, contentType, true);
        CMStreamUtils.quietClose((InputStream)propData);
        return tempfile;
    }

    public CMTempFile getTempFile() {
        return this.tempfile;
    }

    public Object getTempFileKey() {
        return this.key;
    }

    public int getObjectID() {
        return this.queryResults.getObjectID();
    }

    public CMStoreQueryResults getResultSet() {
        return this.queryResults;
    }

    public String getContentType() {
        return this.contentType == null ? this.getDefaultContentType() : this.contentType;
    }

    private String getDefaultContentType() {
        return "application/octet-string";
    }

    public int getFileHashCode() {
        return this.tempfile != null ? this.tempfile.hashCode() : 0;
    }

    public InputStream getInputStream(boolean decompress) throws CAMCryptoException, IOException {
        InputStream is;
        InputStream inputStream = is = this.tempfile != null ? this.tempfile.getInputStream() : new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        };
        if (decompress && this.internalDataCompressed) {
            is = new GZIPInputStream(is, 32768);
        }
        return is;
    }

    public boolean internalDataIsCompressed() {
        return this.internalDataCompressed;
    }

    public void release() {
        if (this.tempfile != null) {
            this.tempfile.release();
        }
    }

    public void remove() {
        if (this.key != null) {
            this.tempFileCache.remove(this.key);
        }
    }

    public boolean dataIsPresent() {
        return this.tempfile != null;
    }

    public long getUncompressedDataSize() {
        return this.uncompressedDataSize;
    }

    public void setUncompressedDataSize(long dataSize) {
        this.uncompressedDataSize = dataSize;
    }

    public long getDataSize() {
        Object dataObj = this.tempfile != null ? this.tempfile.getMetadata("tempFileDataSize") : null;
        return dataObj != null && dataObj instanceof Long ? (Long)dataObj : -1L;
    }
}

