/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.properties;

import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.properties.CMLocalizedString;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMStringUtils;
import java.util.HashMap;
import java.util.Map;

public class MultilingualProperty {
    private static final String ELEM_LOCALE = "locale";
    private static final String ELEM_VALUE = "value";

    public static CMDbStoreLocalizedStringArray readToken(XMLElement xmlElValue, boolean mapLocale) throws CMException {
        return MultilingualProperty.read(xmlElValue, true, mapLocale);
    }

    public static CMDbStoreLocalizedStringArray readTokenWithLocaleMapping(XMLElement xmlElValue) throws CMException {
        return MultilingualProperty.read(xmlElValue, true, true);
    }

    public static CMDbStoreLocalizedStringArray readString(XMLElement xmlElValue, boolean mapLocale) throws CMException {
        return MultilingualProperty.read(xmlElValue, false, mapLocale);
    }

    public static CMDbStoreLocalizedStringArray readStringWithLocaleMapping(XMLElement xmlElValue) throws CMException {
        return MultilingualProperty.read(xmlElValue, false, true);
    }

    public static CMDbStoreLocalizedStringArray read(XMLElement xmlElValue, boolean token, boolean mapLocale) throws CMException {
        if (!MultilingualProperty.hasItems(xmlElValue)) {
            return null;
        }
        CMDbStoreLocalizedStringArray localizedStrings = new CMDbStoreLocalizedStringArray();
        HashMap<String, String> localesToMap = new HashMap<String, String>();
        for (XMLElement item : xmlElValue.getChildren()) {
            String localeID = item.getChildNonNullValueWithName(ELEM_LOCALE);
            String value = MultilingualProperty.getValue(item, token);
            CMStringLocale locale = MultilingualProperty.getLocale(localeID);
            if (locale == null) {
                if (!mapLocale) {
                    throw MultilingualProperty.badLocaleException(localeID);
                }
                localesToMap.put(localeID, value);
                continue;
            }
            CMDbStoreLocalizedString locString = new CMDbStoreLocalizedString(locale, value);
            CMLocalizedString existingString = localizedStrings.get(locString.getLocale());
            if (existingString != null) {
                throw MultilingualProperty.duplicateLocaleException(existingString, locString);
            }
            localizedStrings.add(locString);
        }
        MultilingualProperty.addMappedLocalizedStrings(localizedStrings, localesToMap, mapLocale);
        return localizedStrings;
    }

    private static void addMappedLocalizedStrings(CMDbStoreLocalizedStringArray localizedStrings, HashMap<String, String> localesToMap, boolean fullLocaleMapping) throws CMException {
        for (Map.Entry<String, String> entry : localesToMap.entrySet()) {
            String localeID = entry.getKey();
            String value = entry.getValue();
            String mappedLocaleID = MultilingualProperty.mapContentLocale(localeID, fullLocaleMapping);
            if (mappedLocaleID == null) {
                throw new CMException((Exception)MultilingualProperty.badLocaleException(localeID), "cmFailedLocaleMapping", new CMException.Parm("Locale", localeID));
            }
            CMStringLocale locale = CMDbStoreStringLocales.findLocale(mappedLocaleID);
            if (locale == null) {
                throw new CMException("cmFailedToLoadLocaleInfo");
            }
            CMDbStoreLocalizedString locString = new CMDbStoreLocalizedString(locale, value);
            CMLocalizedString existing = localizedStrings.get(locString.getLocale());
            if (existing != null) continue;
            localizedStrings.add(locString);
        }
    }

    private static final boolean hasItems(XMLElement element) {
        return element != null && element.getChildren() != null && element.getChildren().size() > 0;
    }

    private static String getValue(XMLElement item, boolean token) throws CMException {
        String value = item.getChildValueWithName(ELEM_VALUE);
        if (token) {
            if (value == null) {
                throw new CMException("cmExpectedElementEmpty", new CMException.Parm("Name", ELEM_VALUE));
            }
            value = CMStringUtils.collapseWhitespace(value);
        } else if (value == null) {
            value = "";
        }
        return value;
    }

    private static CMStringLocale getLocale(String localeID) throws CMException {
        IConfiguration config = ConfigurationFactory.getConfig();
        try {
            localeID = config.normalizeLocale(localeID);
            if (!config.validateContentLocaleStrict(localeID)) {
                return null;
            }
        }
        catch (CMConfigurationException ex) {
            throw new CMException(ex, "cmFailedToParseLocaleInfo");
        }
        return CMDbStoreStringLocales.findLocale(localeID);
    }

    private static String mapContentLocale(String localeID, boolean fullLocaleMapping) throws CMException {
        IConfiguration config = ConfigurationFactory.getConfig();
        if (fullLocaleMapping) {
            return config.mapContentLocale(localeID, false);
        }
        return config.mapContentLocaleStrict(localeID, false);
    }

    private static CMException badLocaleException(String localeID) {
        return new CMException("cmBadContentLocale", new CMException.Parm("Locale", localeID));
    }

    private static CMException duplicateLocaleException(CMLocalizedString existingStr, CMLocalizedString locString) {
        return new CMException("cmDuplicateLocale", new CMException.Parm("Value1", existingStr.getValue()), new CMException.Parm("Value2", locString.getValue()), new CMException.Parm("Locale", existingStr.getLocale().getLocaleID()));
    }
}

