/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.properties;

import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMRepositoryRule;
import com.cognos.cm.properties.CMRepositoryRuleArray;
import com.cognos.cm.properties.IRepositoryRules;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RepositoryRules
implements IRepositoryRules {
    public static final String EMPTY_DATASOURCE_NAME = "";

    @Override
    public boolean hasRepositoryRuleForClass(ICMStorePath searchStorePath, CMObjectClass repositoryRuleObjectClass) throws CMException {
        return this.hasRepositoryRule(this.getRepositoryDataSourceName(searchStorePath, repositoryRuleObjectClass));
    }

    @Override
    public boolean hasRepositoryRule(ICMStorePath searchStorePath) throws CMException {
        return this.hasRepositoryRule(this.getRepositoryDataSourceName(searchStorePath));
    }

    public boolean hasRepositoryRule(String dataSourceName) {
        return dataSourceName != null && !dataSourceName.equals(EMPTY_DATASOURCE_NAME);
    }

    @Override
    public String getRepositoryDataSourceName(ICMStorePath searchStorePath, CMObjectClass repositoryRuleObjectClass) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        CMAncestors ancestors = this.queryAncestors(searchStorePath, store);
        return this.getRepositoryDataSourceName(repositoryRuleObjectClass, store, ancestors);
    }

    @Override
    public String getRepositoryDataSourceName(ICMStorePath searchStorePath) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        CMAncestors ancestors = this.queryAncestors(searchStorePath, store);
        CMObjectClass repositoryRuleObjectClass = this.getRepositoryRuleObjectClass(ancestors, store);
        return this.getRepositoryDataSourceName(repositoryRuleObjectClass, store, ancestors);
    }

    public CMObjectClass getRepositoryRuleObjectClass(ICMStorePath searchStorePath) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        CMAncestors ancestors = this.queryAncestors(searchStorePath, store);
        return this.getRepositoryRuleObjectClass(ancestors, store);
    }

    private CMObjectClass getRepositoryRuleObjectClass(CMAncestors ancestors, CMStore store) {
        for (int i = 0; i < ancestors.getSize(); ++i) {
            String objectClassName = ancestors.getObjectClass(i);
            CMObjectClass objectClass = store.getObjectClasses().getClassByName(objectClassName);
            if (!this.isRepositoryRuleClass(objectClass)) continue;
            return objectClass;
        }
        return null;
    }

    private boolean isRepositoryRuleClass(CMObjectClass objectClass) {
        return objectClass.isArchivableVersion();
    }

    private String getRepositoryDataSourceName(CMObjectClass repositoryRuleObjectClass, CMStore store, CMAncestors ancestors) throws CMException {
        String dataSourceName = null;
        if (repositoryRuleObjectClass == null) {
            return null;
        }
        Map<ICMStorePath, CMObjectClass> parentInfo = this.getNearestParentFolderOrPackageInformation(ancestors, store);
        Iterator<Map.Entry<ICMStorePath, CMObjectClass>> parentInfoIterator = parentInfo.entrySet().iterator();
        if (parentInfoIterator.hasNext()) {
            Map.Entry<ICMStorePath, CMObjectClass> parentInfoEntry = parentInfoIterator.next();
            dataSourceName = this.getRepositoryRulesDataSourceNamePropertyValue(parentInfoEntry.getKey(), parentInfoEntry.getValue(), 0, null, store, repositoryRuleObjectClass);
        }
        return dataSourceName;
    }

    protected ICMStorePath createStorePath(String searchPath) throws CMStoreParseException {
        return new CMStoreXPath(searchPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMAncestors queryAncestors(ICMStorePath objectSearchPath, CMStore store) throws CMException {
        CMAncestors ancestors = null;
        CMStoreQueryResults ancestorsResults = null;
        try {
            ancestorsResults = store.executeQuery(objectSearchPath, new CMProperty[]{CMProperty.ANCESTORS}, null, 0, 512, null);
            if (ancestorsResults.next()) {
                ancestors = (CMAncestors)ancestorsResults.getValue(0);
            }
        }
        finally {
            if (ancestorsResults != null) {
                ancestorsResults.release();
            }
        }
        return ancestors;
    }

    private Map<ICMStorePath, CMObjectClass> getNearestParentFolderOrPackageInformation(CMAncestors ancestors, CMStore store) throws CMException {
        HashMap<ICMStorePath, CMObjectClass> parentInfo = new HashMap<ICMStorePath, CMObjectClass>(1);
        if (ancestors != null) {
            for (int i = ancestors.getSize() - 1; i >= 0; --i) {
                String objectClassName = ancestors.getObjectClass(i);
                if (!this.isRepositoryRulesClass(objectClassName)) continue;
                parentInfo.put(this.createStorePath(ancestors.getSearchPath(i)), store.getObjectClasses().getClassByName(objectClassName));
                break;
            }
        }
        return parentInfo;
    }

    public String getSearchPathOfObjectWithRepositoryRule(ICMStorePath searchStorePath, CMStore store) throws CMException {
        CMAncestors ancestors = this.queryAncestors(searchStorePath, store);
        Map<ICMStorePath, CMObjectClass> parentInfo = this.getNearestParentFolderOrPackageInformation(ancestors, store);
        Iterator<Map.Entry<ICMStorePath, CMObjectClass>> parentInfoIterator = parentInfo.entrySet().iterator();
        if (parentInfoIterator.hasNext()) {
            Map.Entry<ICMStorePath, CMObjectClass> parentInfoEntry = parentInfoIterator.next();
            return parentInfoEntry.getKey().getOriginalPath();
        }
        return null;
    }

    private boolean isRepositoryRulesClass(String objectClassName) {
        return objectClassName.equals(this.getFolderClassName()) || objectClassName.equals(this.getPackageClassName()) || objectClassName.equals(this.getContentClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRepositoryRulesDataSourceNamePropertyValue(ICMStorePath searchPath, CMObjectClass objectClass, int permissions, ArrayList<String> extraPermission, CMStore store, CMObjectClass repositoryRuleObjectClass) throws CMException {
        String datasourceName = null;
        CMStoreQueryResults queryPropertyResults = null;
        try {
            CMRepositoryRule repositoryRule;
            CMRepositoryRuleArray repositoryRuleArray;
            CMProperty[] namedProperties = new CMProperty[]{store.getProperty(this.getRepositoryRulesPropertyName(), objectClass)};
            queryPropertyResults = store.executeQuery(searchPath, namedProperties, null, 0, permissions, extraPermission);
            if (queryPropertyResults.next() && (repositoryRuleArray = (CMRepositoryRuleArray)queryPropertyResults.getValue(0)) != null && (repositoryRule = repositoryRuleArray.getRule(repositoryRuleObjectClass)) != null) {
                datasourceName = repositoryRule.getDataSourceName();
            }
        }
        finally {
            if (queryPropertyResults != null) {
                queryPropertyResults.release();
            }
        }
        return datasourceName;
    }

    protected String getContentClassName() {
        return CMObjectClass.CONTENT.getName();
    }

    protected String getPackageClassName() {
        return CMObjectClass.PACKAGE.getName();
    }

    protected String getFolderClassName() {
        return CMObjectClass.FOLDER.getName();
    }

    protected String getRepositoryRulesPropertyName() {
        return CMProperty.REPOSITORYRULES.getName();
    }
}

