/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.queues;

import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueue;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import java.util.List;
import org.dom4j.Element;

public class CMBlockingQueue
implements ICMQueue {
    private int pollStorageTimeout;
    private ICMQueue queue;
    private boolean shouldNotBlock;
    protected Long failedItemReconciliationExpirationTime;
    private Object failedItemReconciliationSynchObject;

    public CMBlockingQueue(ICMQueue queue, int pollStorageTimeout) {
        this.queue = queue;
        this.pollStorageTimeout = pollStorageTimeout;
        this.failedItemReconciliationSynchObject = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICMQueueItem get(CMStore store, String consumerId) throws CMException {
        ICMQueueItem item;
        while ((item = this.queue.get(store, consumerId)) == null) {
            if (this.shouldNotBlock) {
                this.shouldNotBlock = false;
                return null;
            }
            if (this.reconcileFailedItemsInQueue(store)) continue;
            CMBlockingQueue cMBlockingQueue = this;
            synchronized (cMBlockingQueue) {
                try {
                    this.doWait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
        }
        return item;
    }

    protected void doWait() throws InterruptedException {
        this.wait(this.pollStorageTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICMQueueItem> get(CMStore store, String consumerId, int maxItems) throws CMException {
        List<ICMQueueItem> items = this.queue.get(store, consumerId, maxItems);
        while (items.isEmpty()) {
            if (this.shouldNotBlock) {
                this.shouldNotBlock = false;
                return items;
            }
            if (!this.reconcileFailedItemsInQueue(store)) {
                CMBlockingQueue cMBlockingQueue = this;
                synchronized (cMBlockingQueue) {
                    try {
                        this.doWait();
                    }
                    catch (InterruptedException e) {
                        return items;
                    }
                }
            }
            items = this.queue.get(store, consumerId, maxItems);
        }
        return items;
    }

    @Override
    public void init(String queueName, Element definitionParameters) throws CMException {
        this.queue.init(queueName, definitionParameters);
    }

    @Override
    public boolean put(CMStore store, ICMQueueItem item) throws CMException {
        if (this.queue.put(store, item)) {
            this.notifyAWaitingWorker();
            return true;
        }
        return false;
    }

    @Override
    public boolean put(CMStore store, List<ICMQueueItem> items) throws CMException {
        if (this.queue.put(store, items)) {
            this.notifyAWaitingWorker();
            return true;
        }
        return false;
    }

    @Override
    public void remove(CMStore store, ICMQueueItem item) throws CMException {
        this.queue.remove(store, item);
    }

    @Override
    public void remove(CMStore store, List<ICMQueueItem> items) throws CMException {
        this.queue.remove(store, items);
    }

    @Override
    public int size(CMStore store, CMQueueItemState state) throws CMException {
        return this.queue.size(store, state);
    }

    @Override
    public int reconcileAllItemsForConsumer(CMStore store, String consumerId) throws CMException {
        return this.queue.reconcileAllItemsForConsumer(store, consumerId);
    }

    @Override
    public boolean updateState(CMStore store, CMQueueItemState state, ICMQueueItem item) throws CMException {
        if (this.queue.updateState(store, state, item)) {
            this.itemStateUpdated(state);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateState(CMStore store, CMQueueItemState state, List<ICMQueueItem> items) throws CMException {
        if (this.queue.updateState(store, state, items)) {
            this.itemStateUpdated(state);
            return true;
        }
        return false;
    }

    @Override
    public void clean(CMStore store) throws CMException {
        this.queue.clean(store);
    }

    protected void itemStateUpdated(CMQueueItemState state) {
        if (state.equals((Object)CMQueueItemState.AVAILABLE)) {
            this.notifyAWaitingWorker();
        } else if (state.equals((Object)CMQueueItemState.FAILED)) {
            this.registerFailedItem();
        }
    }

    public void stopBlocking() {
        this.shouldNotBlock = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerFailedItem() {
        Object object = this.failedItemReconciliationSynchObject;
        synchronized (object) {
            if (this.failedItemReconciliationExpirationTime == null) {
                this.failedItemReconciliationExpirationTime = new Long(this.calculateFailedItemReconciliationTime());
            }
        }
    }

    @Override
    public int reconcileFailedItems(CMStore store) throws CMException {
        return this.queue.reconcileFailedItems(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reconcileFailedItemsInQueue(CMStore store) throws CMException {
        boolean failedItemsNeedToBeReconciled = false;
        int numberOfReconciledItems = 0;
        boolean failedItemsHaveBeenReconciled = false;
        Object object = this.failedItemReconciliationSynchObject;
        synchronized (object) {
            if (this.failedItemReconciliationExpirationTime != null && this.getCurrentTimeMillis() > this.failedItemReconciliationExpirationTime) {
                this.failedItemReconciliationExpirationTime = null;
                failedItemsNeedToBeReconciled = true;
            }
        }
        if (failedItemsNeedToBeReconciled && (numberOfReconciledItems = this.reconcileFailedItems(store)) > 0) {
            failedItemsHaveBeenReconciled = true;
            if (numberOfReconciledItems > 1) {
                this.notifyWaitingWorkers();
            }
        }
        return failedItemsHaveBeenReconciled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAWaitingWorker() {
        CMBlockingQueue cMBlockingQueue = this;
        synchronized (cMBlockingQueue) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaitingWorkers() {
        CMBlockingQueue cMBlockingQueue = this;
        synchronized (cMBlockingQueue) {
            this.notifyAll();
        }
    }

    private long calculateFailedItemReconciliationTime() {
        return this.getCurrentTimeMillis() + (long)this.pollStorageTimeout;
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

