/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.queues;

import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbStore;
import com.cognos.cm.dbstore.binders.CMDbStoreIntBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreStringBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreTimestampBinder;
import com.cognos.cm.queues.CMInMemoryQueueItem;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMUUID;
import com.cognos.cm.util.IPluginLoader;
import com.cognos.cm.util.PluginLoader;
import io.prometheus.client.Gauge;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class CMInDBQueue {
    protected static final int CMQUEUE_OBJID_COLUMNINDEX = 1;
    protected static final int CMQUEUE_ITEMID_COLUMNINDEX = 2;
    protected static final int CMQUEUE_WORKFLOW_COLUMNINDEX = 3;
    protected static final int CMQUEUE_COUNT_COLUMNINDEX = 1;
    protected String queueName = null;
    protected String queueTable = null;
    protected CMQUEUEUTIL utils;
    protected CMDbStoreStringBinder stringBinder;
    protected CMDbStoreIntBinder intBinder;
    protected CMDbStoreTimestampBinder timestampBinder;
    protected Gauge depthGauge;
    private TraceLogger logger;

    public CMInDBQueue() {
        this(new TraceLogger());
    }

    protected CMInDBQueue(TraceLogger logger) {
        this.logger = logger;
    }

    public void init(String queueName, Element definitionParameters) throws CMException {
        IPluginLoader loader = PluginLoader.get();
        this.queueName = queueName;
        this.queueTable = loader.getOptionalAttribute(definitionParameters, "table", "/WEB-INF/cm/queues/config/queueManager.xml");
        if (this.queueTable == null) {
            throw new CMException("cmErrorQueueTableIsNotConfigured", new CMException.Parm("Name", queueName));
        }
        this.utils = new CMQUEUEUTIL();
        this.stringBinder = new CMDbStoreStringBinder();
        this.intBinder = new CMDbStoreIntBinder();
        this.timestampBinder = new CMDbStoreTimestampBinder();
        this.depthGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("p2pd_cm_indbqueue_" + queueName + "_depth")).help("depth of cm in-DB queue named " + queueName)).register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICMQueueItem get(CMStore store, String consumerId) throws Exception {
        CMInMemoryQueueItem cMInMemoryQueueItem;
        ICMDbConnection connection = this.getConnection(store);
        PreparedStatement stmt = null;
        try {
            store.beginTransaction();
            stmt = this.prepareGetItemStatement(connection);
            ResultSet rs = stmt.executeQuery();
            CMInMemoryQueueItem item = null;
            if (rs.next()) {
                item = this.buildItemFromDBRecord(consumerId, rs);
                rs.close();
                this.updateToHoldState(item, consumerId, connection);
            }
            store.commitTransaction();
            cMInMemoryQueueItem = item;
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            this.safeRelease(store);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        this.safeRelease(store);
        return cMInMemoryQueueItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToHoldState(CMInMemoryQueueItem item, String taskName, ICMDbConnection connection) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String itemID = item.getQItemID();
            stmt = this.prepareUpdateToHoldStateStatement(taskName, connection, itemID);
            stmt.execute();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
    }

    protected void safeRelease(CMStore store) throws CMException {
        if (store.inTransaction()) {
            store.rollbackTransaction();
        }
        this.releaseConnection(store);
    }

    public List<ICMQueueItem> get(CMStore store, String consumerId, int maxItems) throws Exception {
        ICMQueueItem item;
        ArrayList<ICMQueueItem> items = new ArrayList<ICMQueueItem>(maxItems);
        for (int i = 0; i < maxItems && (item = this.get(store, consumerId)) != null; ++i) {
            items.add(item);
        }
        return items;
    }

    public boolean put(CMStore store, ICMQueueItem item) throws Exception {
        return this.put(store, Collections.singletonList(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(CMStore store, List<ICMQueueItem> items) throws Exception {
        ICMDbConnection connection = this.getConnection(store);
        try {
            store.beginTransaction();
            for (ICMQueueItem item : items) {
                this.putItem(item, connection);
            }
            store.commitTransaction();
            boolean bl = true;
            return bl;
        }
        finally {
            this.safeRelease(store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putItem(ICMQueueItem item, ICMDbConnection connection) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String itemID = new CMUUID().toStoreID();
            stmt = this.prepareInsertStatement(item, itemID, connection);
            stmt.execute();
            this.depthGauge.inc();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
    }

    public void remove(CMStore store, ICMQueueItem item) throws Exception {
        this.remove(store, Collections.singletonList(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CMStore store, List<ICMQueueItem> items) throws Exception {
        ICMDbConnection connection = this.getConnection(store);
        try {
            store.beginTransaction();
            for (ICMQueueItem item : items) {
                this.removeItem(item, connection);
            }
            store.commitTransaction();
        }
        finally {
            this.safeRelease(store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItem(ICMQueueItem item, ICMDbConnection connection) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareRemoveStatement(item, connection);
            stmt.execute();
            this.depthGauge.dec();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(CMStore store, CMQueueItemState state) throws Exception {
        int n;
        ICMDbConnection connection = this.getConnection(store);
        PreparedStatement stmt = null;
        try {
            int result = 0;
            stmt = this.prepareCountWithStateStatement(state, connection);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            if (state == CMQueueItemState.AVAILABLE) {
                this.depthGauge.set((double)result);
            }
            n = result;
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            this.releaseConnection(store);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        this.releaseConnection(store);
        return n;
    }

    public int reconcileAllItemsForConsumer(CMStore store, String consumerId) throws Exception {
        return this.updateStateOfAllConsumerItems(store, CMQueueItemState.AVAILABLE, consumerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateStateOfAllConsumerItems(CMStore store, CMQueueItemState state, String consumerId) throws Exception {
        int n;
        ICMDbConnection connection = this.getConnection(store);
        PreparedStatement stmt = null;
        try {
            store.beginTransaction();
            stmt = this.prepareAllTaskItemsStateUpdateStatement(state, connection, consumerId);
            int updated = stmt.executeUpdate();
            store.commitTransaction();
            n = updated;
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            this.safeRelease(store);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        this.safeRelease(store);
        return n;
    }

    public boolean updateState(CMStore store, CMQueueItemState state, ICMQueueItem item) throws Exception {
        return this.updateState(store, state, Collections.singletonList(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateState(CMStore store, CMQueueItemState state, List<ICMQueueItem> items) throws Exception {
        ICMDbConnection connection = this.getConnection(store);
        PreparedStatement stmt = null;
        try {
            store.beginTransaction();
            int updateCount = 0;
            for (ICMQueueItem item : items) {
                stmt = this.prepareItemStateUpdateStatement(state, connection, item.getQItemID());
                if (stmt.executeUpdate() <= 0) continue;
                ++updateCount;
            }
            store.commitTransaction();
            boolean bl = updateCount == items.size();
            return bl;
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            this.safeRelease(store);
        }
    }

    private PreparedStatement prepareUpdateToHoldStateStatement(String taskName, ICMDbConnection connection, String itemID) throws SQLException {
        String updateStateSql = "UPDATE " + this.queueTable + " SET CONSUMERNAME = ?, STATE = ? WHERE ITEMID = ?";
        PreparedStatement stmt = connection.prepareStatement(updateStateSql);
        this.stringBinder.bindData(stmt, 1, taskName);
        this.intBinder.bindData(stmt, 2, CMQueueItemState.HOLD.ordinal());
        this.stringBinder.bindData(stmt, 3, itemID);
        return stmt;
    }

    protected CMInMemoryQueueItem buildItemFromDBRecord(String taskName, ResultSet rs) throws SQLException {
        CMInMemoryQueueItem item = new CMInMemoryQueueItem();
        item.setObjectID(rs.getString(1));
        item.setQItemID(rs.getString(2));
        item.setQName(this.queueName);
        item.setWorkFlow(rs.getString(3));
        item.setconsumerName(taskName);
        return item;
    }

    private PreparedStatement prepareGetItemStatement(ICMDbConnection connection) throws SQLException {
        String getSelectTopSql = this.utils.getSelectTopSql(connection.getDbms());
        PreparedStatement stmt = connection.prepareStatement(getSelectTopSql);
        this.intBinder.bindData(stmt, 1, CMQueueItemState.AVAILABLE.ordinal());
        this.stringBinder.bindData(stmt, 2, this.queueName);
        return stmt;
    }

    protected PreparedStatement prepareInsertStatement(ICMQueueItem item, String itemID, ICMDbConnection connection) throws SQLException {
        String insertSql = "INSERT INTO " + this.queueTable + " (OBJID, ITEMID, QUEUEID, WORKFLOW, CONSUMERNAME," + " STATE, INSERTIONTIME) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(insertSql);
        this.stringBinder.bindData(stmt, 1, item.getObjectID());
        this.stringBinder.bindData(stmt, 2, itemID);
        this.stringBinder.bindData(stmt, 3, this.queueName);
        this.stringBinder.bindData(stmt, 4, item.getWorkFlow());
        this.stringBinder.bindData(stmt, 5, "");
        this.intBinder.bindData(stmt, 6, CMQueueItemState.AVAILABLE.ordinal());
        boolean isDerby = CMDbConnection.dbms_ == 5;
        this.timestampBinder.bindData(stmt, 7, CMDateUtils.getTimestamp(isDerby));
        return stmt;
    }

    private PreparedStatement prepareRemoveStatement(ICMQueueItem item, ICMDbConnection connection) throws SQLException {
        String removeitemSql = "DELETE FROM " + this.queueTable + " WHERE ITEMID = ? AND QUEUEID = ?";
        PreparedStatement stmt = connection.prepareStatement(removeitemSql);
        this.stringBinder.bindData(stmt, 1, item.getQItemID());
        this.stringBinder.bindData(stmt, 2, this.queueName);
        return stmt;
    }

    private PreparedStatement prepareCountWithStateStatement(CMQueueItemState state, ICMDbConnection connection) throws SQLException {
        String countStateSql = "SELECT COUNT(ITEMID) FROM " + this.queueTable + " WHERE STATE = ? AND QUEUEID = ?";
        PreparedStatement stmt = connection.prepareStatement(countStateSql);
        this.intBinder.bindData(stmt, 1, state.ordinal());
        this.stringBinder.bindData(stmt, 2, this.queueName);
        return stmt;
    }

    private PreparedStatement prepareAllTaskItemsStateUpdateStatement(CMQueueItemState state, ICMDbConnection connection, String consumerId) throws SQLException {
        String updateStateSql = "UPDATE " + this.queueTable + " SET STATE = ?  WHERE CONSUMERNAME = ?  AND QUEUEID = ?";
        PreparedStatement stmt = connection.prepareStatement(updateStateSql);
        this.intBinder.bindData(stmt, 1, state.ordinal());
        this.stringBinder.bindData(stmt, 2, consumerId);
        this.stringBinder.bindData(stmt, 3, this.queueName);
        return stmt;
    }

    private PreparedStatement prepareItemStateUpdateStatement(CMQueueItemState state, ICMDbConnection connection, String itemID) throws SQLException {
        String updateStateSql = "UPDATE " + this.queueTable + " SET STATE = ? WHERE ITEMID = ?  AND QUEUEID = ?";
        PreparedStatement stmt = connection.prepareStatement(updateStateSql);
        this.intBinder.bindData(stmt, 1, state.ordinal());
        this.stringBinder.bindData(stmt, 2, itemID);
        this.stringBinder.bindData(stmt, 3, this.queueName);
        return stmt;
    }

    protected ICMDbConnection getConnection(CMStore store) throws CMException {
        return ((ICMDbStore)store).getICMDbConnection();
    }

    protected void releaseConnection(CMStore store) throws CMException {
        ((ICMDbStore)store).releaseICMDbConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(CMStore store) throws Exception {
        ICMDbConnection connection = this.getConnection(store);
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(this.utils.getDeleteAllSql(connection.getDbms()));
            stmt.execute();
            this.depthGauge.set(0.0);
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            this.releaseConnection(store);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        this.releaseConnection(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reconcileFailedItems(CMStore store) throws Exception {
        int n;
        ICMDbConnection connection = this.getConnection(store);
        PreparedStatement stmt = null;
        try {
            store.beginTransaction();
            stmt = this.prepareReconcileFailedItemsStatement(connection);
            int updated = stmt.executeUpdate();
            store.commitTransaction();
            n = updated;
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            this.safeRelease(store);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        this.safeRelease(store);
        return n;
    }

    private PreparedStatement prepareReconcileFailedItemsStatement(ICMDbConnection connection) throws SQLException {
        String updateStateSql = "UPDATE " + this.queueTable + " SET STATE = ? WHERE STATE = ?";
        PreparedStatement stmt = connection.prepareStatement(updateStateSql);
        this.intBinder.bindData(stmt, 1, CMQueueItemState.AVAILABLE.ordinal());
        this.intBinder.bindData(stmt, 2, CMQueueItemState.FAILED.ordinal());
        return stmt;
    }

    protected class CMQUEUEUTIL {
        private static final String getSqlForSqlServerStart = "SELECT TOP 1 OBJID, ITEMID, WORKFLOW, INSERTIONTIME FROM ";
        private static final String getSqlForSqlServerEnd = " where STATE = ? and QUEUEID = ? ORDER BY INSERTIONTIME";
        private static final String getSqlForDB2Start = "SELECT OBJID, ITEMID, WORKFLOW, INSERTIONTIME FROM ";
        private static final String getSqlForDB2End = " where STATE = ? and QUEUEID = ? ORDER BY INSERTIONTIME FETCH FIRST 1 ROWS ONLY OPTIMIZE FOR 1 ROWS";
        private static final String getSqlForInformixStart = "SELECT FIRST 1 OBJID, ITEMID, WORKFLOW, INSERTIONTIME from ";
        private static final String getSqlForInformixEnd = " where STATE = ? and QUEUEID=? order by INSERTIONTIME";
        private static final String getSqlForDerbyStart = "SELECT OBJID, ITEMID, WORKFLOW, INSERTIONTIME from ";
        private static final String getSqlForDerbyEnd = " where STATE = ? and QUEUEID=?";
        private static final String getSqlForOracleStart = "select * from (select OBJID, ITEMID, WORKFLOW, INSERTIONTIME from ";
        private static final String getSqlForOracleEnd = " where STATE = ? and QUEUEID = ? order by INSERTIONTIME) where rownum <=1";
        protected Map<Integer, String> CMQUEUEGetSQLMap;
        private static final String DeleteAllSqlForSqlServerDB2DerbyOracleSybaseStart = "delete from  ";
        private static final String DeleteAllSqlForInformixStart = "truncate table ";
        protected Map<Integer, String> CMQUEUEDeleteAllSQLMap;

        public CMQUEUEUTIL() {
            this.cmQUEUEGetSQLMapInit();
            this.cmQUEUEDeleteAllSQLMapInit();
        }

        protected void cmQUEUEGetSQLMapInit() {
            this.CMQUEUEGetSQLMap = new HashMap<Integer, String>();
            this.CMQUEUEGetSQLMap.put(1, new String(getSqlForSqlServerStart + CMInDBQueue.this.queueTable + getSqlForSqlServerEnd));
            this.CMQUEUEGetSQLMap.put(3, new String(getSqlForDB2Start + CMInDBQueue.this.queueTable + getSqlForDB2End));
            this.CMQUEUEGetSQLMap.put(8, new String(getSqlForInformixStart + CMInDBQueue.this.queueTable + getSqlForInformixEnd));
            this.CMQUEUEGetSQLMap.put(4, new String(getSqlForSqlServerStart + CMInDBQueue.this.queueTable + getSqlForSqlServerEnd));
            this.CMQUEUEGetSQLMap.put(5, new String(getSqlForDerbyStart + CMInDBQueue.this.queueTable + getSqlForDerbyEnd));
            this.CMQUEUEGetSQLMap.put(2, new String(getSqlForOracleStart + CMInDBQueue.this.queueTable + getSqlForOracleEnd));
        }

        protected void cmQUEUEDeleteAllSQLMapInit() {
            this.CMQUEUEDeleteAllSQLMap = new HashMap<Integer, String>();
            this.CMQUEUEDeleteAllSQLMap.put(1, new String(DeleteAllSqlForSqlServerDB2DerbyOracleSybaseStart + CMInDBQueue.this.queueTable));
            this.CMQUEUEDeleteAllSQLMap.put(3, new String(DeleteAllSqlForSqlServerDB2DerbyOracleSybaseStart + CMInDBQueue.this.queueTable));
            this.CMQUEUEDeleteAllSQLMap.put(8, new String(DeleteAllSqlForInformixStart + CMInDBQueue.this.queueTable));
            this.CMQUEUEDeleteAllSQLMap.put(4, new String(DeleteAllSqlForSqlServerDB2DerbyOracleSybaseStart + CMInDBQueue.this.queueTable));
            this.CMQUEUEDeleteAllSQLMap.put(5, new String(DeleteAllSqlForSqlServerDB2DerbyOracleSybaseStart + CMInDBQueue.this.queueTable));
            this.CMQUEUEDeleteAllSQLMap.put(2, new String(DeleteAllSqlForSqlServerDB2DerbyOracleSybaseStart + CMInDBQueue.this.queueTable));
        }

        public String getSelectTopSql(int dbms) {
            return this.CMQUEUEGetSQLMap.get(dbms);
        }

        public String getDeleteAllSql(int dbms) {
            return this.CMQUEUEDeleteAllSQLMap.get(dbms);
        }
    }
}

