/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.queues;

import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueue;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.queues.CMInMemoryQueueItem;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMUUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class CMInMemoryQueue
implements ICMQueue {
    private ArrayList<CMInMemoryQueueItem> storage = new ArrayList();
    private HashMap<String, CMInMemoryQueueItem> mappedIDs = new HashMap();
    protected String queueName = null;

    @Override
    public synchronized void init(String queueName, Element definitionParameters) {
        this.queueName = queueName;
    }

    @Override
    public synchronized ICMQueueItem get(CMStore store, String consumerId) {
        Iterator<CMInMemoryQueueItem> it = this.storage.iterator();
        CMInMemoryQueueItem item = null;
        while (it.hasNext()) {
            item = it.next();
            if (item.getState() != CMQueueItemState.AVAILABLE) continue;
            item.setState(CMQueueItemState.HOLD);
            item.setconsumerName(consumerId);
            return item;
        }
        return null;
    }

    @Override
    public List<ICMQueueItem> get(CMStore store, String consumerId, int maxItems) throws CMException {
        ICMQueueItem item;
        ArrayList<ICMQueueItem> items = new ArrayList<ICMQueueItem>(maxItems);
        for (int i = 0; i < maxItems && (item = this.get(store, consumerId)) != null; ++i) {
            items.add(item);
        }
        return items;
    }

    @Override
    public synchronized boolean put(CMStore store, ICMQueueItem item) {
        ((CMInMemoryQueueItem)item).setState(CMQueueItemState.AVAILABLE);
        ((CMInMemoryQueueItem)item).setconsumerName(null);
        ((CMInMemoryQueueItem)item).setQItemID(new CMUUID().toStoreID());
        this.storage.add(this.storage.size(), (CMInMemoryQueueItem)item);
        this.mappedIDs.put(((CMInMemoryQueueItem)item).getQItemID(), (CMInMemoryQueueItem)item);
        return true;
    }

    @Override
    public boolean put(CMStore store, List<ICMQueueItem> items) throws CMException {
        for (ICMQueueItem item : items) {
            this.put(store, item);
        }
        return true;
    }

    @Override
    public synchronized void remove(CMStore store, ICMQueueItem item) {
        String key = item.getQItemID();
        CMInMemoryQueueItem mappedItem = this.mappedIDs.get(key);
        this.storage.remove(mappedItem);
        this.mappedIDs.remove(key);
    }

    @Override
    public void remove(CMStore store, List<ICMQueueItem> items) throws CMException {
        for (ICMQueueItem item : items) {
            this.remove(store, item);
        }
    }

    @Override
    public synchronized int size(CMStore store, CMQueueItemState state) {
        int sizePerState = 0;
        Iterator<CMInMemoryQueueItem> it = this.storage.iterator();
        CMInMemoryQueueItem item = null;
        while (it.hasNext()) {
            item = it.next();
            if (item.getState() != state) continue;
            ++sizePerState;
        }
        return sizePerState;
    }

    private synchronized int updateStateOfAllConsumerItems(CMStore store, CMQueueItemState state, String consumerId) {
        Iterator<CMInMemoryQueueItem> it = this.storage.iterator();
        CMInMemoryQueueItem item = null;
        int count = 0;
        while (it.hasNext()) {
            item = it.next();
            String itemConsumerName = item.getconsumerName();
            if (itemConsumerName == null || !itemConsumerName.equalsIgnoreCase(consumerId)) continue;
            item.setState(state);
            ++count;
        }
        return count;
    }

    @Override
    public synchronized boolean updateState(CMStore store, CMQueueItemState state, ICMQueueItem item) {
        String key = item.getQItemID();
        CMInMemoryQueueItem mappedItem = this.mappedIDs.get(key);
        if (mappedItem != null) {
            CMInMemoryQueueItem mItem = this.storage.get(this.storage.indexOf(mappedItem));
            mItem.setState(state);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateState(CMStore store, CMQueueItemState state, List<ICMQueueItem> items) throws CMException {
        for (ICMQueueItem item : items) {
            this.updateState(store, state, item);
        }
        return true;
    }

    @Override
    public void clean(CMStore store) throws CMException {
        this.storage.clear();
        this.mappedIDs.clear();
    }

    @Override
    public int reconcileAllItemsForConsumer(CMStore store, String consumerId) {
        return this.updateStateOfAllConsumerItems(store, CMQueueItemState.AVAILABLE, consumerId);
    }

    @Override
    public synchronized int reconcileFailedItems(CMStore store) {
        Iterator<CMInMemoryQueueItem> it = this.storage.iterator();
        int count = 0;
        while (it.hasNext()) {
            CMInMemoryQueueItem item = it.next();
            if (!CMQueueItemState.FAILED.equals((Object)item.getState())) continue;
            item.setState(CMQueueItemState.AVAILABLE);
            ++count;
        }
        return count;
    }
}

