/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.queues;

import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.queues.CMInDBQueue;
import com.cognos.cm.queues.CMInMemoryQueueItem;
import com.cognos.cm.queues.CMIndexQueueData;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMDateUtils;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class CMIndexQueue
extends CMInDBQueue {
    private static final String SELECT_CLAUSE = "SELECT OBJID, ITEMID, WORKFLOW, INSERTIONTIME, INDEXACTION, INDEXCLASS, INDEXPROPS FROM ";
    private static final String WHERE_CLAUSE = " WHERE STATE = ? ORDER BY INSERTIONTIME";
    private static final int MILLIS_PER_SEC = 1000;
    private Summary removeItemsSummary;
    private Summary getItemsSummary;
    protected Gauge msPerGet;
    protected Gauge msPerRemove;

    public CMIndexQueue() {
    }

    protected CMIndexQueue(TraceLogger logger) {
        super(logger);
    }

    @Override
    public void init(String queueName, Element definitionParameters) throws CMException {
        super.init(queueName, definitionParameters);
        this.createMetrics(queueName);
    }

    private void createMetrics(String queueName) {
        this.getItemsSummary = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name("p2pd_cm_index_queue_" + queueName + "_getItems")).help("summary of time taken getting items from the indexing notification queue")).register();
        this.msPerGet = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("p2pd_cm_index_queue_" + queueName + "_getsPerSec")).help("how many millis it takes to get each item from " + queueName)).register();
        this.removeItemsSummary = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name("p2pd_cm_index_queue_" + queueName + "_removeItems")).help("summary of time taken removing items from the indexing notification queue")).register();
        this.msPerRemove = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("p2pd_cm_index_queue_" + queueName + "_removesPerSec")).help("how many millis it takes to remove each item from " + queueName)).register();
    }

    @Override
    protected CMInMemoryQueueItem buildItemFromDBRecord(String taskName, ResultSet rs) throws SQLException {
        CMInMemoryQueueItem item = new CMInMemoryQueueItem();
        item.setObjectID(rs.getString(1));
        item.setQItemID(rs.getString(2));
        item.setQName(this.queueName);
        item.setWorkFlow(rs.getString(3));
        item.setconsumerName(taskName);
        CMIndexQueueData data = new CMIndexQueueData(rs.getString(5));
        data.setObjectClass(rs.getString(6));
        data.setProperties(rs.getString(7));
        item.setData(data);
        return item;
    }

    @Override
    protected PreparedStatement prepareInsertStatement(ICMQueueItem item, String itemID, ICMDbConnection connection) throws SQLException {
        String insertSql = "INSERT INTO " + this.queueTable + " (OBJID, ITEMID, QUEUEID, WORKFLOW, CONSUMERNAME," + " STATE, INSERTIONTIME, INDEXACTION, INDEXCLASS, INDEXPROPS) " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(insertSql);
        this.stringBinder.bindData(stmt, 1, item.getObjectID());
        this.stringBinder.bindData(stmt, 2, itemID);
        this.stringBinder.bindData(stmt, 3, this.queueName);
        this.stringBinder.bindData(stmt, 4, item.getWorkFlow());
        this.stringBinder.bindData(stmt, 5, "");
        this.intBinder.bindData(stmt, 6, CMQueueItemState.AVAILABLE.ordinal());
        boolean isDerby = CMDbConnection.dbms_ == 5;
        this.timestampBinder.bindData(stmt, 7, CMDateUtils.getTimestamp(isDerby));
        CMIndexQueueData data = (CMIndexQueueData)item.getData();
        this.stringBinder.bindData(stmt, 8, data.getOperation());
        this.stringBinder.bindData(stmt, 9, data.getObjectClass());
        this.stringBinder.bindData(stmt, 10, data.getProperties());
        return stmt;
    }

    @Override
    public ICMQueueItem get(CMStore store, String consumerId) throws Exception {
        List<ICMQueueItem> items = this.get(store, consumerId, 1);
        return items.isEmpty() ? null : items.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICMQueueItem> get(CMStore store, String consumerId, int maxItems) throws Exception {
        ICMDbConnection connection = this.getConnection(store);
        Summary.Timer getTimer = this.getItemsSummary.startTimer();
        ArrayList<ICMQueueItem> items = new ArrayList<ICMQueueItem>(maxItems);
        PreparedStatement stmt = null;
        int count = 0;
        try {
            store.beginTransaction();
            stmt = this.prepareGetItemsStatement(connection);
            ResultSet rs = stmt.executeQuery();
            while (rs.next() && count++ < maxItems) {
                CMInMemoryQueueItem item = this.buildItemFromDBRecord(consumerId, rs);
                items.add(item);
            }
            rs.close();
            store.commitTransaction();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            this.safeRelease(store);
            getTimer.close();
            this.closeTimerAndGauge(getTimer, this.msPerGet, maxItems);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        this.safeRelease(store);
        getTimer.close();
        this.closeTimerAndGauge(getTimer, this.msPerGet, maxItems);
        return items;
    }

    private PreparedStatement prepareGetItemsStatement(ICMDbConnection connection) throws SQLException {
        String getSelectTopSql = SELECT_CLAUSE + this.queueTable + WHERE_CLAUSE;
        PreparedStatement stmt = connection.prepareStatement(getSelectTopSql);
        this.intBinder.bindData(stmt, 1, CMQueueItemState.AVAILABLE.ordinal());
        return stmt;
    }

    private void closeTimerAndGauge(Summary.Timer timer, Gauge msPerItem, int numOfItems) {
        timer.close();
        msPerItem.set(timer.observeDuration() * 1000.0 / (double)numOfItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CMStore store, List<ICMQueueItem> items) throws Exception {
        if (items.isEmpty()) {
            return;
        }
        Summary.Timer removeTimer = this.removeItemsSummary.startTimer();
        ICMDbConnection connection = this.getConnection(store);
        PreparedStatement stmt = null;
        try {
            store.beginTransaction();
            stmt = this.prepareRemoveStatement(connection);
            int count = 0;
            for (ICMQueueItem item : items) {
                this.stringBinder.bindData(stmt, 1, item.getQItemID());
                stmt.addBatch();
                if ((++count & 0x3FF) != 0) continue;
                stmt.executeBatch();
            }
            if ((count & 0x3FF) != 0) {
                stmt.executeBatch();
            }
            this.depthGauge.dec((double)items.size());
            store.commitTransaction();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            this.safeRelease(store);
            this.closeTimerAndGauge(removeTimer, this.msPerRemove, items.size());
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        this.safeRelease(store);
        this.closeTimerAndGauge(removeTimer, this.msPerRemove, items.size());
    }

    private PreparedStatement prepareRemoveStatement(ICMDbConnection connection) throws SQLException {
        String removeitemSql = "DELETE FROM " + this.queueTable + " WHERE ITEMID = ?";
        return connection.prepareStatement(removeitemSql);
    }
}

