/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.queues;

import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueue;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueManager;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueStatus;
import com.cognos.cm.queues.CMBlockingQueue;
import com.cognos.cm.queues.CMInMemoryQueueItem;
import com.cognos.cm.queues.CMQueueManagerBuilder;
import com.cognos.cm.queues.CMQueueStatus;
import com.cognos.cm.queues.ICMQueueManagerBuilder;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.PluginLoader;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CMQueueManager
implements ICMQueueManager {
    public static final String ARCHIVE_AND_DELETE_FLOW = "archiveAndDelete";
    public static final String ARCHIVE_FLOW = "archive";
    public static final String DELETE_FLOW = "delete";
    public static final String SEARCHINDEX_FLOW = "searchIndex";
    public static final String SYNCHROMESH_FLOW = "synchromesh";
    private static ICMQueueManager manager = new CMQueueManager();
    private Map<String, ICMQueue> queues;
    private Map<String, LinkedHashSet<String>> workFlowDefinitions;
    private ICMQueueManagerBuilder builder;
    private boolean isStarted = false;
    private ReadWriteLock configurationLock = new ReentrantReadWriteLock();

    protected CMQueueManager() {
    }

    public static ICMQueueManager getManager() {
        return manager;
    }

    @Override
    public void start() throws CMException {
        try {
            this.configurationLock.writeLock().lock();
            this.ensureManagerNotStarted();
            this.initialize();
            this.isStarted = true;
        }
        finally {
            this.configurationLock.writeLock().unlock();
        }
    }

    @Override
    public void stop() throws CMException {
        try {
            this.configurationLock.writeLock().lock();
            this.ensureManagerStarted();
            this.reset();
            this.isStarted = false;
        }
        finally {
            this.configurationLock.writeLock().unlock();
        }
    }

    private void initialize() throws CMException {
        if (this.builder == null) {
            this.builder = new CMQueueManagerBuilder(PluginLoader.get());
        }
        this.queues = this.builder.buildQueues();
        this.workFlowDefinitions = this.builder.buildWorkFlows();
    }

    private void reset() {
        this.clearVariables();
    }

    private void clearVariables() {
        this.queues.clear();
        this.workFlowDefinitions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsCompleted(CMStore store, List<ICMQueueItem> queueItems) throws CMException {
        if (queueItems.isEmpty()) {
            return;
        }
        String queueName = this.getQueueName(queueItems);
        String workflow = this.getWorkflow(queueItems);
        ICMQueue queue = null;
        ICMQueue nextQueue = null;
        try {
            this.configurationLock.readLock().lock();
            this.ensureManagerStarted();
            queue = this.queues.get(queueName);
            String nextQueueName = this.getNextQueueName(queueName, workflow);
            if (nextQueueName != null) {
                nextQueue = this.queues.get(nextQueueName);
            }
        }
        finally {
            this.configurationLock.readLock().unlock();
        }
        queue.remove(store, queueItems);
        if (nextQueue != null) {
            nextQueue.put(store, queueItems);
        }
    }

    private String getQueueName(List<ICMQueueItem> queueItems) {
        return queueItems.get(0).getQName();
    }

    private String getWorkflow(List<ICMQueueItem> queueItems) {
        return queueItems.get(0).getWorkFlow();
    }

    @Override
    public void markAsFailed(CMStore store, List<ICMQueueItem> queueItems) throws CMException {
        if (queueItems.isEmpty()) {
            return;
        }
        String queueName = this.getQueueName(queueItems);
        ICMQueue queue = this.getQueue(queueName);
        queue.updateState(store, CMQueueItemState.FAILED, queueItems);
    }

    @Override
    public ICMQueueItem get(CMStore store, String queueName, String consumerId) throws CMException {
        ICMQueue queue = this.getQueue(queueName);
        return queue.get(store, consumerId);
    }

    private ICMQueue getQueue(String queueName) throws CMException {
        try {
            this.configurationLock.readLock().lock();
            this.ensureManagerStarted();
            this.ensureQueueExists(queueName);
            ICMQueue iCMQueue = this.queues.get(queueName);
            return iCMQueue;
        }
        finally {
            this.configurationLock.readLock().unlock();
        }
    }

    @Override
    public List<ICMQueueItem> get(CMStore store, String queueName, String consumerId, int maxItems) throws CMException {
        ICMQueue queue = this.getQueue(queueName);
        return queue.get(store, consumerId, maxItems);
    }

    @Override
    public void put(CMStore store, String objectId, String workFlowName, Object data) throws CMException {
        ICMQueue queue = this.getFirstQueue(workFlowName);
        queue.put(store, new CMInMemoryQueueItem(objectId, this.getFirstQueueName(workFlowName), workFlowName, data));
    }

    private ICMQueue getFirstQueue(String workFlowName) throws CMException {
        try {
            this.configurationLock.readLock().lock();
            this.ensureManagerStarted();
            this.ensureFlowExists(workFlowName);
            ICMQueue iCMQueue = this.queues.get(this.getFirstQueueName(workFlowName));
            return iCMQueue;
        }
        finally {
            this.configurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconcileForConsumer(CMStore store, String consumerId) throws CMException {
        Iterator queuesIterator;
        try {
            this.configurationLock.readLock().lock();
            this.ensureManagerStarted();
            queuesIterator = new LinkedList<ICMQueue>(this.queues.values()).iterator();
        }
        finally {
            this.configurationLock.readLock().unlock();
        }
        while (queuesIterator.hasNext()) {
            ((ICMQueue)queuesIterator.next()).reconcileAllItemsForConsumer(store, consumerId);
        }
    }

    @Override
    public void updateConfiguration() throws CMException {
        Map<String, ICMQueue> newQueues = this.builder.buildNewQueues(this.queues.keySet());
        try {
            this.configurationLock.writeLock().lock();
            this.ensureManagerStarted();
            this.queues.putAll(newQueues);
            this.workFlowDefinitions = this.builder.buildWorkFlows();
        }
        finally {
            this.configurationLock.writeLock().unlock();
        }
    }

    @Override
    public ICMQueueStatus getStatus(CMStore store, String queueName) throws CMException {
        ICMQueue queue = this.getQueue(queueName);
        return new CMQueueStatus(queue);
    }

    @Override
    public void cleanQueue(CMStore store, String queueName) throws CMException {
        ICMQueue queue = this.getQueue(queueName);
        queue.clean(store);
    }

    private void ensureQueueExists(String queueName) throws CMException {
        if (!this.isQueuePresent(queueName)) {
            throw new CMException("cmErrorQueueDoesNotExist", new CMException.Parm("Queue", queueName));
        }
    }

    private boolean isQueuePresent(String queueName) {
        return this.queues.containsKey(queueName);
    }

    private void ensureFlowExists(String workFlowName) throws CMException {
        if (!this.isWorkFlowPresent(workFlowName)) {
            throw new CMException("cmErrorWorkFlowDoesNotExist", new CMException.Parm("WorkFlow", workFlowName));
        }
    }

    private boolean isWorkFlowPresent(String workFlowName) {
        return this.workFlowDefinitions.containsKey(workFlowName);
    }

    private void ensureManagerStarted() throws CMException {
        if (!this.isStarted()) {
            this.throwManagerNotStartedException();
        }
    }

    private void ensureManagerNotStarted() throws CMException {
        if (this.isStarted()) {
            this.throwManagerAlreadyStartedException();
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    private void throwManagerNotStartedException() throws CMException {
        throw new CMException("cmErrorQueuesManagerNotStarted");
    }

    private void throwManagerAlreadyStartedException() throws CMException {
        throw new CMException("cmErrorQueuesManagerAlreadyStarted");
    }

    @Override
    public String getFirstQueueName(String workFlowName) {
        Iterator flowIterator = this.workFlowDefinitions.get(workFlowName).iterator();
        if (flowIterator.hasNext()) {
            return (String)flowIterator.next();
        }
        return null;
    }

    private String getNextQueueName(String currentQueueName, String workFlowName) {
        Iterator flowIterator = this.workFlowDefinitions.get(workFlowName).iterator();
        while (flowIterator.hasNext()) {
            String next = (String)flowIterator.next();
            if (!next.equalsIgnoreCase(currentQueueName) || !flowIterator.hasNext()) continue;
            return (String)flowIterator.next();
        }
        return null;
    }

    @Override
    public Set<String> getQueueNames() {
        return this.queues.keySet();
    }

    @Override
    public Map<String, LinkedHashSet<String>> getWorkflowDefinitions() {
        return this.workFlowDefinitions;
    }

    protected void setBuilder(ICMQueueManagerBuilder builder) {
        this.builder = builder;
    }

    public void stopBlockingQueues() throws CMException {
        Iterator queuesIterator;
        try {
            this.configurationLock.readLock().lock();
            this.ensureManagerStarted();
            queuesIterator = new LinkedList<ICMQueue>(this.queues.values()).iterator();
        }
        finally {
            this.configurationLock.readLock().unlock();
        }
        while (queuesIterator.hasNext()) {
            ICMQueue queue = (ICMQueue)queuesIterator.next();
            if (!(queue instanceof CMBlockingQueue)) continue;
            ((CMBlockingQueue)queue).stopBlocking();
        }
    }

    @Override
    public int getQueueSize(CMStore store, String queueName, CMQueueItemState state) throws CMException {
        ICMQueue queue = this.getQueue(queueName);
        return queue.size(store, state);
    }
}

