/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.queues;

import com.cognos.cm.backgroundTaskPluginAPI.ICMQueue;
import com.cognos.cm.queues.CMBlockingQueue;
import com.cognos.cm.queues.ICMQueueManagerBuilder;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.IPluginLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Element;

public class CMQueueManagerBuilder
implements ICMQueueManagerBuilder {
    private IPluginLoader pluginLoader;
    private static final HashMap<String, Class<?>> pluginClasses = new HashMap();

    public CMQueueManagerBuilder(IPluginLoader pluginLoader) {
        this.pluginLoader = pluginLoader;
    }

    @Override
    public Map<String, ICMQueue> buildQueues() throws CMException {
        HashMap<String, ICMQueue> queues = new HashMap<String, ICMQueue>();
        Document queueManagerConfigurationDocument = this.pluginLoader.getPluginConfigurationDocument("/WEB-INF/cm/queues/config/queueManager.xml");
        try {
            Element rootNode = queueManagerConfigurationDocument.getRootElement();
            Element queueDefinitions = rootNode.element("queueDefinitions");
            List queueElements = queueDefinitions.elements("queue");
            for (Element queueElement : queueElements) {
                String queueName = this.pluginLoader.getRequiredAttribute(queueElement, "name", "/WEB-INF/cm/queues/config/queueManager.xml");
                if (queues.containsKey(queueName)) {
                    throw new CMException("cmQueueNameNotUnique", new CMException.Parm("Name", queueName));
                }
                ICMQueue queue = this.createQueueFromElement(queueElement);
                Element definitionParameters = queueElement.element("definitionParameters");
                queue.init(queueName, definitionParameters);
                queues.put(queueName, queue);
            }
        }
        catch (Throwable ex) {
            throw this.pluginLoader.createConfigurationParsingException("/WEB-INF/cm/queues/config/queueManager.xml", ex);
        }
        return queues;
    }

    @Override
    public Map<String, LinkedHashSet<String>> buildWorkFlows() throws CMException {
        HashMap<String, LinkedHashSet<String>> workFlowDefinitionsMap = new HashMap<String, LinkedHashSet<String>>();
        Document queueManagerConfigurationDocument = this.pluginLoader.getPluginConfigurationDocument("/WEB-INF/cm/queues/config/queueManager.xml");
        try {
            Element rootNode = queueManagerConfigurationDocument.getRootElement();
            Set<String> definedQueueNames = this.createSetOfQueueNames(rootNode);
            Element workFlowDefinitions = rootNode.element("workflowDefinitions");
            List workFlowDefinitionElements = workFlowDefinitions.elements();
            for (Element workFlowDefinitionElement : workFlowDefinitionElements) {
                String workFlowDefinitionName = this.pluginLoader.getRequiredAttribute(workFlowDefinitionElement, "name", "/WEB-INF/cm/queues/config/queueManager.xml");
                if (workFlowDefinitionsMap.containsKey(workFlowDefinitionName)) {
                    throw new CMException("cmErrorQueuesWorkFlowNameNotUnique", new CMException.Parm("Name", workFlowDefinitionName));
                }
                workFlowDefinitionsMap.put(workFlowDefinitionName, this.createWorkFlowFromElement(workFlowDefinitionElement, definedQueueNames));
            }
        }
        catch (Throwable ex) {
            throw this.pluginLoader.createConfigurationParsingException("/WEB-INF/cm/queues/config/queueManager.xml", ex);
        }
        return workFlowDefinitionsMap;
    }

    @Override
    public Map<String, ICMQueue> buildNewQueues(Set<String> presentQueueNames) throws CMException {
        HashMap<String, ICMQueue> newQueues = new HashMap<String, ICMQueue>();
        Map<String, ICMQueue> allQueues = this.buildQueues();
        for (String queueName : allQueues.keySet()) {
            if (presentQueueNames.contains(queueName)) continue;
            newQueues.put(queueName, allQueues.get(queueName));
        }
        return newQueues;
    }

    private LinkedHashSet<String> createWorkFlowFromElement(Element workFlowDefinitionElement, Set<String> definedQueueNames) throws CMException {
        TreeMap<Integer, String> sortedSteps = new TreeMap<Integer, String>();
        Element steps = workFlowDefinitionElement.element("steps");
        List flowElements = steps.elements();
        for (Element flowElement : flowElements) {
            int order = Integer.parseInt(flowElement.attributeValue("stepNumber"));
            String queue = flowElement.attributeValue("queue");
            if (!definedQueueNames.contains(queue)) {
                throw new CMException("cmErrorQueueNotDefined", new CMException.Parm("Name", order + ": " + queue));
            }
            if (sortedSteps.containsValue(queue) || sortedSteps.containsKey(order)) {
                throw new CMException("cmErrorDuplicateFlowElement", new CMException.Parm("Name", order + ": " + queue));
            }
            sortedSteps.put(order, queue);
        }
        LinkedHashSet<String> workFlow = new LinkedHashSet<String>();
        for (String step : sortedSteps.values()) {
            workFlow.add(step);
        }
        return workFlow;
    }

    private Set<String> createSetOfQueueNames(Element rootNode) throws CMException {
        HashSet<String> queueNames = new HashSet<String>();
        Element queueDefinitions = rootNode.element("queueDefinitions");
        List queueElements = queueDefinitions.elements("queue");
        Iterator queueElementsIterator = queueElements.iterator();
        while (queueElementsIterator.hasNext()) {
            String queueName = this.pluginLoader.getRequiredAttribute((Element)queueElementsIterator.next(), "name", "/WEB-INF/cm/queues/config/queueManager.xml");
            if (queueNames.contains(queueName)) {
                throw new CMException("cmQueueNameNotUnique", new CMException.Parm("Name", queueName));
            }
            queueNames.add(queueName);
        }
        return queueNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICMQueue createQueueFromElement(Element queueElement) throws CMException, IllegalAccessException, InstantiationException, Exception {
        Class<?> queueClass;
        String queueClassName = this.pluginLoader.getRequiredAttribute(queueElement, "class", "/WEB-INF/cm/queues/config/queueManager.xml");
        boolean blockingInDB = new Boolean(queueElement.attributeValue("blockingInDBQueue"));
        HashMap<String, Class<?>> hashMap = pluginClasses;
        synchronized (hashMap) {
            queueClass = this.pluginLoader.getPluginWithCaching(pluginClasses, queueClassName);
        }
        ICMQueue queue = (ICMQueue)queueClass.newInstance();
        if (blockingInDB) {
            int blockingTimeout = Integer.parseInt(this.pluginLoader.getRequiredAttribute(queueElement, "blockingTimeout", "/WEB-INF/cm/queues/config/queueManager.xml"));
            return new CMBlockingQueue(queue, blockingTimeout);
        }
        return queue;
    }
}

