/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.queues;

import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueue;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbStore;
import com.cognos.cm.queues.CMInDBQueue;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMWhileDeadlockExecutor;
import java.util.List;
import org.dom4j.Element;

public class DeadlockProtectedQueue
implements ICMQueue {
    private CMInDBQueue target;

    public DeadlockProtectedQueue(CMInDBQueue queue) {
        this.target = queue;
    }

    @Override
    public void init(String queueName, Element definitionParameters) throws CMException {
        this.target.init(queueName, definitionParameters);
    }

    @Override
    public boolean put(CMStore store, ICMQueueItem item) throws CMException {
        return this.executeInDeadlockLoop(store, () -> this.target.put(store, item));
    }

    @Override
    public boolean put(CMStore store, List<ICMQueueItem> items) throws CMException {
        return this.executeInDeadlockLoop(store, () -> this.target.put(store, items));
    }

    @Override
    public int size(CMStore store, CMQueueItemState state) throws CMException {
        return this.executeInDeadlockLoop(store, () -> this.target.size(store, state));
    }

    @Override
    public ICMQueueItem get(CMStore store, String consumerId) throws CMException {
        return this.executeInDeadlockLoop(store, () -> this.target.get(store, consumerId));
    }

    @Override
    public List<ICMQueueItem> get(CMStore store, String consumerId, int maxItems) throws CMException {
        return this.executeInDeadlockLoop(store, () -> this.target.get(store, consumerId, maxItems));
    }

    @Override
    public void remove(CMStore store, ICMQueueItem item) throws CMException {
        this.executeInDeadlockLoop(store, () -> {
            this.target.remove(store, item);
            return null;
        });
    }

    @Override
    public void remove(CMStore store, List<ICMQueueItem> items) throws CMException {
        this.executeInDeadlockLoop(store, () -> {
            this.target.remove(store, items);
            return null;
        });
    }

    @Override
    public int reconcileAllItemsForConsumer(CMStore store, String consumerId) throws CMException {
        return this.executeInDeadlockLoop(store, () -> this.target.reconcileAllItemsForConsumer(store, consumerId));
    }

    @Override
    public boolean updateState(CMStore store, CMQueueItemState state, ICMQueueItem item) throws CMException {
        return this.executeInDeadlockLoop(store, () -> this.target.updateState(store, state, item));
    }

    @Override
    public boolean updateState(CMStore store, CMQueueItemState state, List<ICMQueueItem> items) throws CMException {
        return this.executeInDeadlockLoop(store, () -> this.target.updateState(store, state, items));
    }

    @Override
    public void clean(CMStore store) throws CMException {
        this.executeInDeadlockLoop(store, () -> {
            this.target.clean(store);
            return null;
        });
    }

    @Override
    public int reconcileFailedItems(CMStore store) throws CMException {
        return this.executeInDeadlockLoop(store, () -> this.target.reconcileFailedItems(store));
    }

    private ICMDbConnection getConnection(CMStore store) throws CMException {
        return ((ICMDbStore)store).getICMDbConnection();
    }

    private <T> T executeInDeadlockLoop(CMStore store, CMWhileDeadlockExecutor.DeadlockProtected<T> runnable) throws CMException {
        return CMWhileDeadlockExecutor.execute(runnable, this.getConnection(store), "cmErrorQueueOperationFailure");
    }
}

