/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.queues;

import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueue;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.queues.CMInMemoryQueueItem;
import com.cognos.cm.queues.CMIndexQueueData;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class MemoryIndexQueue
implements ICMQueue {
    private static final Set<String> LOW_PRIORITY_CLASSES = new HashSet<String>(Arrays.asList("smartsModule", "account"));
    private static final Map<String, String> HIGH_PRIORITY_OPERATIONS = new HashMap<String, String>();
    private static final int MAX_LOW_PRIORITY_ITEMS_PER_FETCH = 10;
    private final LinkedList<CMInMemoryQueueItem> highPriorityQueue = new LinkedList();
    private final LinkedHashMap<String, CMInMemoryQueueItem> lowPriorityQueue = new LinkedHashMap();
    private long nextQueueItemId = 0L;

    @Override
    public void init(String queueName, Element definitionParameters) {
    }

    @Override
    public synchronized ICMQueueItem get(CMStore store, String consumerId) {
        if (this.highPriorityQueue.isEmpty()) {
            return this.removeLowPriorityItem();
        }
        return this.highPriorityQueue.poll();
    }

    private ICMQueueItem removeLowPriorityItem() {
        if (this.lowPriorityQueue.isEmpty()) {
            return null;
        }
        String firstObjectId = this.lowPriorityQueue.keySet().iterator().next();
        return (ICMQueueItem)this.lowPriorityQueue.remove(firstObjectId);
    }

    @Override
    public synchronized List<ICMQueueItem> get(CMStore store, String consumerId, int maxItems) throws CMException {
        ICMQueueItem item;
        ArrayList<ICMQueueItem> items = new ArrayList<ICMQueueItem>(maxItems);
        int lowPriorityCount = 0;
        for (int i = 0; i < maxItems && (item = this.get(store, consumerId)) != null; ++i) {
            items.add(item);
            if (this.isLowPriority(item) && ++lowPriorityCount == 10) break;
        }
        return items;
    }

    @Override
    public synchronized boolean put(CMStore store, ICMQueueItem item) {
        CMInMemoryQueueItem inMemoryItem = this.toInMemoryItem(item);
        if (inMemoryItem != null) {
            this.putItem(inMemoryItem);
            return true;
        }
        return false;
    }

    private CMInMemoryQueueItem toInMemoryItem(ICMQueueItem item) {
        return item instanceof CMInMemoryQueueItem ? (CMInMemoryQueueItem)item : null;
    }

    private void putItem(CMInMemoryQueueItem item) {
        if (this.hasRoomFor(item)) {
            item.setState(CMQueueItemState.AVAILABLE);
            item.setQItemID(this.createQueueItemId());
            this.addOrReplace(item);
        }
    }

    private boolean hasRoomFor(CMInMemoryQueueItem item) {
        return this.isNotFull() && !this.shouldDiscard(item);
    }

    private boolean isNotFull() {
        return this.getTotalSize() < AdvancedSettings.INDEX_MAXNOTIFICATIONQUEUECAPACITY;
    }

    private boolean shouldDiscard(CMInMemoryQueueItem item) {
        return this.isLowPriority(item) && this.lowPriorityQueue.size() >= this.getMaxLowPriorityQueueSize();
    }

    private int getMaxLowPriorityQueueSize() {
        return AdvancedSettings.INDEX_MAXNOTIFICATIONQUEUECAPACITY * AdvancedSettings.INDEX_LOWPRIORITYQUEUECAPACITYPERCENT / 100;
    }

    private String createQueueItemId() {
        return String.valueOf(this.nextQueueItemId++);
    }

    private void addOrReplace(CMInMemoryQueueItem item) {
        if (this.isLowPriority(item)) {
            this.addOrReplace(item, this.lowPriorityQueue);
        } else {
            this.highPriorityQueue.offer(item);
        }
    }

    private boolean isLowPriority(ICMQueueItem item) {
        String objectClass = this.getObjectClass(item);
        return objectClass != null && !this.isHighPriority(objectClass, this.getOperation(item)) && LOW_PRIORITY_CLASSES.contains(objectClass);
    }

    protected boolean isHighPriority(String objectClass, String operation) {
        return operation != null && operation.equals(HIGH_PRIORITY_OPERATIONS.get(objectClass));
    }

    private String getObjectClass(ICMQueueItem item) {
        CMIndexQueueData data = (CMIndexQueueData)item.getData();
        return data != null ? data.getObjectClass() : null;
    }

    private String getOperation(ICMQueueItem item) {
        CMIndexQueueData data = (CMIndexQueueData)item.getData();
        return data != null ? data.getOperation() : null;
    }

    private void addOrReplace(CMInMemoryQueueItem item, LinkedHashMap<String, CMInMemoryQueueItem> queue) {
        String objectID = item.getObjectID();
        if (queue.containsKey(objectID)) {
            this.lowPriorityQueue.replace(objectID, item);
        } else {
            this.lowPriorityQueue.put(objectID, item);
        }
    }

    @Override
    public synchronized boolean put(CMStore store, List<ICMQueueItem> items) throws CMException {
        for (ICMQueueItem item : items) {
            this.put(store, item);
        }
        return true;
    }

    @Override
    public synchronized void clean(CMStore store) throws CMException {
        this.highPriorityQueue.clear();
        this.lowPriorityQueue.clear();
    }

    @Override
    public void remove(CMStore store, ICMQueueItem item) {
    }

    @Override
    public void remove(CMStore store, List<ICMQueueItem> items) throws CMException {
    }

    @Override
    public synchronized int size(CMStore store, CMQueueItemState state) {
        return state == CMQueueItemState.AVAILABLE ? this.getTotalSize() : 0;
    }

    private int getTotalSize() {
        return this.highPriorityQueue.size() + this.lowPriorityQueue.size();
    }

    @Override
    public boolean updateState(CMStore store, CMQueueItemState newState, ICMQueueItem item) {
        return true;
    }

    @Override
    public boolean updateState(CMStore store, CMQueueItemState state, List<ICMQueueItem> items) throws CMException {
        return true;
    }

    @Override
    public int reconcileAllItemsForConsumer(CMStore store, String consumerId) {
        return 0;
    }

    @Override
    public int reconcileFailedItems(CMStore store) {
        return 0;
    }

    static {
        HIGH_PRIORITY_OPERATIONS.put("account", "add");
    }
}

