/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.replication;

import com.cognos.cm.replication.MergeSort;
import com.cognos.cm.replication.MergeStream;
import com.cognos.cm.replication.TwoWayMerge;
import com.cognos.cmutils.values.MathUtils;
import java.util.Comparator;

public class KWayMerge
implements MergeStream {
    private int size_;
    private int limit_;
    private int compactLimit_;
    private int[] nodes_;
    private MergeStream[] streams_;
    private Comparator cmp_;
    private MergeSort mergeSort_;

    private KWayMerge(MergeStream[] streams, Comparator cmp, MergeSort proxy) {
        this.mergeSort_ = proxy;
        this.cmp_ = cmp;
        this.size_ = streams.length;
        this.limit_ = MathUtils.pow2((int)this.size_);
        this.compactLimit_ = this.limit_ >> 1;
        this.nodes_ = new int[this.limit_];
        this.streams_ = new MergeStream[this.limit_];
        for (int i = 0; i < this.size_; ++i) {
            this.streams_[i] = streams[i];
        }
        NullStream ns = new NullStream();
        for (int i = this.size_; i < this.limit_; ++i) {
            this.streams_[i] = ns;
        }
        this.nodes_[0] = this.initTree(1);
    }

    static MergeStream create(MergeStream[] streams, Comparator cmp, MergeSort proxy) {
        return new KWayMerge(streams, cmp, proxy);
    }

    @Override
    public boolean empty() {
        return this.size_ == 0;
    }

    private void switch2TwoWayMerge() {
        MergeStream[] streams = new MergeStream[2];
        int j = 0;
        for (int i = 0; i < this.streams_.length; ++i) {
            if (this.streams_[i].empty()) continue;
            streams[j++] = this.streams_[i];
            if (j == 2) break;
        }
        this.mergeSort_.sortStream = TwoWayMerge.create(streams, this.cmp_, this.mergeSort_);
    }

    private void compactTree() {
        int k = this.compactLimit_;
        block0: for (int i = 0; i < this.compactLimit_; ++i) {
            if (!this.streams_[i].empty()) continue;
            while (k < this.limit_) {
                if (!this.streams_[k].empty()) {
                    this.streams_[i] = this.streams_[k++];
                    continue block0;
                }
                ++k;
            }
        }
        this.size_ = this.limit_ = this.compactLimit_;
        this.compactLimit_ >>= 1;
        this.nodes_[0] = this.initTree(1);
    }

    @Override
    public Object pop() {
        this.update();
        Object result = this.node2stream(0).pop();
        if (this.node2stream(0).empty()) {
            --this.size_;
            if (this.size_ == 2) {
                this.switch2TwoWayMerge();
            } else if (this.size_ == this.compactLimit_) {
                this.compactTree();
            }
        }
        return result;
    }

    @Override
    public Object peek() {
        return this.node2stream(0).peek();
    }

    private int initTree(int root) {
        if (root >= this.limit_) {
            return root - this.limit_;
        }
        int left = this.initTree(root << 1);
        int right = this.initTree((root << 1) + 1);
        if (this.streams_[right].empty()) {
            this.nodes_[root] = right;
            return left;
        }
        if (this.streams_[left].empty()) {
            this.nodes_[root] = left;
            return right;
        }
        if (this.cmp_.compare(this.streams_[left].peek(), this.streams_[right].peek()) <= 0) {
            this.nodes_[root] = right;
            return left;
        }
        this.nodes_[root] = left;
        return right;
    }

    private MergeStream node2stream(int i) {
        return this.streams_[this.nodes_[i]];
    }

    private void update() {
        int winer = this.nodes_[0];
        for (int i = this.limit_ + winer >> 1; i != 0; i >>= 1) {
            if (!this.streams_[winer].empty() && (this.node2stream(i).empty() || this.cmp_.compare(this.node2stream(i).peek(), this.streams_[winer].peek()) >= 0)) continue;
            int t = winer;
            winer = this.nodes_[i];
            this.nodes_[i] = t;
        }
        this.nodes_[0] = winer;
    }

    public class NullStream
    implements MergeStream {
        @Override
        public boolean empty() {
            return true;
        }

        @Override
        public Object pop() {
            return null;
        }

        @Override
        public Object peek() {
            return null;
        }
    }
}

