/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.replication;

public final class RObject {
    public static final short UNCHECKED = 0;
    public static final short DELETED = 1;
    public static final short ADDED = 2;
    public static final short MOVED = 4;
    public static final short UPDATED = 8;
    public static final short UNCHANGED = 16;
    public static final int BUF_SIZE = 42;
    private static final int OFF_STOREID = 0;
    private static final int OFF_PARENT = 16;
    private static final int OFF_VERSION = 32;
    private static final int OFF_CLASS = 36;
    private static final int OFF_SET = 38;
    private static final int OFF_STATE = 40;
    private static final byte[] hex2bin = new byte[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 16, 16, 16, 16, 16, 16, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 11, 12, 13, 14, 15};
    private static final char[] bin2hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private byte[] buf_;
    private int off_;

    private static void putShort(byte[] buf, int off, short value) {
        buf[off] = (byte)(value >> 8);
        buf[off + 1] = (byte)(value >> 0);
    }

    private static short getShort(byte[] buf, int off) {
        return (short)(buf[off] << 8 | buf[off + 1] & 0xFF);
    }

    private static void putInt(byte[] buf, int off, int value) {
        buf[off] = (byte)(value >> 24);
        buf[off + 1] = (byte)(value >> 16);
        buf[off + 2] = (byte)(value >> 8);
        buf[off + 3] = (byte)(value >> 0);
    }

    private static int getInt(byte[] buf, int off) {
        return (buf[off] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | (buf[off + 3] & 0xFF) << 0;
    }

    private void str2uuid(String s, byte[] b, int off) {
        byte[] sb = s.getBytes();
        if (sb.length != 33 || sb[0] != 105) {
            throw new IllegalStateException("Invalid storeID: " + s);
        }
        try {
            int i = 1;
            while (i < 33) {
                byte b1 = hex2bin[sb[i++]];
                byte b2 = hex2bin[sb[i++]];
                if (b1 == 16 || b2 == 16) {
                    throw new IllegalStateException("Invalid storeID: " + s);
                }
                b[off++] = (byte)(b1 << 4 | b2);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException("Invalid storeID: " + s);
        }
    }

    private String uuid2str(byte[] buf, int off) {
        char[] s = new char[33];
        s[0] = 105;
        int i = 1;
        while (i < 33) {
            byte b = buf[off++];
            s[i++] = bin2hex[b >>> 4 & 0xF];
            s[i++] = bin2hex[b & 0xF];
        }
        return new String(s);
    }

    RObject(String storeID, String parent, int version, int classId, int set) {
        this.buf_ = new byte[42];
        this.objectID(storeID);
        this.parentID(parent);
        this.version(version);
        this.classID(classId);
        this.setID(set);
    }

    RObject(byte[] buf, int offset) {
        this.buf_ = buf;
        this.off_ = offset;
    }

    public int offset() {
        return this.off_;
    }

    public void offset(int off) {
        this.off_ = off;
    }

    public void buffer(byte[] buf) {
        this.buf_ = buf;
    }

    public byte[] buffer() {
        return this.buf_;
    }

    public String objectID() {
        return this.uuid2str(this.buf_, this.off_ + 0);
    }

    public void objectID(String s) {
        this.str2uuid(s, this.buf_, this.off_ + 0);
    }

    public String parentID() {
        return this.uuid2str(this.buf_, this.off_ + 16);
    }

    public void parentID(String s) {
        this.str2uuid(s, this.buf_, this.off_ + 16);
    }

    public int classID() {
        return RObject.getShort(this.buf_, this.off_ + 36);
    }

    public void classID(int classId) {
        RObject.putShort(this.buf_, this.off_ + 36, (short)classId);
    }

    public int version() {
        return RObject.getInt(this.buf_, this.off_ + 32);
    }

    public void version(int ver) {
        RObject.putInt(this.buf_, this.off_ + 32, ver);
    }

    public short state() {
        return RObject.getShort(this.buf_, this.off_ + 40);
    }

    public void state(int state) {
        RObject.putShort(this.buf_, this.off_ + 40, (short)state);
    }

    public short setID() {
        return RObject.getShort(this.buf_, this.off_ + 38);
    }

    public void setID(int id) {
        RObject.putShort(this.buf_, this.off_ + 38, (short)id);
    }

    public void copyTo(byte[] buf, int off) {
        byte[] s = this.buf_;
        int i = this.off_;
        int limit = i + 42;
        while (i < limit) {
            buf[off] = s[i];
            ++i;
            ++off;
        }
    }

    public static class Comparator
    implements java.util.Comparator {
        private int offset;

        public Comparator(boolean primary) {
            this.offset = primary ? 0 : 16;
        }

        public int compare(Object o1, Object o2) {
            byte[] left = ((RObject)o1).buf_;
            byte[] right = ((RObject)o2).buf_;
            int ol = ((RObject)o1).off_ + this.offset;
            int or = ((RObject)o2).off_ + this.offset;
            int limit = ol + 16;
            while (ol < limit) {
                int diff = left[ol] - right[or];
                if (diff != 0) {
                    return diff;
                }
                ++ol;
                ++or;
            }
            return 0;
        }
    }
}

