/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.replication;

import com.cognos.cm.replication.MergeSort;
import com.cognos.cm.replication.MergeStream;
import java.util.Comparator;

public class TwoWayMerge
implements MergeStream {
    MergeStream s1_;
    MergeStream s2_;
    Comparator cmp_;
    MergeSort sortProxy_;

    private TwoWayMerge(MergeStream[] s, Comparator cmp, MergeSort proxy) {
        this.s1_ = s[0];
        this.s2_ = s[1];
        this.cmp_ = cmp;
        this.sortProxy_ = proxy;
    }

    static MergeStream create(MergeStream[] streams, Comparator cmp, MergeSort proxy) {
        if (streams[0].empty()) {
            return streams[1];
        }
        if (streams[1].empty()) {
            return streams[0];
        }
        return new TwoWayMerge(streams, cmp, proxy);
    }

    @Override
    public boolean empty() {
        return false;
    }

    @Override
    public Object peek() {
        Object o2;
        Object o1 = this.s1_.peek();
        return this.cmp_.compare(o1, o2 = this.s2_.peek()) <= 0 ? o1 : o2;
    }

    @Override
    public Object pop() {
        Object ret;
        if (this.cmp_.compare(this.s1_.peek(), this.s2_.peek()) <= 0) {
            ret = this.s1_.pop();
            if (this.s1_.empty()) {
                this.sortProxy_.sortStream = this.s2_;
            }
        } else {
            ret = this.s2_.pop();
            if (this.s2_.empty()) {
                this.sortProxy_.sortStream = this.s1_;
            }
        }
        return ret;
    }
}

