/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.server.CMException;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;

public abstract class CAMRequest
extends RequestHandler {
    protected XMLElement actionElement_;
    protected XMLElement credentialsElement_;
    protected XMLElement rolesElement_;

    public CAMRequest(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        this.parseRequest();
        this.generateActionElement();
        if (this.actionElement_ != null) {
            this.manager.replaceCAMElementInBiBusHeader(this.actionElement_);
            this.manager.processCAMAction(this.getActionString());
        }
        if (this.credentialsElement_ != null) {
            this.manager.replaceCAMElementInBiBusHeader(this.credentialsElement_);
        }
        if (this.rolesElement_ != null) {
            this.manager.replaceCAMElementInBiBusHeader(this.rolesElement_);
        }
        this.manager.setWSDLCAMRequest(true);
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        this.out.print("\t<");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print(this.getResponseString());
        this.out.print(" xmlns:");
        this.out.print("cm");
        this.out.print("=\"");
        this.out.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            this.out.print("\"");
            this.out.print(" xmlns:");
            this.out.print("cm1");
            this.out.print("=\"");
            this.out.print(this.getCMS_V1Namespace());
        }
        this.out.print("\"/>\r\n");
        return true;
    }

    protected void parseRequest() throws CMException {
    }

    protected void generateActionElement() throws CMException {
        try {
            StringBuffer sb = new StringBuffer(1000);
            sb.append("<");
            sb.append("action");
            sb.append(" xmlns:xsi=\"");
            sb.append("http://www.w3.org/2001/XMLSchema-instance");
            sb.append("\" xmlns:xsd=\"");
            sb.append("http://www.w3.org/2001/XMLSchema");
            sb.append("\"");
            sb.append(" xsi:type=\"xsd:string\">");
            sb.append(this.getActionString());
            sb.append("</");
            sb.append("action");
            sb.append(">");
            String actionMessage = sb.toString();
            XMLDocParser parser = new XMLDocParser();
            XMLDoc doc = parser.readXML(actionMessage);
            this.actionElement_ = doc.getRootXMLElement();
        }
        catch (CMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMException(e, "cmErrParse");
        }
    }

    protected abstract String getResponseString();

    protected abstract String getActionString();
}

