/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.iRequestHandler;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class CMCustomFunctionFactory {
    private static CMCustomFunctionFactory factory_ = null;
    private static final String PLUGINS_BASE = "com.cognos.cm.request.customFunctions.";
    private Map<String, Constructor<?>> constructors_ = new HashMap();

    public static CMCustomFunctionFactory getCustomFunctionFactory() {
        if (factory_ == null) {
            factory_ = new CMCustomFunctionFactory();
        }
        return factory_;
    }

    protected CMCustomFunctionFactory() {
    }

    private Class<CustomFunctionPlugin> getPluginClass(String functionName) {
        try {
            Class<CustomFunctionPlugin> klass = Class.forName(functionName);
            return klass;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public CustomFunctionPlugin getCustomPluginFromFunctionName(String functionName, iRequestHandler rh) {
        return this.getCustomFunctionPlugin(PLUGINS_BASE + functionName, rh);
    }

    public CustomFunctionPlugin getCustomFunctionPlugin(String pluginClass, iRequestHandler rh) {
        Constructor cst = this.getConstructor(pluginClass);
        if (cst == null) {
            return null;
        }
        try {
            return (CustomFunctionPlugin)cst.newInstance(rh);
        }
        catch (Exception e) {
            throw new CMRuntimeException(e);
        }
    }

    private Constructor getConstructor(String functionClass) {
        Constructor<CustomFunctionPlugin> cst = this.getCachedConstructor(functionClass);
        if (cst != null) {
            return cst;
        }
        Class<CustomFunctionPlugin> klazz = this.getPluginClass(functionClass);
        if (klazz == null) {
            return null;
        }
        try {
            cst = klazz.getConstructor(iRequestHandler.class);
        }
        catch (Exception e) {
            throw new CMRuntimeException(e);
        }
        this.cacheConstructor(functionClass, cst);
        return cst;
    }

    private void cacheConstructor(String functionClass, Constructor cst) {
        this.constructors_.put(functionClass, cst);
    }

    private Constructor getCachedConstructor(String functionClass) {
        return this.constructors_.get(functionClass);
    }
}

