/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.deployment.DeploymentContext;
import com.cognos.cm.multipart.RequestImportAttachment;
import com.cognos.cm.multipart.RequestImportDataAttachment;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.request.importRequest;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMDeploymentArchive;
import com.cognos.cm.util.CMNamespacePrefixes;
import com.cognos.cm.util.CMXMLUtils;
import java.io.InputStream;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ImportParser
implements ContentHandler,
ErrorHandler {
    private XMLDoc xmlDoc_;
    private XMLElement xmlElement_;
    private StringBuffer characters_;
    private CMStore store_;
    private CMDeploymentArchive deploymentArchive_;
    private CMNamespacePrefixes nsPrefixes = new CMNamespacePrefixes(true);
    private CMDbStoreLocalizedStringArray packageTargetNames_;
    private RequestImportAttachment attachFile_;
    private importRequest deploymentReq_;
    private CMObjectClass objClass_;
    private DeploymentContext context_;
    private boolean isUpdate_ = false;
    private boolean bCollectChars_;
    private boolean bIgnoreValue_;
    private boolean bWriteDataToFile_;
    private boolean bBase64DecodeData_;
    private boolean bGZipData_;
    private boolean bIsZipped_;
    private boolean bDataIsCompressedEl_;
    private boolean bDataSizeEl_;
    private long dataSize_ = 0L;
    private boolean bInObjects_;
    private boolean bInProps_;
    private boolean bInValue_;
    private int level_;
    private long lastCurrentTime_ = 0L;
    private static final int OBJECTS_LEVEL = 2;
    private static final int OBJECT_LEVEL = 3;
    private static final int PROPS_LEVEL = 4;
    private static final int PROPERTY_LEVEL = 5;
    private static final int VALUE_LEVEL = 6;

    public ImportParser(CMDeploymentArchive deploymentArchive, importRequest req, CMStore store) {
        this.deploymentArchive_ = deploymentArchive;
        this.deploymentReq_ = req;
        this.store_ = store;
    }

    public void updatePackage(InputStream is) throws Exception {
        this.isUpdate_ = true;
        this.importPackage(is, null, DeploymentContext.Unknown);
    }

    public void importPackage(InputStream is, CMDbStoreLocalizedStringArray packageTargetNames, DeploymentContext context) throws Exception {
        XMLReader saxParser = null;
        try {
            this.nsPrefixes.clear();
            this.packageTargetNames_ = packageTargetNames;
            this.context_ = context;
            saxParser = CMXMLUtils.getSAXParserFromPool();
            saxParser.setContentHandler(this);
            saxParser.setErrorHandler(this);
            saxParser.parse(new InputSource(is));
        }
        catch (SAXException saxE) {
            try {
                Exception ex = saxE.getException();
                throw ex != null ? ex : saxE;
            }
            catch (Throwable throwable) {
                CMXMLUtils.returnSAXParserToPool(saxParser);
                throw throwable;
            }
        }
        CMXMLUtils.returnSAXParserToPool(saxParser);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void startDocument() throws SAXException {
        this.level_ = 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.level_;
        if (this.bInObjects_) {
            this.characters_ = null;
            this.bCollectChars_ = true;
            if (this.xmlElement_ == null) {
                this.xmlDoc_ = new XMLDoc(this.nsPrefixes, uri, localName, attributes);
                this.xmlElement_ = this.xmlDoc_.getRootXMLElement();
            } else {
                this.xmlElement_ = this.xmlElement_.addChild(this.nsPrefixes, uri, localName, attributes);
            }
        }
        if (this.level_ == 2) {
            if (localName.equals("objects")) {
                this.bInObjects_ = true;
            }
        } else if (this.level_ == 4 && this.bInObjects_) {
            if (localName.equals("props")) {
                this.bInProps_ = true;
            }
        } else if (this.level_ == 5 && this.bInProps_) {
            CMProperty prop = this.objClass_.getProperty(localName);
            if (prop != null) {
                if (prop.getMeaning() == CMPropertyMeaning.DATA) {
                    this.bWriteDataToFile_ = true;
                    this.bBase64DecodeData_ = true;
                } else if (prop.getMeaning() == CMPropertyMeaning._DATAISCOMPRESSED) {
                    this.bDataIsCompressedEl_ = true;
                } else if (prop.getMeaning() == CMPropertyMeaning.DATASIZE) {
                    this.bDataSizeEl_ = true;
                } else if (prop == CMProperty.MODEL) {
                    this.bWriteDataToFile_ = true;
                    this.bGZipData_ = true;
                }
            }
        } else if (this.level_ == 6 && this.bInProps_ && localName.equals("value")) {
            this.bInValue_ = true;
            String href = attributes.getValue("href");
            if (href != null) {
                if (href.startsWith("cid:")) {
                    if (this.bWriteDataToFile_) {
                        this.bIgnoreValue_ = true;
                        String attachName = href.substring("cid:".length());
                        this.deploymentReq_.addRequestAttachment(attachName);
                    }
                } else {
                    String strSize = attributes.getValue("size");
                    long sz = Long.parseLong(strSize);
                    String attachFileName = this.generateAttachmentName();
                    RequestImportDataAttachment attach = new RequestImportDataAttachment(this.deploymentArchive_, href, sz);
                    href = "cid:" + attachFileName;
                    this.xmlElement_.replaceAttribute("href", href);
                    this.deploymentReq_.addRequestAttachment(attachFileName, attach);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.xmlElement_ != null && this.xmlElement_.children_ == null && this.characters_ != null) {
            this.xmlElement_.value_ = this.characters_.toString();
        }
        if (this.bInObjects_) {
            if (this.level_ == 2) {
                this.bInObjects_ = false;
            } else if (this.level_ == 3) {
                try {
                    XMLElement rootEl = this.xmlDoc_.getRootXMLElement();
                    if (this.isUpdate_) {
                        this.deploymentReq_.updateObject(rootEl);
                    } else if (this.context_ == DeploymentContext.ExternalNamespace) {
                        this.deploymentReq_.importUserObject(rootEl);
                    } else {
                        this.deploymentReq_.importObject(rootEl, this.packageTargetNames_, this.context_);
                    }
                }
                catch (CMException ex) {
                    throw new SAXException("import object failed", ex);
                }
                finally {
                    this.deploymentReq_.cleanupAttachments();
                }
                this.xmlDoc_ = null;
                this.xmlElement_ = null;
                this.objClass_ = null;
            } else if (this.level_ == 4) {
                if (this.bInProps_) {
                    this.bInProps_ = false;
                } else if (localName.equals("class")) {
                    this.objClass_ = this.store_.getObjectClasses().getClassByName(this.xmlElement_.value_);
                }
            } else if (this.level_ == 6 && this.bInValue_) {
                if (this.bDataIsCompressedEl_) {
                    this.bIsZipped_ = CMXMLUtils.isBooleanAttrTrue(this.xmlElement_.value_);
                    this.bDataIsCompressedEl_ = false;
                } else if (this.bDataSizeEl_) {
                    try {
                        this.dataSize_ = Long.parseLong(this.xmlElement_.value_);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalStateException("dataSize property value in import is invalid");
                    }
                    this.bDataSizeEl_ = false;
                } else if (this.bWriteDataToFile_) {
                    if (this.attachFile_ != null) {
                        this.attachFile_.finishWriting();
                        this.attachFile_ = null;
                    }
                    this.bWriteDataToFile_ = false;
                    this.bBase64DecodeData_ = false;
                    this.bGZipData_ = false;
                    this.bIsZipped_ = false;
                    this.dataSize_ = 0L;
                    this.bIgnoreValue_ = false;
                }
                this.bInValue_ = false;
            }
        }
        if (this.xmlElement_ != null) {
            this.xmlElement_ = this.xmlElement_.GetBuildParent();
            this.bCollectChars_ = false;
        }
        --this.level_;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.bWriteDataToFile_ && this.bInValue_) {
            if (!this.bIgnoreValue_) {
                try {
                    if (this.attachFile_ == null) {
                        String attachFileName = this.generateAttachmentName();
                        this.attachFile_ = new RequestImportAttachment(attachFileName, this.dataSize_, this.bIsZipped_, this.bGZipData_, this.bBase64DecodeData_);
                        String href = "cid:" + attachFileName;
                        this.xmlElement_.addAttribute("href", href);
                        this.deploymentReq_.addRequestAttachment(attachFileName, this.attachFile_);
                    }
                    this.attachFile_.write(ch, start, length);
                }
                catch (Exception ex) {
                    throw new SAXException("temp file write error", ex);
                }
            }
        } else if (this.bCollectChars_) {
            if (this.characters_ == null) {
                if (length > 0 && ch[start] == '\n') {
                    ++start;
                    --length;
                }
                this.characters_ = new StringBuffer(length);
            }
            this.characters_.append(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.nsPrefixes.remove(prefix);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.nsPrefixes.add(prefix, uri);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    private String generateAttachmentName() {
        long curTime = System.currentTimeMillis();
        this.lastCurrentTime_ = curTime > this.lastCurrentTime_ ? curTime : ++this.lastCurrentTime_;
        return CMDateUtils.getIsoDate(new Date(this.lastCurrentTime_));
    }
}

