/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.cognos.cmutils.xml.XMLUtils;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.impl.PerfException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PerfConfig
extends RequestHandler {
    public PerfConfig(CMStore store) {
        super(store);
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (!ctx.getCurrentUserIsAdministrator() && AdvancedSettings.CMPERFREQAUTH) {
            throw new CMException("cmUnknownRequest", new CMException.Parm("Name", "PerfConfig"));
        }
        CMIndentedPrintStream o = new CMIndentedPrintStream(this.oStream);
        XMLElement x = this.xmlElement_;
        this.outputBeginResp(o);
        this.enableAndDisableEntries(o, x);
        this.handleOutputToFile(o, x);
        this.outputEndResp(o);
        o.flush();
        return true;
    }

    private void enableAndDisableEntries(PrintStream o, XMLElement x) throws CMException {
        XMLElement enable = x.getChildWithName("enable");
        if (enable.value_ != null) {
            String enableValues = enable.value_;
            StringTokenizer toker = new StringTokenizer(enableValues, ",; \t");
            String[] enableArray = new String[toker.countTokens()];
            for (int i = 0; i < enableArray.length; ++i) {
                enableArray[i] = toker.nextToken();
            }
            boolean bResetPeriod = x.getOptionalChildBooleanValueWithName("resetPeriod", true);
            PerfMonitor.enableCategory((String[])enableArray, (boolean)bResetPeriod);
            this.outputEnabledCategories(o, enableArray);
            this.outputActiveEntries(o);
        }
    }

    private void handleOutputToFile(PrintStream o, XMLElement x) throws CMException {
        block14: {
            XMLElement output = x.getOptionalChildWithName("output");
            if (output != null) {
                String sAction = output.getOptionalChildValueWithName("action");
                if ("start".equals(sAction)) {
                    int nPerfOutputInterval = output.getOptionalChildIntValueWithName("interval", 1000);
                    String sUnit = output.getOptionalChildValueWithName("intervalUnit");
                    if ("second".equals(sUnit)) {
                        nPerfOutputInterval *= 1000;
                    } else if ("minute".equals(sUnit)) {
                        nPerfOutputInterval = nPerfOutputInterval * 60 * 1000;
                    }
                    String sPerfOutputFormat = output.getOptionalChildValueWithName("format");
                    String sPerfOutputLocation = output.getOptionalChildValueWithName("location");
                    String sPerfFilter = output.getOptionalChildValueWithName("filter");
                    if (sPerfFilter == null) {
                        sPerfFilter = "";
                    }
                    if (sPerfOutputFormat != null && sPerfOutputLocation != null) {
                        try {
                            boolean bStarted = PerfMonitor.startRecording((int)nPerfOutputInterval, (String)sPerfOutputFormat, (String)sPerfOutputLocation, (String)sPerfFilter);
                            if (bStarted) {
                                this.outputRecordingStatus(o, "Performance Monitoring Tool has started recording");
                                break block14;
                            }
                            this.outputRecordingStatus(o, "Performance Monitoring Tool is already recording");
                        }
                        catch (PerfException e) {
                            this.outputRecordingStatus(o, e.getMessage());
                        }
                    }
                } else if ("stop".equals(sAction)) {
                    boolean bStopped = PerfMonitor.stopRecording();
                    if (bStopped) {
                        this.outputRecordingStatus(o, "Performance Monitoring Tool has stopped recording");
                    } else {
                        this.outputRecordingStatus(o, "Performance Monitoring Tool is not recording");
                    }
                }
            }
        }
    }

    private void outputBeginResp(PrintStream o) {
        o.print("<");
        o.print(this.getCMPrefixString());
        o.print(":");
        o.print("PerfConfigResponse");
        o.print(" xmlns:");
        o.print("cm");
        o.print("=\"");
        o.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            o.print("\"");
            o.print(" xmlns:");
            o.print("cm1");
            o.print("=\"");
            o.print(this.getCMS_V1Namespace());
        }
        o.print("\">\r\n");
        this.outputTimestamp(o);
    }

    private void outputTimestamp(PrintStream o) {
        o.print("<Timestamp>");
        o.print(CMDateUtils.getTime().toString());
        o.print("</Timestamp>\r\n");
    }

    private void outputEnabledCategories(PrintStream o, String[] enableArray) {
        o.println("<Enabled>");
        for (int i = 0; i < enableArray.length; ++i) {
            o.print("<category>");
            o.print(XMLUtils.encode((String)enableArray[i]));
            o.println("</category>");
        }
        o.println("</Enabled>");
    }

    private void outputActiveEntries(PrintStream o) {
        o.println("<Active>");
        ArrayList names = PerfMonitor.getEnabledEntryKeys();
        for (int i = 0; i < names.size(); ++i) {
            if (!PerfMonitor.getEntry((String)((String)names.get(i))).isEnabled()) continue;
            o.print("<entry>");
            o.print(XMLUtils.encode((String)((String)names.get(i))));
            o.println("</entry>");
        }
        o.println("</Active>");
    }

    private void outputRecordingStatus(PrintStream o, String message) {
        o.print("<Recording>");
        o.print(message);
        o.print("</Recording>\r\n");
    }

    private void outputEndResp(PrintStream o) {
        o.print("</");
        o.print(this.getCMPrefixString());
        o.print(":");
        o.println("PerfConfigResponse>");
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

