/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.cognos.perfMonitor.PerfMonitor;
import java.io.OutputStream;
import java.io.PrintStream;

public class PerfReport
extends RequestHandler {
    public PerfReport(CMStore store) {
        super(store);
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (!AdvancedSettings.ENABLECMPERFREQ || !ctx.getCurrentUserIsAdministrator() && AdvancedSettings.CMPERFREQAUTH) {
            throw new CMException("cmUnknownRequest", new CMException.Parm("Name", "PerfReport"));
        }
        XMLElement x = this.xmlElement_;
        String sPerfFilter = "";
        sPerfFilter = x.getOptionalChildValueWithName("filter");
        if (sPerfFilter == null) {
            sPerfFilter = "";
        }
        boolean bResetPeriod = x.getOptionalChildBooleanValueWithName("resetPeriod", true);
        CMIndentedPrintStream o = new CMIndentedPrintStream(this.oStream);
        this.outputBeginResp(o);
        if (!PerfMonitor.isRecording()) {
            PerfMonitor.outputEntries((OutputStream)o, (String)sPerfFilter, (boolean)bResetPeriod);
        } else {
            this.outputMessage(o, "Performance Monitor is recording to the file system.");
        }
        this.outputEndResp(o);
        o.flush();
        return true;
    }

    private void outputBeginResp(PrintStream o) {
        o.print("<");
        o.print(this.getCMPrefixString());
        o.print(":");
        o.print("PerfReportResponse");
        o.print(" xmlns:");
        o.print("cm");
        o.print("=\"");
        o.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            o.print("\"");
            o.print(" xmlns:");
            o.print("cm1");
            o.print("=\"");
            o.print(this.getCMS_V1Namespace());
        }
        o.print("\">\r\n");
        this.outputTimestamp(o);
    }

    private void outputTimestamp(PrintStream o) {
        o.print("<Timestamp>");
        o.print(CMDateUtils.getTime().toString());
        o.print("</Timestamp>\r\n");
    }

    private void outputMessage(PrintStream o, String message) {
        o.print("<Message>");
        o.print(message);
        o.print("</Message>\r\n");
    }

    private void outputEndResp(PrintStream o) {
        o.print("</");
        o.print(this.getCMPrefixString());
        o.print(":");
        o.println("PerfReportResponse>");
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

