/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ListIterator;

public class activate
extends RequestHandler {
    protected String contentManagerURI_ = null;

    public activate(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
        CMExecutionContext currentContext = CMExecutionContext.get();
        currentContext.setIPFCategory("Audit.Admin.CM");
    }

    protected String getSearchPath(XMLElement requestElement) throws CMException {
        return requestElement.getChildNonNullValueWithName("contentManagerURI");
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        if (this.didGetParmUsingXMLEl_ == requestElement && this.contentManagerURI_ != null) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        this.contentManagerURI_ = this.getSearchPath(requestElement);
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        boolean rc = false;
        CMExecutionContext currContext = CMExecutionContext.get();
        if (!currContext.hasCapability("canUseAdministrationPortal")) {
            throw new CMException("cmNoAdminCapability");
        }
        XMLElement xmlEl = this.getRootElement();
        this.out.print("\t<");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("activateResponse");
        this.out.print(" xmlns:");
        this.out.print("cm");
        this.out.print("=\"");
        this.out.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            this.out.print("\"");
            this.out.print(" xmlns:");
            this.out.print("cm1");
            this.out.print("=\"");
            this.out.print(this.getCMS_V1Namespace());
        }
        this.out.print("\">\r\n");
        rc = this.doAction(xmlEl);
        this.out.print("\t</");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("activateResponse");
        this.out.print(">");
        return rc;
    }

    public boolean doAction(XMLElement requestElement) throws CMException {
        this.getParams(requestElement);
        if (this.contentManagerURI_ == null) {
            throw new CMException("cmNoSelection");
        }
        if (this.contentManagerURI_.startsWith("/") || this.contentManagerURI_.startsWith("storeID")) {
            this.normalizeCMURI();
        }
        CMServlet.syncThread_.switchOver(this.contentManagerURI_);
        return true;
    }

    private void normalizeCMURI() throws CMException {
        String localCMURI;
        URL cmURL;
        if (this.contentManagerURI_ == null) {
            return;
        }
        if (this.store_ == null) {
            this.store_ = CMExecutionContext.get().getStore();
        }
        URL dispURL = this.getDispatcherUrl();
        String dispHostname = dispURL.getHost();
        int dispPort = dispURL.getPort();
        if (dispHostname == null || dispPort == -1) {
            throw new CMException("cmInvalidContentManagerURI");
        }
        IConfiguration config = ConfigurationFactory.getConfig();
        ArrayList cmURLs = (ArrayList)config.getObject("contentManagers");
        String cmHostname = null;
        int cmPort = -1;
        String cmURLStr = null;
        if (cmURLs != null) {
            ListIterator iter = cmURLs.listIterator();
            while (iter.hasNext()) {
                try {
                    cmURLStr = (String)iter.next();
                    if (cmURLStr == null) continue;
                    cmURLStr = UrlUtils.convertURItoDispatcherPath(cmURLStr, true);
                    cmURL = new URL(cmURLStr);
                    cmHostname = cmURL.getHost();
                    cmPort = cmURL.getPort();
                }
                catch (MalformedURLException ex) {
                    throw new CMException(ex, "cmInvalidCMURLs");
                }
                if (!cmHostname.equalsIgnoreCase(dispHostname) || cmPort != dispPort) continue;
                this.contentManagerURI_ = cmURLStr;
                return;
            }
        }
        if ((localCMURI = config.getCognosProp("localCMURL")) == null) {
            throw new CMException("cmMissingLocalCMURL");
        }
        localCMURI = UrlUtils.convertURItoDispatcherPath(localCMURI, true);
        cmURL = null;
        try {
            cmURL = new URL(localCMURI);
        }
        catch (MalformedURLException ex) {
            throw new CMException(ex, "cmInvalidContentManagerURI");
        }
        URL requestedURL = null;
        try {
            requestedURL = new URL(cmURL.getProtocol(), dispHostname, dispPort, cmURL.getPath());
        }
        catch (MalformedURLException ex) {
            throw new CMException(ex, "cmInvalidContentManagerURI");
        }
        this.contentManagerURI_ = requestedURL.toString();
    }

    private URL getDispatcherUrl() throws CMStoreParseException, CMException {
        CMStoreXPath dispatcherObjectPath = new CMStoreXPath(this.contentManagerURI_ + "/..", 10);
        CMProperty[] properties = new CMProperty[]{CMProperty.DISPATCHERPATH};
        CMStoreQueryResults queryResults = null;
        queryResults = this.store_.executeQuery(dispatcherObjectPath, properties, null, 0, 512, null);
        try {
            if (queryResults == null || !queryResults.next()) {
                throw new CMException("cmInvalidContentManagerURI");
            }
            Object dispatcherPathValue = queryResults.getValue(0);
            if (dispatcherPathValue == null) {
                throw new CMException("cmInvalidContentManagerURI");
            }
            try {
                URL uRL = new URL(dispatcherPathValue.toString());
                return uRL;
            }
            catch (MalformedURLException ex) {
                throw new CMException(ex, "cmInvalidContentManagerURI");
            }
        }
        finally {
            CMQueryUtils.safeQueryResultsRelease(queryResults);
        }
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

