/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.connectors.SDSConnector.SDSConnector;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.multitenancy.ReadTenantFilter;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMBasePropertyValue;
import com.cognos.cm.properties.CMLocalizedString;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.properties.CMRetentionRuleArray;
import com.cognos.cm.properties.CMString;
import com.cognos.cm.request.AbstractQuery;
import com.cognos.cm.request.ModifyingQuery;
import com.cognos.cm.request.delete;
import com.cognos.cm.server.AddDef;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.AuditContext;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMWhileDeadlockExecutor;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMIntList;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.ReportOutputFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class add
extends ModifyingQuery {
    protected RequestInfo requestInfo_;
    protected int addCount_;
    private ArrayList<Integer> addedOutputs = null;
    public static final int ACTION_UPDATE = 1;
    public static final int ACTION_REPLACE = 2;
    public static final int ACTION_ADD = 3;
    private static final String REMOVE_INVALID_CROSS_REFS = "RemoveInvalidCrossReferencesInAddRequest";

    public add(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
        RequestInfo requestInfo = (RequestInfo)this.requestsInfo_.get(0);
        CMObjectClass theClass = null;
        CMStorePath objectContext = null;
        String name = null;
        if (requestInfo.addDefs_ != null && requestInfo.addDefs_.size() > 0) {
            AddDef addDef = (AddDef)requestInfo.addDefs_.get(0);
            objectContext = requestInfo.objectContext_;
            if (objectContext == null && addDef.searchPath != null) {
                objectContext = addDef.searchPath;
            }
            name = addDef.name;
            theClass = addDef.objectClass;
        }
        if (objectContext != null && objectContext.isUnion()) {
            throw new CMException("cmBadCompoundPathOp", new CMException.Parm("Path", objectContext.getOriginalPath()));
        }
        if (objectContext != null && theClass != null && name != null) {
            StringBuilder pathBuf = new StringBuilder(objectContext.getOriginalPath());
            pathBuf.append("/");
            pathBuf.append(theClass.getName());
            pathBuf.append("[@name=");
            pathBuf.append(CMStoreXPath.attributeQuoteString(name));
            pathBuf.append("]");
            CMExecutionContext.get().setIPFObjectPath(pathBuf.toString());
        }
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        if (this.didGetParmUsingXMLEl_ == requestElement && this.requestsInfo_.size() > 0) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        if (this.lockedPaths_ == null) {
            this.lockedPaths_ = new ArrayList();
        }
        this.requestInfo_ = new RequestInfo();
        this.requestInfo_.requestElement_ = requestElement;
        this.requestsInfo_.add(this.requestInfo_);
        this.requestInfo_.objectContext_ = null;
        this.requestInfo_.action_ = 3;
        this.parseSearchPath(requestElement, this.requestInfo_);
        this.parseOptions(requestElement, this.requestInfo_);
        this.parseResponseDelay(requestElement);
        this.parseObjects(requestElement, this.requestInfo_);
        this.updateLockUsage(this.requestInfo_);
    }

    private void parseSearchPath(XMLElement requestElement, RequestInfo requestInfo) throws CMException {
        String searchPath = this.getSearchPath(requestElement);
        if (searchPath != null && searchPath.length() > 0) {
            requestInfo.objectContextString_ = searchPath;
            requestInfo.objectContext_ = this.parsePath(requestInfo.objectContextString_);
            this.validatePathForNonQueryCommand(requestInfo.objectContext_, "add");
        }
    }

    private void updateLockUsage(RequestInfo requestInfo) {
        CMStoreXPath searchPath = requestInfo.objectContext_;
        if (searchPath != null) {
            int lockUsage = 11;
            if (this.isAddOfSingleObject(requestInfo)) {
                AddDef addDef = (AddDef)requestInfo.addDefs_.get(0);
                lockUsage = this.lockMgr_.optimizeLockUsage(lockUsage, addDef);
            }
            searchPath.setLockManagerUsageFlag(lockUsage);
            this.addObjectContextToLockPaths(searchPath);
        }
    }

    protected boolean isAddOfSingleObject(RequestInfo requestInfo) {
        return requestInfo.addDefs_ != null && requestInfo.addDefs_.size() == 1;
    }

    private void parseOptions(XMLElement requestElement, RequestInfo requestInfo) throws CMException {
        XMLElement optionsXmlElm = requestElement.getOptionalChildWithName("options");
        if (optionsXmlElm != null) {
            XMLElement returnPropsEle;
            String updateAction = optionsXmlElm.getOptionalChildValueWithName("updateAction");
            if (updateAction != null && updateAction.length() > 0) {
                if (updateAction.equalsIgnoreCase("replace")) {
                    requestInfo.action_ = 2;
                } else if (updateAction.equalsIgnoreCase("update")) {
                    requestInfo.action_ = 1;
                } else if (updateAction.equalsIgnoreCase("fail")) {
                    requestInfo.action_ = 3;
                } else {
                    throw new CMException("cmBadAttrValue", new CMException.Parm("Value", updateAction), new CMException.Parm("Attribute", "update"));
                }
            }
            if ((returnPropsEle = optionsXmlElm.getOptionalChildWithName("returnProperties")) != null && returnPropsEle.hasChildren()) {
                CMPropertySet propSet = this.getPropertySet();
                if (this.propertiesList_ == null) {
                    this.propertiesList_ = new ArrayList();
                }
                for (XMLElement item : returnPropsEle.getChildren()) {
                    this.addProperty(item.value_, this.propertiesList_, propSet);
                }
            }
            requestInfo.failInvalidReferences_ = !optionsXmlElm.getOptionalChildBooleanValueWithName("ignoreInvalidObjectReference", false);
            requestInfo.clearInvalidReferences_ = !optionsXmlElm.getOptionalChildBooleanValueWithName("faultIfObjectReferenced", false);
        }
    }

    private void parseResponseDelay(XMLElement requestElement) throws CMException {
        this.setResponseDelay(requestElement.getOptionalChildLongValueWithName("responseDelay", 0L));
    }

    private void parseObjects(XMLElement requestElement, RequestInfo requestInfo) throws CMException {
        XMLElement objectsEle = requestElement.getChildWithName("objects");
        ArrayList<XMLElement> aClassList = objectsEle.getChildren();
        requestInfo.addDefs_ = this.getObjectsIntoAddDefs(aClassList, 11);
        for (AddDef addDef : requestInfo.addDefs_) {
            this.validatePathForNonQueryCommand(addDef.searchPath, "add");
        }
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        boolean rc = this.runCommands("addResponse", "addReply");
        return rc;
    }

    protected String getAddResultString() {
        return "addResult";
    }

    protected String getSearchPath(XMLElement requestElement) {
        return requestElement.getOptionalChildValueWithName("search");
    }

    @Override
    protected void prepareLocks() throws CMException {
        this.lockMgr_.releaseLocks();
        if (CMExecutionContext.get().getAuthenticateCreateSession()) {
            this.store_.createSessionStorage();
        }
        for (int iR = 0; iR < this.requestsInfo_.size(); ++iR) {
            RequestInfo requestInfo = (RequestInfo)this.requestsInfo_.get(iR);
            for (AddDef addDef : requestInfo.addDefs_) {
                this.validateObjectProperties(addDef, requestInfo.failInvalidReferences_);
                CMStoreXPath addPath = null;
                if (addDef.objectClass != null && addDef.name != null) {
                    CMStoreXPath path = addDef.searchPath;
                    if (path == null) {
                        path = requestInfo.objectContext_;
                    }
                    if (path != null) {
                        StringBuilder pathBuf = new StringBuilder();
                        pathBuf.append(path.getOriginalPath());
                        pathBuf.append("/");
                        pathBuf.append(addDef.objectClass.getName());
                        pathBuf.append("[@name=");
                        pathBuf.append(CMStoreXPath.attributeQuoteString(addDef.name));
                        pathBuf.append("]");
                        addPath = (CMStoreXPath)CMStoreXPath.parse(pathBuf.toString());
                        if (requestInfo.action_ == 2) {
                            addPath.setLockManagerUsageFlag(12);
                            this.lockedPaths_.add(addPath);
                        }
                    }
                }
                this.prepareTriggerDefs(addDef, addPath, requestInfo.objectContext_);
            }
        }
    }

    @Override
    public boolean doCommand(Object requestInfoObj, String tabPrefix) throws CMException {
        boolean rc = false;
        RequestInfo requestInfo = (RequestInfo)requestInfoObj;
        this.objectContext_ = requestInfo.objectContext_;
        this.out.print(tabPrefix);
        this.emitArrayElement(this.getAddResultString(), "cm", "baseClass");
        this.executeAdd(requestInfo, tabPrefix);
        this.out.print(Integer.toString(this.addCount_));
        this.out.print("]\">\r\n");
        if (this.addBuffer_ != null) {
            this.out.print(this.addBuffer_.toString());
            this.addBuffer_ = null;
        }
        this.out.print(tabPrefix);
        this.out.print("</");
        this.out.print(this.getAddResultString());
        this.out.print(">\r\n");
        return rc;
    }

    private static final String getNamePredicate(Object objectName) {
        StringBuilder buffer = new StringBuilder(1024);
        if (objectName instanceof CMString) {
            buffer.append("@name=");
            buffer.append(CMStoreXPath.attributeQuoteString(objectName.toString()));
        } else {
            CMLocalizedStringArray name = (CMLocalizedStringArray)objectName;
            int nameCnt = name.getSize();
            for (int nameIdx = 0; nameIdx != nameCnt; ++nameIdx) {
                CMLocalizedString str = name.get(nameIdx);
                if (nameIdx > 0) {
                    buffer.append(" or ");
                }
                buffer.append("@name=");
                buffer.append(CMStoreXPath.attributeQuoteString(str.getValue()));
            }
        }
        return buffer.toString();
    }

    private final String gatherPaths(CMStoreQueryResults results) throws CMException {
        StringBuilder paths = new StringBuilder(1024);
        do {
            if (paths.length() > 0) {
                paths.append(", ");
            }
            paths.append(results.getPath());
        } while (results.next());
        return paths.toString();
    }

    private final CMException newDuplicateError(CMStoreQueryResults results, String originalInsertionPath, String errorCode, CMException.Parm parm1) throws CMException {
        String paths = null;
        try {
            paths = this.gatherPaths(results);
        }
        catch (CMStoreNotAvailable ex) {
            throw ex;
        }
        catch (CMException ex) {
            throw new CMException((Exception)ex, "cmAddDupObjectQueryFailed", new CMException.Parm("Path", CMQueryUtils.getPath(this.store_, originalInsertionPath)));
        }
        CMException exception = parm1 != null ? new CMException(errorCode, parm1, new CMException.Parm("Objects", paths)) : new CMException(errorCode, new CMException.Parm("Objects", paths));
        return exception;
    }

    private boolean isReplacingSingleton(RequestInfo requestInfo, int maxOccurs) {
        return maxOccurs == 1 && requestInfo.action_ != 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String probe(RequestInfo requestInfo, CMStorePath addPath, AddDef addDef, String generatedName, int maxOccurs) throws CMException {
        boolean isReplacingSingleton = this.isReplacingSingleton(requestInfo, maxOccurs);
        if (generatedName != null && !isReplacingSingleton) {
            return null;
        }
        String objectToReplaceUpdate = null;
        String predicateStr = null;
        String defaultName = null;
        CMBasePropertyValue name = null;
        if (generatedName != null) {
            defaultName = generatedName;
            name = new CMDbStoreString(defaultName);
        } else {
            name = addDef.localizedName;
            if (name == null) {
                name = new CMDbStoreString(addDef.name);
                defaultName = addDef.name;
            } else {
                defaultName = name.get(0).getValue();
            }
        }
        predicateStr = generatedName != null && isReplacingSingleton ? "*[@objectClass='" + addDef.objectClass.getName() + "']" : "*[" + add.getNamePredicate(name) + "]";
        CMStoreQueryResults probeResults = null;
        try {
            CMStoreXPath existanceQuery = new CMStoreXPath(addPath, predicateStr, false);
            probeResults = this.store_.executeQuery(existanceQuery, null, null, 0, 512, null);
            if (!probeResults.next()) {
                String string = null;
                return string;
            }
            if (requestInfo.action_ == 3 && generatedName == null) {
                throw this.newDuplicateError(probeResults, CMQueryUtils.getPath(this.store_, addPath), "cmDuplicateName", new CMException.Parm("Name", defaultName));
            }
            String searchPath = probeResults.getSearchPath();
            CMObjectClass objClass = probeResults.getObjectClass();
            if (objClass != addDef.objectClass || probeResults.next()) {
                throw this.newDuplicateError(probeResults, CMQueryUtils.getPath(this.store_, addPath), requestInfo.action_ == 1 ? "cmAddWithUpdateFailed" : "cmAddWithReplaceFailed", null);
            }
            if (requestInfo.action_ != 3) {
                objectToReplaceUpdate = searchPath;
            }
        }
        finally {
            if (probeResults != null) {
                probeResults.release();
            }
        }
        return objectToReplaceUpdate;
    }

    public boolean executeAdd(RequestInfo requestInfo, String tabPrefix) throws CMException {
        boolean fullyTrusted;
        boolean rc = false;
        if (requestInfo.addDefs_ == null || requestInfo.addDefs_.size() < 1) {
            return true;
        }
        int permWrite = 0;
        int permWriteForNotUpdate = 0;
        CMExecutionContext currContext = CMExecutionContext.get();
        boolean bl = fullyTrusted = currContext.executingStaticRequest() || currContext.getCurrentUserIsAdministrator();
        if (fullyTrusted) {
            permWrite = 512;
        } else {
            permWriteForNotUpdate = 2176;
            permWrite = 2176;
            for (int i = 0; i < requestInfo.addDefs_.size(); ++i) {
                AddDef addDef = (AddDef)requestInfo.addDefs_.get(i);
                if (addDef.objectClass == CMObjectClass.HISTORY) continue;
                permWrite = requestInfo.action_ == 1 ? 128 : 130;
                permWriteForNotUpdate = 130;
                break;
            }
        }
        DeadlockContext context = this.setupDeadlockContext(requestInfo, permWrite, permWriteForNotUpdate, tabPrefix);
        try {
            CMWhileDeadlockExecutor.execute(this, context, Class.forName("com.cognos.cm.request.add").getDeclaredMethod("executeInDeadlockLoop", DeadlockContext.class, Integer.class));
        }
        catch (CMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CMException(t, "cmUnexpectedError");
        }
        if (context.committed) {
            this.postSuccessfulOperation();
        }
        return rc;
    }

    protected DeadlockContext setupDeadlockContext(RequestInfo requestInfo, int permWrite, int permWriteForNotUpdate, String tabPrefix) {
        DeadlockContext context = new DeadlockContext();
        context.requestInfo = requestInfo;
        context.permWrite = permWrite;
        context.permWriteForNotUpdate = permWriteForNotUpdate;
        context.committed = false;
        context.tabPrefix1 = tabPrefix + "\t";
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOutputForCopy(int outputObjectId, AddDef addDef, CMStorePath objectContext) throws CMException {
        if (addDef.objectClass == CMObjectClass.OUTPUT && !addDef.isImport) {
            if (objectContext != null) {
                CMStoreQueryResults qresults = null;
                try {
                    qresults = this.store_.executeQuery(objectContext, new CMProperty[]{CMProperty.OBJECTCLASS}, null, 0, 512, null);
                    if (qresults != null && qresults.next() && qresults.getValue(0) == CMObjectClass.SESSION) {
                        return;
                    }
                }
                finally {
                    if (qresults != null) {
                        qresults.release();
                    }
                }
            }
            if (this.addedOutputs == null) {
                this.addedOutputs = new ArrayList();
            }
            this.addedOutputs.add(outputObjectId);
        }
    }

    private void copyOutputsToFileSystem() {
        if (this.addedOutputs != null && this.addedOutputs.size() > 0) {
            if (CMIndicationGlobals.bTempDebugLogEnabled) {
                CMIndications.CMTempDebugTrace("Copying Report Output to file system location \"" + AdvancedSettings.OUTPUTLOCATION + "\"");
            }
            for (Integer outputId : this.addedOutputs) {
                try {
                    ReportOutputFile output = new ReportOutputFile(outputId, AdvancedSettings.OUTPUTLOCATION, AdvancedSettings.OUTPUTSCRIPT);
                    output.write();
                }
                catch (CMException ex) {
                    CMIndications.logException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInDeadlockLoop(DeadlockContext context, Integer deadlockRetryNumber) throws CMException {
        IConfiguration config = ConfigurationFactory.getConfig();
        boolean isConfigReportEnabled = config.isReportOutputEnabled();
        CMExecutionContext execCtx = CMExecutionContext.get();
        AuditContext auditContext = execCtx.getAuditContext();
        boolean removeInvalidCrossRefs = context.requestInfo.action_ == 2 && CMServlet.parseBoolParam(config.getInternalProp(REMOVE_INVALID_CROSS_REFS), true);
        this.addCount_ = 0;
        this.addBuffer_ = new StringBuffer();
        this.addedOutputs = null;
        try {
            int numberOfInvalidReferences;
            ArrayList<RetentionInfo> retentionInfos = new ArrayList<RetentionInfo>(context.requestInfo.addDefs_.size());
            ParentObjectInfo searchExpressionParentInfo = null;
            CMIntList addedObjects = new CMIntList();
            HashMap<Integer, Integer> replacedObjects = new HashMap<Integer, Integer>();
            boolean addWithReplace = false;
            boolean hasIDBasedReferences = false;
            this.store_.beginTransaction();
            if (removeInvalidCrossRefs) {
                this.resolveIDBasedReferences(context.requestInfo);
            }
            for (AddDef addDef : context.requestInfo.addDefs_) {
                ++this.addCount_;
                if (!hasIDBasedReferences) {
                    hasIDBasedReferences = addDef.hasIDBasedReferences;
                }
                if (!removeInvalidCrossRefs) {
                    this.resolveIDBasedReferences(addDef, context.requestInfo.failInvalidReferences_, false, null);
                }
                CMStoreXPath addPath = this.getAddPath(addDef);
                String searchPath = null;
                boolean createName = addDef.name == null && addDef.localizedName == null;
                int addedObjectId = -1;
                if (addDef.objectClass == CMObjectClass.SCHEDULE) {
                    this.validateCredentialAccess(addDef);
                }
                if (addDef.objectClass == CMObjectClass.ARCHIVELOCATION) {
                    this.validateArchiveLocation(addDef);
                }
                boolean settingRunAsOwner = this.mustVerifyOwnerCredential(addDef, "~");
                CMStoreQueryResults parentQuery = null;
                CMStoreQueryResults existQuery = null;
                CMStoreQueryResults addResult = null;
                try {
                    boolean updatingExistingObject;
                    CMBasePropertyValue objectName;
                    ParentObjectInfo parentInfo;
                    if (addPath == this.objectContext_ && searchExpressionParentInfo != null) {
                        parentInfo = searchExpressionParentInfo;
                    } else {
                        if (AbstractQuery.grantSDSTraverse(addPath)) {
                            context.permWrite |= 0x4000;
                            context.permWriteForNotUpdate |= 0x4000;
                        }
                        if ((parentQuery = this.store_.executeQuery(addPath, null, null, 1, context.permWrite, null)) == null || !parentQuery.next()) {
                            this.throwNoParent(addPath);
                        }
                        if ((parentInfo = new ParentObjectInfo(parentQuery)).objectClass == CMObjectClass.ROOT && !execCtx.executingStaticRequest()) {
                            throw new CMException((Exception)new CMException("cmNoRootAdd"), "cmBadSelection", new CMException.Parm("Name", parentQuery.getPath()));
                        }
                        if (addPath == context.requestInfo.objectContext_ && context.requestInfo.addDefs_.size() > 1) {
                            searchExpressionParentInfo = parentInfo;
                        }
                    }
                    this.validateAdd(parentInfo.searchPath, addDef);
                    if (addDef.objectClass == CMObjectClass.SCHEDULE && !SDSConnector.currentRequestIsFromSDS()) {
                        addDef.remove(CMProperty.TASKID);
                    }
                    int maxOccurs = 0;
                    int childCount = 0;
                    this.assertIsValidChildClass(parentInfo.searchPath, parentInfo.objectClass, addDef.objectClass);
                    maxOccurs = parentInfo.objectClass.getMaxOccursFor(addDef.objectClass);
                    if (maxOccurs != CMObjectClass.MAX_OCCURS_UNLIMITED) {
                        String tenantId = this.getTargetTenantIdAsString(addDef);
                        childCount = this.validateMaxOccurs(parentInfo.searchPath, parentInfo.objectClass, addDef.objectClass, tenantId, context.requestInfo.action_ == 3);
                    }
                    String generatedName = null;
                    if (createName) {
                        generatedName = this.store_.generateUniqueName(parentInfo.objectId);
                    }
                    String pathToReplaceUpdate = this.probe(context.requestInfo, addPath, addDef, generatedName, maxOccurs);
                    if (addDef.objectClass == CMObjectClass.SCHEDULE) {
                        boolean exists;
                        boolean bl = exists = pathToReplaceUpdate != null;
                        if (context.requestInfo.action_ == 2) {
                            exists = false;
                        }
                        this.validateScheduleObject(addDef, exists);
                    }
                    boolean checkNameUniqueness = true;
                    if (addDef.localizedName != null) {
                        objectName = addDef.localizedName;
                    } else if (addDef.name != null) {
                        objectName = new CMDbStoreString(addDef.name);
                    } else {
                        objectName = new CMDbStoreString(generatedName);
                        checkNameUniqueness = false;
                    }
                    boolean bl = updatingExistingObject = pathToReplaceUpdate != null && context.requestInfo.action_ == 1;
                    if (addDef.objectClass.hasProperty(CMProperty.RETENTIONS) && (!updatingExistingObject || addDef.contains(CMProperty.RETENTIONS))) {
                        this.setDefaultRetentionRules(addDef);
                    }
                    if (pathToReplaceUpdate == null && context.requestInfo.action_ == 1) {
                        if (parentQuery != null) {
                            parentQuery.release();
                            parentQuery = null;
                        }
                        if (!(parentQuery = this.store_.executeQuery(addPath, null, null, 1, context.permWriteForNotUpdate, null)).next()) {
                            this.throwNoParent(addPath);
                        }
                    }
                    if (!updatingExistingObject) {
                        this.applyTenantIDVirtualInheritanceRule(addDef, parentInfo.tenantId);
                        this.validateTenantIdContainment(addDef, parentInfo.tenantId, parentInfo.searchPath);
                    }
                    if (addDef.objectClass.isRetainable()) {
                        int tenantIdForRetention = this.getTenantIDForRetentions(addDef);
                        retentionInfos.add(new RetentionInfo(null, tenantIdForRetention, parentInfo.searchPath, addDef.objectClass));
                    }
                    if (pathToReplaceUpdate == null) {
                        if (childCount >= maxOccurs && !execCtx.executingStaticRequest()) {
                            throw new CMException("cmOverMaxChild", new CMException.Parm("Path", CMQueryUtils.getPath(this.store_, parentInfo.searchPath)), new CMException.Parm("ChildClass", addDef.objectClass.getLocalizedName()), new CMException.Parm("ParentClass", parentInfo.objectClass.getLocalizedName()));
                        }
                        addResult = this.store_.addObject(parentInfo.objectId, objectName, addDef.objectClass, addDef.names(), addDef.values(), checkNameUniqueness);
                        CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                        addResult.next();
                        searchPath = addResult.getSearchPath();
                        addedObjectId = addResult.getObjectID();
                        addResult.release();
                        addResult = null;
                        if (addDef.triggerDefs != null) {
                            this.executeTriggerDefs(addDef.triggerDefs);
                        }
                        if (addDef.objectClass == CMObjectClass.CONTENTMANAGERSERVICE) {
                            this.notifyContentManagerAdded(addPath, addedObjectId);
                        }
                    } else {
                        CMStorePath updateOrReplaceQuery = null;
                        if (addDef.version != null) {
                            StringBuilder pathBuf = new StringBuilder(pathToReplaceUpdate);
                            pathBuf.append("[@version=").append(addDef.version).append("]");
                            updateOrReplaceQuery = CMStoreXPath.parse(pathBuf.toString());
                        } else {
                            updateOrReplaceQuery = new CMStoreXPath(pathToReplaceUpdate);
                        }
                        int permissions = 2;
                        if (context.requestInfo.action_ == 2) {
                            permissions |= 8;
                        } else if (addDef.contains(CMProperty.POLICIES)) {
                            permissions |= 4;
                        }
                        CMProperty[] updateprops = null;
                        int iIDProp = -1;
                        int iOwnerProp = -1;
                        int numUpdateProps = 0;
                        boolean membersPropertyIsEmpty = false;
                        if (addDef.objectClass == CMObjectClass.ROLE && addDef.contains(CMProperty.MEMBERS) && addDef.get(CMProperty.MEMBERS) == null) {
                            membersPropertyIsEmpty = true;
                        }
                        if (membersPropertyIsEmpty && context.requestInfo.action_ == 1) {
                            iIDProp = numUpdateProps++;
                        }
                        if (settingRunAsOwner && context.requestInfo.action_ == 1) {
                            iOwnerProp = numUpdateProps++;
                        }
                        if (numUpdateProps > 0) {
                            updateprops = new CMProperty[numUpdateProps];
                            if (iIDProp > -1) {
                                updateprops[iIDProp] = CMProperty.ID;
                            }
                            if (iOwnerProp > -1) {
                                updateprops[iOwnerProp] = CMProperty.OWNER;
                            }
                        }
                        existQuery = this.store_.executeQuery(updateOrReplaceQuery, updateprops, null, 0, permissions, null);
                        CMObjectClass objectClass = null;
                        if (!existQuery.next()) {
                            updateOrReplaceQuery = new CMStoreXPath(pathToReplaceUpdate);
                            this.assertObjectVersionMatches(updateOrReplaceQuery, permissions, addDef.version);
                            throw new CMException("cmAddDupObjectQueryFailed", new CMException.Parm("Path", CMQueryUtils.getPath(this.store_, addPath)));
                        }
                        if (generatedName != null) {
                            objectName = new CMDbStoreString(existQuery.getName());
                        }
                        searchPath = existQuery.getSearchPath();
                        objectClass = existQuery.getObjectClass();
                        addedObjectId = existQuery.getObjectID();
                        context.requestInfo.objectContextString_ = searchPath;
                        if (objectClass != addDef.objectClass) {
                            String error = context.requestInfo.action_ == 1 ? "cmAddWithUpdateFailedBadClass" : "cmAddWithReplaceFailedBadClass";
                            throw new CMException(error, new CMException.Parm("ClassTarget", objectClass.getName()), new CMException.Parm("ClassNew", addDef.objectClass.getName()), new CMException.Parm("Path", searchPath));
                        }
                        if (context.requestInfo.action_ == 1) {
                            Object objID;
                            if (objectClass == CMObjectClass.ACCOUNT && searchPath.equals(execCtx.getCurrentUserSearchPath())) {
                                this.updateSession(addDef);
                            }
                            if (settingRunAsOwner) {
                                CMBaseClassArray ownerValue = (CMBaseClassArray)existQuery.getValue(iOwnerProp);
                                this.assertCredentialAccess(ownerValue);
                            }
                            if (membersPropertyIsEmpty && (objID = existQuery.getValue(iIDProp)) != null && objID.toString().equalsIgnoreCase("::System Administrators")) {
                                throw new CMException("cmEmptySysAdmin");
                            }
                            this.validateTenancyForAddWithUpdate(addDef, existQuery);
                        }
                        this.assertSingleObjectSelected(existQuery, context);
                        existQuery.reset();
                        if (context.requestInfo.action_ == 1) {
                            if (addDef.localizedName != null) {
                                addDef.put(CMProperty.NAME, addDef.localizedName);
                            } else if (addDef.name != null) {
                                addDef.put(CMProperty.DEFAULTNAME, addDef.name);
                            }
                            if (parentInfo.objectClass == CMObjectClass.MRUFOLDER) {
                                addDef.remove(CMProperty.NAME);
                                addDef.remove(CMProperty.DEFAULTNAME);
                            }
                            this.store_.update(existQuery, addDef.names(), addDef.values());
                            CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                        } else {
                            addWithReplace = true;
                            Integer originalObjectId = addedObjectId;
                            delete.deleteDescendants(this.store_, searchPath, permissions, context.requestInfo.clearInvalidReferences_);
                            Integer replacedObjectID = (Integer)replacedObjects.get(parentInfo.objectId);
                            if (replacedObjectID != null) {
                                parentInfo.objectId = replacedObjectID;
                            }
                            addResult = this.store_.addObject(parentInfo.objectId, objectName, addDef.objectClass, addDef.names(), addDef.values());
                            CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                            addResult.next();
                            searchPath = addResult.getSearchPath();
                            addedObjectId = addResult.getObjectID();
                            replacedObjects.put(originalObjectId, addedObjectId);
                            addResult.release();
                            addResult = null;
                            if (addDef.objectClass == CMObjectClass.CONTENTMANAGERSERVICE) {
                                this.notifyContentManagerAdded(addPath, addedObjectId);
                            }
                        }
                        if (addDef.triggerDefs != null) {
                            this.executeTriggerDefs(addDef.triggerDefs);
                        }
                    }
                    if (AdvancedSettings.OUTPUTLOCATION != null && addDef.objectClass == CMObjectClass.OUTPUT) {
                        if (isConfigReportEnabled) {
                            this.addOutputForCopy(addedObjectId, addDef, this.objectContext_);
                        } else if (pathToReplaceUpdate == null) {
                            CMIndications.Audit_Message_FreeFormText("cmReportOutputDisabled", null, 30000, "Request", "ContentManagerService", "", "Warning", null);
                        }
                    }
                    this.configurationModified(searchPath, addDef.objectClass);
                    auditContext.add(addedObjectId, addDef.objectClass);
                    addedObjects.add(addedObjectId);
                    CMQueryUtils.safeQueryResultsRelease(parentQuery);
                }
                catch (CMStoreObjectNotFound ex) {
                    this.throwNoParent(addPath);
                    continue;
                }
                finally {
                    CMQueryUtils.safeQueryResultsRelease(parentQuery);
                    CMQueryUtils.safeQueryResultsRelease(existQuery);
                    CMQueryUtils.safeQueryResultsRelease(addResult);
                    continue;
                }
                CMQueryUtils.safeQueryResultsRelease(existQuery);
                CMQueryUtils.safeQueryResultsRelease(addResult);
            }
            if (addWithReplace && hasIDBasedReferences && !removeInvalidCrossRefs && (numberOfInvalidReferences = this.removeReferencesToDeletedObjects()) > 0 && context.requestInfo.failInvalidReferences_) {
                throw new CMException("cmInvalidReference2");
            }
            this.store_.commitTransaction();
            context.committed = true;
            if (addWithReplace && addedObjects.size() > 0) {
                CMIntList verifiedAddedObjects = new CMIntList();
                for (int i = 0; i < addedObjects.size(); ++i) {
                    if (this.store_.isObjectIDValid(addedObjects.get(i))) {
                        verifiedAddedObjects.add(addedObjects.get(i));
                        continue;
                    }
                    --this.addCount_;
                }
                addedObjects = verifiedAddedObjects;
            }
            this.writeObjects(context.tabPrefix1, addedObjects);
            this.executeRetentionRules(context, retentionInfos);
            if (isConfigReportEnabled && AdvancedSettings.OUTPUTLOCATION != null) {
                this.copyOutputsToFileSystem();
            }
        }
        finally {
            try {
                this.store_.rollbackOpenTransaction();
            }
            catch (Exception exception) {}
        }
    }

    private void assertSingleObjectSelected(CMStoreQueryResults existQuery, DeadlockContext context) throws CMException {
        String searchPath = existQuery.getPath();
        if (existQuery.next()) {
            StringBuilder objectPaths = new StringBuilder(searchPath);
            do {
                objectPaths.append(", ");
                objectPaths.append(existQuery.getSearchPath());
            } while (existQuery.next());
            String error = context.requestInfo.action_ == 1 ? "cmAddWithUpdateFailed" : "cmAddWithReplaceFailed";
            throw new CMException(error, new CMException.Parm("Objects", objectPaths.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyContentManagerAdded(CMStoreXPath addPath, int objectId) throws CMException {
        CMProperty[] dispatcherProps = new CMProperty[]{CMProperty.DISPATCHERPATH, CMProperty.CAPACITY};
        CMStoreQueryResults results = null;
        try {
            results = this.store_.executeQuery(addPath, dispatcherProps, null, 1, 512, null);
            if (results.next()) {
                Object dispatcherPath = results.getValue(0);
                Object dispatcherCapacity = results.getValue(1);
                this.store_.addedContentManagerService(objectId, dispatcherPath, dispatcherCapacity);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
        }
    }

    private void throwNoParent(CMStoreXPath addPath) throws CMException {
        throw new CMException((Exception)new CMException("cmFailNoParent"), "cmBadSelection", new CMException.Parm("Name", CMQueryUtils.getPath(this.store_, addPath)));
    }

    private int getTenantIDForRetentions(AddDef addDef) throws CMException {
        if (addDef.contains(CMProperty.TENANTID)) {
            String tenantIDStr = (String)addDef.get(CMProperty.TENANTID);
            return this.tenantRegistry.getTenantIdIntFromString(tenantIDStr, false);
        }
        return CMExecutionContext.get().getCurrentUserTenantId();
    }

    private void applyTenantIDVirtualInheritanceRule(AddDef addDef, int parentTenantId) throws CMException {
        boolean applyVirtualInheritance;
        boolean bl = applyVirtualInheritance = addDef.objectClass == CMObjectClass.MODEL || addDef.objectClass == CMObjectClass.MODELVIEW;
        if (!applyVirtualInheritance) {
            boolean bl2 = applyVirtualInheritance = !addDef.contains(CMProperty.TENANTID) && !MultiTenancyUtils.isValidContainment(parentTenantId, CMExecutionContext.get().getCurrentUserTenantId());
        }
        if (applyVirtualInheritance) {
            String parentTenantIdStr = this.tenantRegistry.getTenantIdStringFromInt(parentTenantId);
            addDef.remove(CMProperty.TENANTID);
            addDef.addUnique(CMProperty.TENANTID, parentTenantIdStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRetentionRules(DeadlockContext context, List<RetentionInfo> retentionInfos) {
        ReadTenantFilter originalTenantFilter = null;
        try {
            CMExecutionContext ctx = CMExecutionContext.get();
            originalTenantFilter = ctx.getReadTenantFilter();
            for (int index = 0; index < retentionInfos.size(); ++index) {
                RetentionInfo info = retentionInfos.get(index);
                Object retention = info.retention;
                if (info.parentSearchPath == null) continue;
                if (retention == null) {
                    CMProperty[] props = new CMProperty[]{CMProperty.RETENTIONS};
                    CMStoreQueryResults parentQuery = null;
                    int tenantId = info.tenantId;
                    if (tenantId != 0) {
                        ctx.setReadTenantFilter(new ReadTenantFilter.FixedListTenantFilter(tenantId, 0));
                    } else {
                        ctx.setReadTenantFilter(new ReadTenantFilter.FixedListTenantFilter(tenantId));
                    }
                    try {
                        CMStoreXPath path = new CMStoreXPath(info.parentSearchPath);
                        parentQuery = this.store_.executeQuery(path, props, null, 0, context.permWrite, null);
                    }
                    catch (CMStoreObjectNotFound ex) {
                        if (parentQuery == null) continue;
                        parentQuery.release();
                        continue;
                    }
                    try {
                        if (parentQuery == null || !parentQuery.next() || (retention = parentQuery.getValue(0)) == null) continue;
                        for (int j = index; j < retentionInfos.size(); ++j) {
                            RetentionInfo otherInfo = retentionInfos.get(j);
                            if (!otherInfo.parentSearchPath.equals(info.parentSearchPath)) continue;
                            otherInfo.retention = info.retention;
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (parentQuery != null) {
                            parentQuery.release();
                        }
                    }
                }
                this.store_.beginTransaction();
                try {
                    CMRetentionRuleArray rules = (CMRetentionRuleArray)retention;
                    CMRetentionRule rule = rules.getRule(info.objectClass);
                    if (rule != null) {
                        this.executeRetentionRule(this.store_, rule, info.parentSearchPath, -1, info.tenantId);
                    }
                }
                catch (CMException ex) {
                    throw new CMException(ex, "cmRetentionFailed");
                }
                this.store_.commitTransaction();
            }
        }
        catch (CMException retEx) {
            if (AdvancedSettings.LOGRETENTIONRULEERRORS) {
                CMIndications.logException(retEx);
            }
        }
        finally {
            try {
                this.store_.rollbackOpenTransaction();
            }
            catch (Exception exception) {}
            CMExecutionContext.get().setReadTenantFilter(originalTenantFilter);
        }
    }

    private void validateTenancyForAddWithUpdate(AddDef addDef, CMStoreQueryResults existQuery) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (addDef.contains(CMProperty.TENANTID) && ctx.isAbleToEditTenantId()) {
            int currentTenantId = existQuery.getTenantID();
            int tenantIdFromRequest = this.tenantRegistry.getTenantIdIntFromString((String)addDef.get(CMProperty.TENANTID), false);
            if (tenantIdFromRequest != currentTenantId) {
                CMException toBeWrapped = new CMException("cmOperationWithUpdateInvalidTenant", new CMException.Parm("operation", "add"));
                throw new CMException(toBeWrapped, "cmDuplicateObject");
            }
        }
    }

    private void validateTenantIdContainment(AddDef addDef, int parentTenantId, String parentSearchPath) throws CMException {
        boolean addDefContainsTenantIdProperty = addDef.contains(CMProperty.TENANTID);
        if (!addDefContainsTenantIdProperty && !CMExecutionContext.get().hasUnfilteredAdminAccess()) {
            return;
        }
        int tenantId = this.getTargetTenantId(addDef);
        this.validateTenantIdContainmentForTenantId(tenantId, parentTenantId, parentSearchPath);
    }

    private int getTargetTenantId(AddDef addDef) throws CMException {
        int tenantId = CMExecutionContext.get().getCurrentUserTenantId();
        if (addDef.contains(CMProperty.TENANTID)) {
            String tenantIdString = (String)addDef.get(CMProperty.TENANTID);
            tenantId = this.tenantRegistry.getTenantIdIntFromString(tenantIdString, false);
        }
        return tenantId;
    }

    private String getTargetTenantIdAsString(AddDef addDef) throws CMException {
        return this.tenantRegistry.getTenantIdStringFromInt(this.getTargetTenantId(addDef));
    }

    private void validateTenantIdContainmentForTenantId(int tenantId, int parentTenantId, String parentSearchPath) throws CMException {
        if (!MultiTenancyUtils.isValidContainment(parentTenantId, tenantId)) {
            String tenantIdString = this.tenantRegistry.getTenantIdStringFromInt(tenantId);
            String parentTenantString = this.tenantRegistry.getTenantIdStringFromInt(parentTenantId);
            throw new CMException("cmInvalidTenantContainment", new CMException.Parm("tenant", tenantIdString), new CMException.Parm("path", CMQueryUtils.getPath(this.store_, parentSearchPath)), new CMException.Parm("parentTenant", parentTenantString));
        }
    }

    @Override
    protected void validateAdd(String parentPath, AddDef addDef) throws CMException {
        super.validateAdd(parentPath, addDef);
        this.validateName(addDef);
        if (addDef.objectClass == CMObjectClass.TENANT && this.getTargetTenantId(addDef) == 0) {
            throw new CMException("cmCantCreatePublicTenantObject");
        }
    }

    private void resolveIDBasedReferences(RequestInfo requestInfo) throws CMException {
        HashSet<Integer> objectsToBeReplaced = null;
        if (requestInfo.action_ == 2) {
            objectsToBeReplaced = this.getObjectsThatWillBeReplaced(requestInfo);
        }
        for (int j = 0; j < requestInfo.addDefs_.size(); ++j) {
            AddDef addDef = (AddDef)requestInfo.addDefs_.get(j);
            this.resolveIDBasedReferences(addDef, requestInfo.failInvalidReferences_, false, objectsToBeReplaced);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<Integer> getObjectsThatWillBeReplaced(RequestInfo requestInfo) throws CMException {
        HashSet<Integer> objectIDs = new HashSet<Integer>();
        for (int i = 0; i < requestInfo.addDefs_.size(); ++i) {
            AddDef addDef = (AddDef)requestInfo.addDefs_.get(i);
            if (addDef.name == null && addDef.localizedName == null) continue;
            CMStoreXPath addPath = new CMStoreXPath(this.getAddPath(addDef).getOriginalPath());
            addPath = new CMStoreXPath(addPath, this.getNamePredicatePath(addDef), false);
            CMStoreQueryResults results = this.store_.executeQuery(addPath, null, null, 0, 512, null);
            try {
                if (!results.next()) continue;
                objectIDs.add(results.getObjectID());
                continue;
            }
            finally {
                CMQueryUtils.safeQueryResultsRelease(results);
            }
        }
        return objectIDs;
    }

    protected CMStoreXPath getAddPath(AddDef addDef) throws CMException {
        CMStoreXPath path = null;
        path = addDef.searchPath != null ? addDef.searchPath : this.objectContext_;
        if (path == null) {
            throw new CMException("cmNoSelection");
        }
        return path;
    }

    protected String getNamePredicatePath(AddDef addDef) {
        CMBasePropertyValue name = addDef.localizedName;
        if (name == null) {
            name = new CMDbStoreString(addDef.name);
        }
        return "*[" + add.getNamePredicate(name) + "]";
    }

    private int removeReferencesToDeletedObjects() throws CMException {
        return this.store_.removeReferencesToNonexistentObjects();
    }

    private static class ParentObjectInfo {
        private int objectId;
        private CMObjectClass objectClass;
        private String searchPath;
        private int tenantId;

        private ParentObjectInfo(CMStoreQueryResults query2) {
            this.objectId = query2.getObjectID();
            this.objectClass = query2.getObjectClass();
            this.searchPath = query2.getSearchPath();
            this.tenantId = query2.getTenantID();
        }
    }

    private static class RetentionInfo {
        private Object retention;
        private int tenantId;
        private String parentSearchPath;
        private CMObjectClass objectClass;

        private RetentionInfo(Object retention, int tenantId, String parentSearchPath, CMObjectClass objectClass) {
            this.retention = retention;
            this.tenantId = tenantId;
            this.parentSearchPath = parentSearchPath;
            this.objectClass = objectClass;
        }
    }

    public static class DeadlockContext {
        public RequestInfo requestInfo;
        public int permWrite = 0;
        public int permWriteForNotUpdate = 0;
        public boolean committed = false;
        public String tabPrefix1;
    }

    public static class RequestInfo
    extends ModifyingQuery.RequestInfo {
        public String objectContextString_;
        public CMStoreXPath objectContext_;
        public int action_ = 3;
        public boolean clearInvalidReferences_ = true;
    }
}

