/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.contentManagerService.v1;

import com.cognos.CAM.AAAException;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMBasePropertyValue;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.add;
import com.cognos.cm.request.contentManagerService.v1.add;
import com.cognos.cm.request.helper.CMQueryResultFunction;
import com.cognos.cm.request.helper.CMQueryResultUtils;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AddDef;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class addAnnotations
extends add {
    private String parentPath_ = null;
    private String containerPath_ = null;
    private boolean containerAllowAdd_ = false;
    private CMQueryResultUtils queryhelper_ = new CMQueryResultUtils();
    private final int addPermissionRequired = 128;
    private static String[] everyonePolicyForAnnotation = new String[]{"read", "traverse"};
    private static String[] ownerPolicyForAnnotation = new String[]{"setPolicy"};
    private static Object[][] PolicyAnnotationFolder = new Object[][]{{"CAMID(\"::Everyone\")", Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}};

    public addAnnotations(CMStore store) {
        super(store);
    }

    @Override
    protected String getSearchPath(XMLElement requestElement) {
        String searchPath = requestElement.getOptionalChildValueWithName("containerPath");
        if (searchPath != null) {
            this.containerPath_ = searchPath;
        }
        return searchPath;
    }

    @Override
    protected add.DeadlockContext setupDeadlockContext(add.RequestInfo requestInfo, int permWrite, int permWriteForNotUpdate, String tabPrefix) {
        add.DeadlockContext context = new add.DeadlockContext();
        context.requestInfo = requestInfo;
        context.permWrite = 128;
        context.permWriteForNotUpdate = 128;
        context.committed = false;
        context.tabPrefix1 = tabPrefix + "\t";
        return context;
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        this.massageAddDefs(this.requestInfo_, 11);
        boolean rc = this.runCommands("addAnnotationsResponse", "addAnnotationsReply");
        return rc;
    }

    protected void massageAddDefs(add.RequestInfo requestInfo, int lockType) throws CMException {
        if (this.containerPath_ != null) {
            CMStorePath grandparentPath = CMStoreXPath.parse(this.containerPath_);
            this.containerAllowAdd_ = this.allowAddAnnotations(grandparentPath);
            if (this.containerAllowAdd_) {
                this.parentPath_ = this.getParentSearchPath(grandparentPath);
                this.adjustLockPaths(requestInfo, this.parentPath_);
            } else {
                throw new CMException("cmAddAnnotationNotAllowed", new CMException.Parm("Path", this.containerPath_));
            }
        }
        ArrayList addDefs = requestInfo.addDefs_;
        for (int i = 0; i < addDefs.size(); ++i) {
            AddDef addDef = (AddDef)addDefs.get(i);
            CMStoreXPath searchPath = addDef.searchPath;
            if (searchPath != null) {
                if (this.allowAddAnnotations(searchPath)) {
                    addDef.searchPath.clearLocksHaveBeenObtained();
                    String parent = this.getParentSearchPath(searchPath);
                    addDef.searchPath = (CMStoreXPath)CMStoreXPath.parse(parent);
                    addDef.searchPath.setLockManagerUsageFlag(lockType);
                    this.addObjectContextToLockPaths(addDef.searchPath);
                } else {
                    throw new CMException("cmAddAnnotationNotAllowed", new CMException.Parm("Path", searchPath.toString()));
                }
            }
            if (addDef.contains(CMProperty.POLICIES)) continue;
            this.addDefaultPoliciesToAddDef(addDef);
        }
    }

    private void addDefaultPoliciesToAddDef(AddDef addDef) throws CMException {
        XMLElement policiesElem = CMXMLUtils.convertXMLString2XMLElement("");
        this.addDefaultPolicies(policiesElem);
        XMLElement xmlPoliciesValues = policiesElem.getChildWithName("value");
        this.addOnePropertyIntoAddDef(addDef, CMProperty.POLICIES.getName(), xmlPoliciesValues, CMObjectClass.ANNOTATION, null, false);
    }

    private String getParentSearchPath(ICMStorePath grandparentPath) throws CMException {
        String parentPath = null;
        parentPath = this.verifyAndCreateAnnotationFolder(grandparentPath.toString());
        if (parentPath == null || parentPath.length() < 1) {
            throw new CMException("cmNoWrite", new CMException.Parm("object", grandparentPath));
        }
        return parentPath;
    }

    private boolean allowAddAnnotations(CMStorePath path) throws CMException {
        boolean bAllowAdd = false;
        CMAddAnnotationQueryFunc queryFunc = new CMAddAnnotationQueryFunc();
        this.queryhelper_.getProps(path, null, queryFunc);
        if (queryFunc.isValidGrandParent()) {
            CMObjectClass objClass = queryFunc.getObjectClass();
            queryFunc.reset();
            CMProperty prop = objClass.getProperty("allowAnnotations");
            this.queryhelper_.getProps(path, new CMProperty[]{prop}, queryFunc);
            bAllowAdd = queryFunc.isAllowAnnotation();
        }
        return bAllowAdd;
    }

    private void adjustLockPaths(add.RequestInfo requestInfo, String parentPath) throws CMStoreParseException {
        requestInfo.objectContextString_ = parentPath;
        requestInfo.objectContext_ = this.parsePath(requestInfo.objectContextString_);
        requestInfo.objectContext_.setLockManagerUsageFlag(11);
        this.addObjectContextToLockPaths(requestInfo.objectContext_);
    }

    private void addDefaultPolicies(XMLElement policiesElem) throws CMException {
        CMObjectReference ref;
        XMLElement valueElem = policiesElem.addChild(null, "value", CMSOAPConstants.NS_SOAP_ENC, "Array");
        this.addPolicyToXMLElement(valueElem, "group", "CAMID(\"::Everyone\")", everyonePolicyForAnnotation);
        Object owner = this.getOwner(CMStoreXPath.parse(this.parentPath_));
        if (owner != null && (ref = ((CMDbStoreBaseClassArray)owner).getReference(0)) != null) {
            String ownerSearchPath = ref.getSearchPath();
            String objectType = ref.getObjectClass().getName();
            this.addPolicyToXMLElement(valueElem, objectType, ownerSearchPath, ownerPolicyForAnnotation);
        }
    }

    private void addPolicyToXMLElement(XMLElement valueElem, String objClass, String searchPath, String[] policy) {
        XMLElement itemElem = valueElem.addChild(null, "item", null, null, null);
        XMLElement secObjElem = itemElem.addChild(null, "securityObject", CMSOAPConstants.NS_BIBUS, objClass);
        XMLElement searchPathElem = secObjElem.addChild(null, "searchPath", null, null, null);
        searchPathElem.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, "string", searchPath);
        XMLElement permsElem = itemElem.addChild(null, "permissions", CMSOAPConstants.NS_SOAP_ENC, "Array");
        for (int i = 0; i < policy.length; ++i) {
            XMLElement permItemElem = permsElem.addChild(null, "item", null, null, null);
            permItemElem.addChild(null, "name", null, null, policy[i]);
            permItemElem.addChild(null, "access", null, null, "grant");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String verifyAndCreateAnnotationFolder(String parent) throws CMException {
        String searchPath = null;
        CMStoreQueryResults results = null;
        CMStorePath context = null;
        CMStorePath parentPath = CMStoreXPath.parse(parent);
        int parentObjID = this.queryhelper_.getObjectIDWithPermissionRequired(parentPath, 128);
        if (parentObjID == -1) {
            throw new CMException("cmNoWrite", new CMException.Parm("object", parent));
        }
        String objectPath = parent + "/annotationFolder";
        context = CMStoreXPath.parse(objectPath);
        if (this.store_ == null) {
            this.store_ = CMExecutionContext.get().getStore();
            this.lockMgr_ = this.store_.getLockManager();
        }
        parentPath.setLockManagerUsageFlag(11);
        this.lockMgr_.requestLocks(parentPath);
        try {
            results = this.store_.executeQuery(context, null, null, 0, 512, null);
            searchPath = results != null && results.next() ? results.getSearchPath() : this.createAnnotationFolder(parentPath, parentObjID);
        }
        finally {
            if (results != null) {
                results.release();
            }
            parentPath.clearLocksHaveBeenObtained();
            this.lockMgr_.releaseLocks();
        }
        return searchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createAnnotationFolder(CMStorePath parentPath, int parentObjectID) throws CMException {
        String searchPath = null;
        CMStore store = CMExecutionContext.get().getStore();
        ArrayList<CMProperty> properties = new ArrayList<CMProperty>();
        ArrayList<Object> propValues = new ArrayList<Object>();
        properties.add(CMProperty.OWNER);
        propValues.add(this.getOwner(parentPath));
        properties.add(CMProperty.TENANTID);
        propValues.add(this.getTenantID(parentPath));
        properties.add(CMProperty.POLICIES);
        propValues.add(this.getDefaultAnnotationFolderPolicies());
        String now = CMDateUtils.getIsoDate();
        CMStoreQueryResults addResults = null;
        try {
            store.beginTransaction();
            addResults = store.addObject(parentObjectID, (CMBasePropertyValue)new CMDbStoreString(now), CMObjectClass.ANNOTATIONFOLDER, properties, propValues);
            addResults.next();
            searchPath = addResults.getSearchPath();
            store.commitTransaction();
        }
        finally {
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
            if (addResults != null) {
                addResults.release();
            }
        }
        return searchPath;
    }

    private byte[] getDefaultAnnotationFolderPolicies() {
        byte[] defaultPolicies = null;
        try {
            defaultPolicies = AccMan.createAPolicy(PolicyAnnotationFolder);
        }
        catch (AAAException ex) {
            CMIndications.logException(new CMException((Exception)((Object)ex), "cmErrorInitialObjectPolicy", new CMException.Parm("objClass", "annotationFolder"), new CMException.Parm("objName", "annotationFolder")));
        }
        return defaultPolicies;
    }

    private Object getOwner(CMStorePath path) throws CMException {
        CMAddAnnotationQueryFunc queryFunc = new CMAddAnnotationQueryFunc();
        this.queryhelper_.getProps(path, new CMProperty[]{CMProperty.OWNER}, queryFunc);
        Object ownerValue = queryFunc.getProperty(CMProperty.OWNER);
        return ownerValue;
    }

    private Object getTenantID(CMStorePath path) throws CMException {
        CMAddAnnotationQueryFunc queryFunc = new CMAddAnnotationQueryFunc();
        this.queryhelper_.getProps(path, new CMProperty[]{CMProperty.TENANTID}, queryFunc);
        Object tenantValue = queryFunc.getProperty(CMProperty.TENANTID);
        return tenantValue;
    }

    class CMAddAnnotationQueryFunc
    implements CMQueryResultFunction {
        boolean hasResults_ = false;
        CMObjectClass objectClass_;
        Map<CMProperty, Object> propsMap_ = null;

        CMAddAnnotationQueryFunc() {
        }

        public boolean isValidGrandParent() throws CMException {
            if (!this.hasResults_) {
                throw new CMException("cmFailNoParent");
            }
            if (!this.objectClass_.isValidChildClass(CMObjectClass.ANNOTATIONFOLDER)) {
                throw new CMException("cmInvalidContainerPath");
            }
            return true;
        }

        public boolean isAllowAnnotation() {
            Object propValue;
            CMProperty prop = this.objectClass_.getProperty("allowAnnotations");
            if (this.propsMap_.containsKey(prop) && (propValue = this.propsMap_.get(prop)) != null) {
                return propValue.toString().equals("true");
            }
            return false;
        }

        @Override
        public void setHasResults(boolean b) {
            this.hasResults_ = b;
        }

        @Override
        public void setResultObjClass(CMObjectClass objectClass) {
            this.objectClass_ = objectClass;
        }

        public boolean hasResults() {
            return this.hasResults_;
        }

        public CMObjectClass getObjectClass() {
            return this.objectClass_;
        }

        public void reset() {
            this.hasResults_ = false;
            this.objectClass_ = null;
            this.propsMap_ = null;
        }

        @Override
        public void addProperty(CMProperty property, Object value) {
            if (this.propsMap_ == null) {
                this.propsMap_ = new HashMap<CMProperty, Object>();
            }
            this.propsMap_.put(property, value);
        }

        public Object getProperty(CMProperty property) {
            if (this.propsMap_ != null) {
                return this.propsMap_.get(property);
            }
            return null;
        }
    }
}

