/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.contentManagerService.v1;

import com.cognos.CAM.AAAException;
import com.cognos.cm.accman.CMCAMNamespace;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMStringArray;
import com.cognos.cm.request.add;
import com.cognos.cm.request.contentManagerService.v1.add;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AddDef;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.NamespaceManager;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cmutils.path.SearchPathEncoder;

public class addNamespace
extends add {
    public static final String CAM_SERVICE_ID = "CAMSASVC";
    private CMCAMNamespace namespace;

    public addNamespace(CMStore store) {
        super(store);
    }

    @Override
    public boolean handle(IConfiguration config_, Request r) throws CMException {
        return this.runCommands("addNamespaceResponse", "addNamespaceReply");
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        this.ensureRequestIsTrusted();
        super.getParams(requestElement);
        AddDef addDef = this.getAddDef();
        if (this.namespace != null) {
            return;
        }
        this.namespace = this.toCMCAMNamespace(addDef);
        this.validateNamespace(this.namespace);
        if (!this.isExistingNamespace(this.namespace)) {
            this.addDefaultPolicies(addDef, this.namespace.getID());
        }
    }

    @Override
    protected void validatePolicies(AddDef addDef, AddDef.Entry entry, RequestHandler.ValidateOptions options) {
    }

    @Override
    protected void postSuccessfulOperation() {
        super.postSuccessfulOperation();
        this.getNamespaceManager().addNamespace(this.namespace);
    }

    private void ensureRequestIsTrusted() throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (!ctx.executingStaticRequest() && !CAM_SERVICE_ID.equals(ctx.getServiceId())) {
            throw new CMException("cmRequestNotTrusted");
        }
        CMExecutionContext.get().setExecutingStaticRequest(true);
    }

    private AddDef getAddDef() throws CMException {
        if (this.requestsInfo_.size() == 1) {
            add.RequestInfo ri = (add.RequestInfo)this.requestsInfo_.get(0);
            if (ri.addDefs_.size() == 1) {
                return (AddDef)ri.addDefs_.get(0);
            }
        }
        throw new CMException(new IllegalArgumentException("This method only supports adding one namespace at a time"), "cmBadRequest");
    }

    private CMCAMNamespace toCMCAMNamespace(AddDef addDef) throws CMException {
        if (addDef.objectClass != CMObjectClass.NAMESPACE) {
            throw new CMException(new IllegalArgumentException("Expected object of type 'namespace', found: " + addDef.objectClass.getName()), "cmBadRequest");
        }
        String id = (String)addDef.get(CMProperty.ID);
        String name = addDef.name;
        Object active = addDef.get(CMProperty.ACTIVE);
        boolean isActive = active == null ? true : active.toString().equals("true");
        CMStringArray caps = (CMStringArray)addDef.remove(CMObjectClass.NAMESPACE.getProperty("capabilities"));
        addDef.put(CMObjectClass.NAMESPACE.getProperty("_capabilities"), caps);
        if (id == null || name == null || caps == null) {
            throw new CMException(new IllegalArgumentException("Properties 'name', 'id', and 'capabilities' must be specified"), "cmBadRequest");
        }
        CMCAMNamespace ns = new CMCAMNamespace(id, name, isActive, caps);
        return ns;
    }

    private void addDefaultPolicies(AddDef addDef, String nsId) throws CMException {
        if (nsId.equals(":")) {
            CMIndications.logException(new IllegalStateException("Unexpected getDefaultPolicies() call for Cognos namespace"));
            return;
        }
        try {
            addDef.put(CMProperty.POLICIES, AccMan.createAPolicy(this.getDefaultPolicies(nsId)));
        }
        catch (AAAException ae) {
            throw new CMException((Exception)((Object)ae), "cmUnexpectedError");
        }
    }

    private Object[][] getDefaultPolicies(String nsId) {
        Object[][] policies = new Object[][]{this.createPolicy("::Everyone", "r"), this.createPolicy(nsId, "rt")};
        return policies;
    }

    private Object[] createPolicy(String id, String permissions) {
        Object[] policy = new Object[6];
        policy[0] = "CAMID(" + SearchPathEncoder.quoteString((String)id) + ")";
        char[] perms = new char[]{'r', 'w', 'x', 'p', 't'};
        for (int i = 0; i < perms.length; ++i) {
            policy[i + 1] = permissions.indexOf(perms[i]) != -1;
        }
        return policy;
    }

    private void validateNamespace(CMCAMNamespace ns) throws CMException {
        CMCAMNamespace ns1 = this.getNamespaceManager().getNamespace(ns.getID());
        CMCAMNamespace ns2 = this.getNamespaceManager().getNamespaceByName(ns.getName());
        if (ns1 != null && ns2 == null) {
            throw new CMException("cmBadNSIDCase1", new CMException.Parm("id", ns.getID()));
        }
        if (ns1 == null && ns2 != null) {
            throw new CMException("cmBadNSIDCase2", new CMException.Parm("name", ns.getName()));
        }
    }

    private NamespaceManager getNamespaceManager() {
        return CMServlet.namespaceManager;
    }

    private boolean isExistingNamespace(CMCAMNamespace ns) {
        return this.getNamespaceManager().getNamespace(ns.getID()) != null;
    }
}

