/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.contentManagerService.v1;

import com.cognos.cm.cam.AAAProvider_OpenIDProxy;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.AddDef;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMAAAObjectPropertiesDoc;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMProxyAccountData;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMSOAPWriter;
import com.cognos.cmutils.path.SearchPathEncoder;
import java.util.ArrayList;

public class createAccountProxy
extends RequestHandler {
    private String namespace;
    private ArrayList<AddDef> addDefs;

    public createAccountProxy(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        this.getParamsAll();
        this.setIPFInfo();
    }

    private void setIPFInfo() {
        CMExecutionContext ctx = CMExecutionContext.get();
        ctx.setIPFCategory("Audit.Admin.CM");
        ctx.setIPFObjectPath(this.namespace);
        ctx.setIPFObjectType("NAMESPACE");
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        this.processNamespaceParameter(requestElement);
        XMLElement objectsEl = requestElement.getChildWithName("objects");
        this.addDefs = new ArrayList();
        for (XMLElement el : objectsEl.children_) {
            AddDef addDef = this.getObjectIntoAddDef(el, -1, false);
            this.addCamIdentityIntoAddDef(el, addDef);
            this.validateAddDef(addDef);
            this.addDefs.add(addDef);
        }
    }

    private void addCamIdentityIntoAddDef(XMLElement el, AddDef addDef) throws CMException {
        XMLElement value = el.getChild("camIdentity", "value");
        if (value != null && value.value_ != null && !value.isNil_) {
            addDef.addUnique(CMProperty.CAMIDENTITY, value.value_);
        }
    }

    private void processNamespaceParameter(XMLElement requestElement) throws CMException {
        String nsParam = requestElement.getChildValueWithName("namespace");
        CMStoreXPath path = new CMStoreXPath(nsParam);
        String camid = path.getCAMIDFromFirstStep();
        if (!CMCAMIDHelper.isOpenIDNamespaceObject(camid)) {
            throw new CMException("cmBadContext", "Name", this.namespace);
        }
        this.namespace = path.toString();
    }

    private void validateAddDef(AddDef addDef) throws CMException {
        if (addDef.objectClass != CMObjectClass.ACCOUNT && addDef.objectClass != CMObjectClass.GROUP) {
            throw new CMException("cmUnsupportedClass", "class", addDef.objectClass.getName());
        }
        if (addDef.objectClass == CMObjectClass.ACCOUNT) {
            if (!addDef.contains(CMObjectClass.ACCOUNT.getProperty("email")) && !addDef.contains(CMProperty.CAMIDENTITY)) {
                throw new CMException("cmMissingRequiredProp", new CMException.Parm("Object", addDef.objectClass.getName()), new CMException.Parm("Property", "camIdentity"));
            }
            if (addDef.name == null) {
                this.setAccountDefaultName(addDef);
            }
        } else if (addDef.objectClass == CMObjectClass.GROUP && addDef.name == null) {
            throw new CMException("cmMissingRequiredProp", new CMException.Parm("Object", addDef.objectClass.getName()), new CMException.Parm("Property", "defaultName"));
        }
    }

    private void setAccountDefaultName(AddDef addDef) {
        String givenName = (String)addDef.get(CMObjectClass.ACCOUNT.getProperty("givenName"));
        String surname = (String)addDef.get(CMObjectClass.ACCOUNT.getProperty("surname"));
        addDef.name = givenName != null && surname != null ? givenName + " " + surname : (String)addDef.get(CMObjectClass.ACCOUNT.getProperty("email"));
    }

    private void verifyRequestPermissions() throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (!ctx.hasCapability("canUseUsersGroupsAndRolesTool")) {
            throw new CMException("cmInsufficientPermissionsForRequest");
        }
        String camid = CMCAMIDHelper.CAMIDFromSearchPath(this.namespace);
        if (!ctx.isUserAuthenticatedIntoNamespace(camid)) {
            throw new CMException("cmBadContext", "Name", this.namespace);
        }
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    @Override
    public boolean handle(IConfiguration config_, Request r) throws CMException {
        this.verifyRequestPermissions();
        ArrayList<CMObjectReference> result = new ArrayList<CMObjectReference>();
        for (AddDef addDef : this.addDefs) {
            result.add(this.createProxy(addDef));
        }
        this.writeResponse(result);
        return true;
    }

    private void writeResponse(ArrayList<CMObjectReference> objects) {
        CMSOAPWriter soap = new CMSOAPWriter(this.wri);
        soap.element(CMSOAPConstants.NS_CM_1, "createAccountProxyResponse");
        soap.addDefaultNamespaces();
        ((CMSOAPWriter)soap.element("result")).arrayType(CMPropertyTypes.BIBUS_BASECLASS, objects.size());
        for (CMObjectReference obj : objects) {
            if (obj == null) {
                ((CMSOAPWriter)((CMSOAPWriter)soap.element("item")).type(CMPropertyTypes.BIBUS_NIL).xsiNil()).end();
                continue;
            }
            ((CMSOAPWriter)soap.element("item")).type(obj.getObjectClass());
            ((CMSOAPWriter)((CMSOAPWriter)((CMSOAPWriter)((CMSOAPWriter)soap.element("searchPath")).propType(CMPropertyTypes.XML_STRING).element("value")).type(CMPropertyTypes.XML_STRING).text(obj.getSearchPath())).end()).end();
            ((CMSOAPWriter)((CMSOAPWriter)((CMSOAPWriter)((CMSOAPWriter)soap.element("storeID")).propType(CMPropertyTypes.BIBUS_GUID).element("value")).type(CMPropertyTypes.BIBUS_GUID).text(this.getStoreID(obj))).end()).end();
            soap.end();
        }
        soap.end();
        soap.end();
        soap.flush();
    }

    private String getStoreID(CMObjectReference obj) {
        return CMCAMIDHelper.CAMID2storeID(CMCAMIDHelper.CAMIDFromSearchPath(obj.getSearchPath()));
    }

    private CMObjectReference createProxy(AddDef addDef) throws CMException {
        String searchPath = this.getObjectSearchPath(addDef);
        if (searchPath == null) {
            return null;
        }
        String camid = CMCAMIDHelper.CAMIDFromSearchPath(searchPath);
        CMProxyAccountData proxy = this.store_.createSecurityProxyObject(camid, CMCAMIDHelper.getOpenIDNSAncestors(camid), addDef.objectClass, this.getTenantId(addDef), false);
        this.updateProxy(searchPath, addDef);
        CMDbStoreObjectReference ref = new CMDbStoreObjectReference(proxy.getObjectID(), addDef.objectClass, searchPath);
        ref.setStoreID(CMCAMIDHelper.CAMID2storeID(camid));
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProxy(String searchPath, AddDef addDef) throws CMException {
        CMStoreQueryResults rs;
        block4: {
            addDef.remove(CMProperty.TENANTID);
            addDef.put(CMProperty.DEFAULTNAME, addDef.name);
            addDef.remove(CMProperty.CAMIDENTITY);
            if (addDef.size() == 0) {
                return;
            }
            CMStoreXPath path = new CMStoreXPath(searchPath, 13);
            this.lockMgr_.requestLocks(path);
            rs = null;
            try {
                this.store_.beginTransaction();
                rs = this.store_.executeQuery(path, null, null, 7, 512, null);
                if (rs.next()) break block4;
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(rs);
                this.store_.rollbackOpenTransaction();
                this.lockMgr_.releaseLocks();
                throw throwable;
            }
            CMQueryUtils.safeQueryResultsRelease(rs);
            this.store_.rollbackOpenTransaction();
            this.lockMgr_.releaseLocks();
            return;
        }
        rs.reset();
        this.store_.update(rs, addDef.names(), addDef.values());
        rs.release();
        rs = null;
        this.store_.commitTransaction();
        CMQueryUtils.safeQueryResultsRelease(rs);
        this.store_.rollbackOpenTransaction();
        this.lockMgr_.releaseLocks();
    }

    private int getTenantId(AddDef addDef) throws CMException {
        if (addDef.contains(CMProperty.TENANTID)) {
            String tenantIdString = (String)addDef.get(CMProperty.TENANTID);
            return this.tenantRegistry.getTenantIdIntFromString(tenantIdString, false);
        }
        return -1;
    }

    private String getObjectSearchPath(AddDef addDef) throws CMException {
        StringBuilder buf = new StringBuilder();
        buf.append(this.namespace).append("//*[@objectClass=\"").append(addDef.objectClass).append("\"][");
        String separator = "";
        if (this.addPredicate(buf, addDef, CMProperty.CAMIDENTITY, separator)) {
            separator = " and ";
        }
        if (addDef.objectClass == CMObjectClass.ACCOUNT) {
            this.addPredicate(buf, addDef, CMObjectClass.ACCOUNT.getProperty("email"), separator);
        } else if (addDef.objectClass == CMObjectClass.GROUP) {
            buf.append(separator).append("@name=").append(SearchPathEncoder.quoteString((String)addDef.name));
        }
        this.addPredicate(buf, addDef, CMProperty.TENANTID, " and ");
        buf.append(']');
        String path = buf.toString();
        try {
            CMAAAObjectPropertiesDoc aaaQuery = new CMAAAObjectPropertiesDoc(path, AAAProvider_OpenIDProxy.AAA_PASSTHROUGH_TAG, addDef.objectClass, CMProperty.SEARCHPATH);
            return aaaQuery.getValue(0).toString();
        }
        catch (Exception e) {
            throw new CMException(e, "cmNameSpaceQueryErr");
        }
    }

    private boolean addPredicate(StringBuilder buf, AddDef addDef, CMProperty prop, String separator) {
        String value = (String)addDef.get(prop);
        if (value != null) {
            buf.append(separator).append("@").append(prop.getName()).append("=").append(SearchPathEncoder.quoteString((String)value));
            return true;
        }
        return false;
    }
}

