/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.contentManagerService.v1;

import com.cognos.CAM.AAAException;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.delete2;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.UserSessionCache;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMIndentedPrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;

public class deleteAccount
extends RequestHandler {
    public static final String IPF_CATEGORY = "Audit.RTUsage.CM";
    private String objectPath;

    public deleteAccount(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.objectPath = this.didGetParmUsingXMLEl_.getChildNonNullValueWithName("objectPath");
        CMExecutionContext ctx = CMExecutionContext.get();
        ctx.setIPFCategory(IPF_CATEGORY);
        ctx.setIPFObjectPath(this.objectPath);
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        this.store_ = CMExecutionContext.get().getStore();
        CMStoreXPath path = new CMStoreXPath(this.objectPath);
        int cmid = this.disableObject(path);
        this.endActiveSessions(cmid);
        ArrayList<CMStoreXPath> children = this.queryChildren(path);
        for (CMStoreXPath child : children) {
            this.deleteObject(child);
        }
        this.deleteAccountObject(path);
        this.writeResponse();
        return true;
    }

    private void deleteAccountObject(CMStoreXPath path) throws CMException {
        try {
            this.deleteObject(path);
            membershipCacheClear = true;
        }
        finally {
            deleteAccount.clearMembershipCache();
        }
    }

    private Set<String> getActiveSessions(int cmid) {
        UserSessionCache usc = CMExecutionContext.getSessionCache();
        SortedSet<String> activeSessions = usc.getPassportIds(cmid);
        return activeSessions;
    }

    private void writeResponse() {
        this.reset();
        this.setUpOutStream();
        CMIndentedPrintStream out = new CMIndentedPrintStream(this.oStream);
        out.indent();
        out.print("<");
        out.print("deleteAccountResponse");
        out.print("/>");
    }

    private void deleteObject(CMStoreXPath path) throws CMException {
        try {
            path.setLockManagerUsageFlag(15);
            this.lockMgr_.requestLocks(path);
            delete2.deleteDescendants(this.store_, (CMStorePath)path, 33280, true);
        }
        finally {
            this.lockMgr_.releaseLocks();
        }
    }

    private boolean isValidPath(CMStoreXPath path) throws CMException {
        if (path.isUnion()) {
            return false;
        }
        path.ResolveCurrentUserSteps(false, false);
        if (path.size() > 1) {
            return false;
        }
        return path.getCAMIDFromFirstStep() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int disableObject(CMStoreXPath path) throws CMException {
        if (!this.isValidPath(path)) {
            throw new CMException("cmInvalidSearchPath", new CMException.Parm("Path", this.objectPath));
        }
        CMStoreQueryResults results = null;
        path.setLockManagerUsageFlag(13);
        this.lockMgr_.requestLocks(path);
        try {
            this.store_.beginTransaction();
            results = this.store_.executeQuery(path, null, null, 7, 2, null);
            if (!results.next()) {
                throw new CMException("cmObjectNotFound", new CMException.Parm("Path", this.objectPath));
            }
            if (results.getObjectClass() != CMObjectClass.ACCOUNT) {
                throw new CMException("cmInvalidSearchPath", new CMException.Parm("Path", this.objectPath));
            }
            int cmid = results.getObjectID();
            if (results.next()) {
                throw new CMException("cmInvalidSearchPath", new CMException.Parm("Path", this.objectPath));
            }
            results.reset();
            this.store_.update(results, Collections.singletonList(CMProperty.DISABLED), Collections.singletonList("true"));
            this.store_.commitTransaction();
            int n = cmid;
            return n;
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.store_.rollbackOpenTransaction();
            this.lockMgr_.releaseLocks();
            path.clearLocksHaveBeenObtained();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<CMStoreXPath> queryChildren(CMStoreXPath path) throws CMException {
        ArrayList<CMStoreXPath> children = new ArrayList<CMStoreXPath>();
        CMStoreXPath childrenPath = new CMStoreXPath(path, "*", true);
        this.lockMgr_.requestLocks(childrenPath);
        CMStoreQueryResults results = null;
        try {
            results = this.store_.executeQuery(childrenPath, null, null, 0, 33280, null);
            while (results.next()) {
                int cmid = results.getObjectID();
                InternalStoreId id = this.store_.getInternalStoreId(cmid);
                if (id == null) continue;
                CMStoreXPath child = CMStoreXPath.fromStoreID(id.stringValue());
                children.add(child);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr_.releaseLocks();
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endActiveSessions(int cmid) {
        ArrayList<String> sessions;
        Set<String> activeSessions = this.getActiveSessions(cmid);
        if (activeSessions == null) {
            return;
        }
        Set<String> set = activeSessions;
        synchronized (set) {
            sessions = new ArrayList<String>(activeSessions.size());
            sessions.addAll(activeSessions);
        }
        String currentPassportId = CMExecutionContext.get().getAccManPassportID();
        for (String passportId : sessions) {
            try {
                this.logoffPassport(passportId);
            }
            catch (AAAException e) {
                this.logException((Exception)((Object)e));
            }
        }
        CMExecutionContext.get().setAccManPassportID(currentPassportId);
    }

    void logException(Exception e) {
        CMIndications.logException(e);
    }

    void logoffPassport(String passportId) throws AAAException {
        AccMan.logoffPassport(passportId);
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

