/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.contentManagerService.v1;

import com.cognos.cm.accman.CMCAMNamespace;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.NamespaceManager;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreHelper;
import com.cognos.cm.util.CMSOAPWriter;
import com.cognos.cmutils.path.SearchPathEncoder;
import java.util.Collections;
import java.util.List;

public class deleteNamespace
extends RequestHandler {
    private String namespace;

    public deleteNamespace(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        this.getParamsAll();
        this.setIPFInfo();
    }

    private void setIPFInfo() {
        CMExecutionContext ctx = CMExecutionContext.get();
        ctx.setIPFCategory("Audit.Admin.CM");
        ctx.setIPFObjectPath(this.namespace);
        ctx.setIPFObjectType("NAMESPACE");
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        this.namespace = requestElement.getChildValueWithName("id");
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (!ctx.executingStaticRequest() && !"CAMSASVC".equals(ctx.getServiceId())) {
            throw new CMException("cmRequestNotTrusted");
        }
    }

    @Override
    public boolean handle(IConfiguration config_, Request r) throws CMException {
        CMCAMNamespace ns = this.getNamespaceManager().getNamespace(this.namespace);
        if (ns == null) {
            throw new CMException("cmObjectNotFound");
        }
        this.deactivateNamespace(ns);
        this.writeResponse();
        return true;
    }

    private NamespaceManager getNamespaceManager() {
        return CMServlet.namespaceManager;
    }

    private void deactivateNamespace(CMCAMNamespace ns) throws CMException {
        List<Object> values;
        List<CMProperty> props;
        String path = "CAMID(" + SearchPathEncoder.quoteString((String)ns.getID()) + ")";
        if (CMStoreHelper.updateObject(this.store_, path, props = Collections.singletonList(CMProperty.ACTIVE), values = Collections.singletonList("false"), 33280)) {
            this.getNamespaceManager().deactivateNamespace(ns.getID());
        }
    }

    private void writeResponse() {
        CMSOAPWriter soap = new CMSOAPWriter(this.wri);
        soap.element(CMSOAPConstants.NS_CM_1, "deleteNamespaceResponse");
        soap.addDefaultNamespaces();
        soap.end();
        soap.flush();
    }
}

