/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.contentManagerService.v1;

import com.cognos.cm.constants.CMError;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.MyDataSetsRepositoryCleaner;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.AuditContext;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.UserSessionCacheEntry;
import com.cognos.cm.server.UserSessionsVisitor;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathFactory;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.cognos.cmutils.path.SearchPathEncoder;
import com.cognos.pogo.util.NameValuePair;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class deleteTenants
extends RequestHandler {
    private CMStorePathFactory pathFactory;
    private CMCache cache;
    protected Set<Integer> tenantIdsToDelete;
    private List<String> deletedUserAccounts_;

    public deleteTenants(CMStore store) {
        this(store, new CMStorePathFactory());
    }

    protected deleteTenants(CMStore store, CMStorePathFactory pathFactory) {
        super(store);
        this.cache = this.store_.getCache();
        this.pathFactory = pathFactory;
        this.tenantIdsToDelete = new HashSet<Integer>();
        this.deletedUserAccounts_ = new ArrayList<String>();
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        XMLElement tenantIdsEle = requestElement.getChildWithName("tenantIDs");
        if (tenantIdsEle.hasChildren()) {
            ArrayList<XMLElement> itemEles = tenantIdsEle.getChildren();
            for (XMLElement item : itemEles) {
                String value = item.value_;
                if (value == null || value.equals("")) {
                    throw new CMException("cmCantDeletePublicTenant");
                }
                try {
                    Integer id = new Integer(this.tenantRegistry.getTenantIdIntFromString(value, false));
                    this.tenantIdsToDelete.add(id);
                }
                catch (CMException e) {}
            }
        }
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        this.getParamsAll();
    }

    @Override
    public boolean handle(IConfiguration config_, Request r) throws CMException {
        this.ensureCurrentUserCanDeleteTenant();
        this.verifyNotTryingToDeleteOwnTenant();
        if (!this.tenantIdsToDelete.isEmpty()) {
            this.verifyNoActiveSessions();
            MyDataSetsRepositoryCleaner dataSetCleaner = this.getMyDataSetsRepositoryCleaner();
            for (Integer tenantId : this.tenantIdsToDelete) {
                try {
                    String tenantIdStr = this.tenantRegistry.getTenantIdStringFromInt(tenantId);
                    dataSetCleaner.collectLOBDataSources(tenantIdStr);
                    this.deleteTenantedContent(tenantId);
                    this.deleteTenantObject(tenantIdStr);
                    this.tenantRegistry.deleteTenants(tenantId);
                    this.auditAccess();
                }
                catch (Exception e) {
                    CMException exception = new CMException(e, "cmDeleteTenantsError");
                    CMIndications.logException(exception);
                    throw exception;
                }
            }
            dataSetCleaner.cleanDataSetsRepository(this.deletedUserAccounts_);
        }
        CMIndentedPrintStream out = new CMIndentedPrintStream(this.getOut());
        out.indent();
        out.print("<" + this.getMethodNamespace().getPrefix() + ":" + "deleteTenantsResponse");
        out.print(" xmlns:" + this.getMethodNamespace().getPrefix() + "=\"" + this.getMethodNamespace().getUri() + "\"");
        out.println(" />");
        out.unindent();
        return true;
    }

    private void verifyNotTryingToDeleteOwnTenant() throws CMException {
        int userTenantId = CMExecutionContext.get().getCurrentUserTenantId();
        if (this.tenantIdsToDelete.contains(new Integer(userTenantId))) {
            String tenantIdStr = this.tenantRegistry.getTenantIdStringFromInt(userTenantId);
            String tenantName = this.tenantRegistry.getTenantObjectDefaultName(this.store_, tenantIdStr);
            throw new CMException("cmCantDeleteTenantLoggedInto", new CMException.Parm("tenantName", tenantName), new CMException.Parm("tenantID", tenantIdStr));
        }
    }

    protected OutputStream getOut() {
        return this.oStream;
    }

    protected MyDataSetsRepositoryCleaner getMyDataSetsRepositoryCleaner() {
        return new MyDataSetsRepositoryCleaner(this.store_, this.pathFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTenantObject(String tenantID) throws CMException {
        CMStoreQueryResults results = null;
        CMExecutionContext ctx = CMExecutionContext.get();
        ctx.setIPFOperation("DELETE");
        AuditContext auditContext = ctx.getAuditContext();
        int cmid = -1;
        try {
            this.store_.beginTransaction();
            CMStoreXPath path = this.pathFactory.createCMStoreXPath("/directory/tenants/tenant[@tenantID=" + SearchPathEncoder.quoteString((String)tenantID) + "]");
            path.setLockManagerUsageFlag(15);
            this.lockMgr_.requestLocks(path);
            results = this.store_.executeQuery(path, null, null, 7, 33280, null);
            while (results.next()) {
                cmid = results.getObjectID();
                auditContext.add(cmid, CMObjectClass.TENANT);
                this.store_.delete2(results, true, null);
            }
            this.store_.commitTransaction();
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (this.store_.inTransaction()) {
                this.store_.rollbackTransaction();
            }
            this.lockMgr_.releaseLocks();
        }
    }

    public void auditAccess() {
        CMExecutionContext.get().setIPFCategory("Audit.Admin.CM");
        CMIndications.Audit_Access();
    }

    private void deleteTenantedContent(Integer tenantID) throws CMException, CMStoreParseException {
        String[] searchPaths;
        for (String searchPath : searchPaths = new String[]{"/" + CMObjectClass.CONTENT.toString(), "/" + CMObjectClass.CONFIGURATION.toString(), "/" + CMObjectClass.ADMINFOLDER.toString(), "/" + CMObjectClass.CAPABILITY.toString(), "/" + CMObjectClass.PORTAL.toString(), "/" + CMObjectClass.TRANSIENTSTATEFOLDER.toString(), "/" + CMObjectClass.CATALOG.toString(), "/" + CMObjectClass.RESOURCEFOLDER.toString(), "/" + CMObjectClass.FOLDER.toString(), "/" + CMObjectClass.DIRECTORY.toString()}) {
            List<String> tenantRootStoreIds = this.getTenantRootStoreIdsUnder(searchPath, tenantID);
            for (String storeId : tenantRootStoreIds) {
                this.deleteObjectAndDescendents(storeId);
            }
        }
    }

    protected void verifyNoActiveSessions() throws CMException {
        final HashMap tenantsWithActiveSessions = new HashMap();
        CMExecutionContext.getSessionCache().iterateOverPassports(new UserSessionsVisitor(){

            @Override
            public void visit(String passportId, UserSessionCacheEntry entry) {
                if (deleteTenants.this.tenantIdsToDelete.contains(entry.getTenantId())) {
                    String tenantId = deleteTenants.this.tenantRegistry.getTenantIdStringFromInt(entry.getTenantId());
                    Integer sessionCount = (Integer)tenantsWithActiveSessions.get(tenantId);
                    sessionCount = new Integer((sessionCount == null ? 0 : sessionCount) + 1);
                    tenantsWithActiveSessions.put(tenantId, sessionCount);
                }
            }
        });
        if (!tenantsWithActiveSessions.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : tenantsWithActiveSessions.entrySet()) {
                String tenantIDStr = (String)entry.getKey();
                String tenantName = this.tenantRegistry.getTenantObjectDefaultName(this.store_, tenantIDStr);
                NameValuePair[] params = new NameValuePair[]{new NameValuePair("tenantName", tenantName), new NameValuePair("tenantID", tenantIDStr), new NameValuePair("count", String.valueOf(entry.getValue()))};
                builder.append(CMError.getMessage("cmDeleteTenantsActiveSessions_details", params, null)).append("\n");
            }
            builder.delete(builder.length() - 1, builder.length());
            throw new CMException("cmDeleteTenantsActiveSessions", new CMException.Parm("cmDeleteTenantsActiveSessions_details", builder.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getTenantRootStoreIdsUnder(String searchPath, Integer tenantIdToDelete) throws CMException {
        CMStoreQueryResults initialResults = null;
        CMStoreQueryResults tenantRootResults = null;
        try {
            CMStoreXPath path = this.pathFactory.createCMStoreXPath(searchPath, 16);
            this.lockMgr_.requestLocks(path);
            initialResults = this.store_.executeQuery(path, null, null, 0, 512, null);
            if (!initialResults.next()) {
                throw new CMException("cmErrNoObjIn", new CMException.Parm("Location", searchPath));
            }
            int objectId = initialResults.getObjectID();
            String tenantRootsQueryString = this.createTenantRootsQueryString(objectId, tenantIdToDelete);
            CMStoreXPath tenantRootsQuery = this.pathFactory.createCMStoreXPath(tenantRootsQueryString);
            tenantRootResults = this.store_.executeQuery(tenantRootsQuery, null, null, 0, 512, null);
            ArrayList<String> tenantRootStoreIds = new ArrayList<String>();
            while (tenantRootResults.next()) {
                int tenantRootId = tenantRootResults.getObjectID();
                if (tenantRootResults.getObjectClass() == CMObjectClass.TENANT) continue;
                String tenantRootStoreId = this.cache.CMCacheGetStoreId(tenantRootId, true);
                tenantRootStoreIds.add(tenantRootStoreId);
                this.collectDeletedUserAccounts(tenantRootId);
            }
            ArrayList<String> arrayList = tenantRootStoreIds;
            return arrayList;
        }
        finally {
            if (initialResults != null) {
                initialResults.release();
            }
            if (tenantRootResults != null) {
                tenantRootResults.release();
            }
            this.lockMgr_.releaseLocks();
        }
    }

    protected void collectDeletedUserAccounts(int tenantRootId) {
        try {
            String tenantRootSearchPath = this.cache.CMCacheGetSearchPath(tenantRootId, CMDbStoreCacheUtil.getCacheSearchLocales());
            int classID = this.cache.CMCacheGetClass(tenantRootId);
            CMObjectClass objectClass = CMDbStoreFactory.objectClasses_.getClassByID(classID);
            if (objectClass == CMObjectClass.ACCOUNT) {
                this.deletedUserAccounts_.add(tenantRootSearchPath);
            }
        }
        catch (Exception e) {
            CMIndications.logException(e, "Failed to verify the object being deleted is a user account.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteObjectAndDescendents(String storeId) throws CMException, CMStoreParseException {
        CMStoreQueryResults toDelete = null;
        try {
            this.store_.beginTransaction();
            CMStoreXPath deletePath = this.pathFactory.createCMStoreXPath("storeID('" + storeId + "')/descendant-or-self::*");
            deletePath.setLockManagerUsageFlag(15);
            this.lockMgr_.requestLocks(deletePath);
            toDelete = this.store_.executeQuery(deletePath, null, null, 8, 512, null);
            this.store_.delete2(toDelete, true, null);
            this.store_.commitTransaction();
        }
        finally {
            if (toDelete != null) {
                toDelete.release();
            }
            if (this.store_.inTransaction()) {
                this.store_.rollbackTransaction();
            }
            this.lockMgr_.releaseLocks();
        }
    }

    private String createTenantRootsQueryString(int objectId, Integer tenantId) {
        StringBuffer pathBuffer = new StringBuffer();
        pathBuffer.append("tenantRoots(").append(objectId).append(",");
        pathBuffer.append("'");
        pathBuffer.append(tenantId);
        pathBuffer.append("')");
        return pathBuffer.toString();
    }

    private void ensureCurrentUserCanDeleteTenant() throws CMException {
        CMExecutionContext context = CMExecutionContext.get();
        if (context.isTrustedServiceWithUnfilteredTenantAccess()) {
            return;
        }
        if (!context.getCurrentUserIsAdministrator()) {
            throw new CMException("cmMustBeSysAdmin");
        }
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    protected CMSOAPConstants.XMLNamespace getMethodNamespace() {
        return CMSOAPConstants.NS_CM_1;
    }
}

