/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.contentManagerService.v1;

import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.multitenancy.ReadTenantFilter;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.rest.CMQueryHelperImpl;
import com.cognos.cm.rest.CMStoreQueryHelper;
import com.cognos.cm.rest.ResultProperty;
import com.cognos.cm.rest.ResultRow;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMSOAPWriter;
import com.cognos.cmutils.xml.Namespace;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class listTenants
extends RequestHandler {
    private CMStoreQueryHelper query;
    private OutputStream outputStream;
    private int maxObjects;
    private int skipObjects;

    public listTenants(CMStore store) {
        super(store);
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        XMLElement optionsElement = requestElement.getOptionalChildWithName("options");
        if (optionsElement != null && optionsElement.hasChildren()) {
            ArrayList<XMLElement> options = optionsElement.getChildren();
            for (XMLElement option : options) {
                try {
                    if (option.value_ == null) continue;
                    if (option.name_.equals("maxObjects")) {
                        this.maxObjects = Integer.parseInt(option.value_);
                        continue;
                    }
                    if (!option.name_.equals("skipObjects")) continue;
                    this.skipObjects = Integer.parseInt(option.value_);
                }
                catch (NumberFormatException e) {
                    throw new CMException((Exception)e, "cmBadAttribute", new CMException.Parm("Name", option.name_));
                }
            }
        }
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        this.getParamsAll();
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        this.ensureCurrentUserIsAdminOrStaticRequest();
        List<ResultRow> result = this.queryTenants();
        ResultRow publicTenant = new ResultRow();
        publicTenant.add(new ResultProperty(CMProperty.TENANTID.getName(), ""));
        publicTenant.add(new ResultProperty(CMProperty.DEFAULTNAME.getName(), ""));
        result.add(0, publicTenant);
        this.outputResponse(result);
        return true;
    }

    private void ensureCurrentUserIsAdminOrStaticRequest() throws CMException {
        CMExecutionContext context = CMExecutionContext.get();
        if (!(context.getCurrentUserIsAdministrator() || context.isTenantAdministrator() || context.executingStaticRequest())) {
            throw new CMException("cmMustBeSysAdminOrTenantAdmin");
        }
    }

    private List<ResultRow> queryTenants() throws CMException {
        ReadTenantFilter originalTenantFilter = CMExecutionContext.get().getReadTenantFilter();
        try {
            CMExecutionContext.get().setReadTenantFilter(new ReadTenantFilter.AllowAllTenantFilter());
            if (this.query == null) {
                this.query = new CMQueryHelperImpl(CMExecutionContext.get());
            }
            this.query.setOrderBy(new OrderByField[]{new OrderByField(false, CMProperty.DEFAULTNAME)});
            List<ResultRow> list = this.query.executeAdminQuery(this.query.parsePath("/directory/tenants/tenant"), CMProperty.TENANTID, CMProperty.DEFAULTNAME);
            return list;
        }
        finally {
            CMExecutionContext.get().setReadTenantFilter(originalTenantFilter);
            this.lockMgr_.releaseLocks();
        }
    }

    private void outputResponse(List<ResultRow> result) {
        if (this.outputStream == null) {
            this.outputStream = this.oStream;
        }
        CMSOAPWriter writer = new CMSOAPWriter(this.outputStream, "UTF-8");
        writer.element(this.getMethodNamespace(), "listTenantsResponse");
        writer.addNamespaces(new Namespace[]{this.getMethodNamespace(), CMSOAPConstants.NS_BIBUS, CMSOAPConstants.NS_XMLSCHEMA});
        this.outputResult(writer, result);
        writer.end();
        writer.flush();
    }

    private void outputResult(CMSOAPWriter writer, List<ResultRow> result) {
        if (this.skipObjects >= result.size()) {
            this.printEmptyResult(writer);
            return;
        }
        if (this.maxObjects <= 0) {
            this.maxObjects = result.size();
        }
        int startIndex = this.determineStartIndex(result.size());
        int numberOfItems = this.maxObjects;
        if (startIndex + this.maxObjects > result.size()) {
            numberOfItems = result.size() - startIndex;
        }
        writer.element("result");
        writer.arrayType(CMPropertyTypes.BIBUS_TENANTINFO, numberOfItems);
        for (int i = 0; i < numberOfItems; ++i) {
            ResultRow row = result.get(i + startIndex);
            ((CMSOAPWriter)writer.element("item")).type(CMPropertyTypes.BIBUS_TENANTINFO);
            ((CMSOAPWriter)writer.element("tenantID")).type(CMPropertyTypes.XML_STRING);
            writer.text(((ResultProperty)((Object)row.get(0))).getValue().toString());
            writer.end();
            ((CMSOAPWriter)writer.element("defaultName")).type(CMPropertyTypes.XML_STRING);
            writer.text(((ResultProperty)((Object)row.get(1))).getValue().toString());
            writer.end();
            writer.end();
        }
        writer.end();
    }

    private void printEmptyResult(CMSOAPWriter writer) {
        writer.element("result");
        writer.arrayType(CMPropertyTypes.BIBUS_TENANTINFO, 0);
        writer.end();
    }

    private int determineStartIndex(int size) {
        int startIndex = this.skipObjects;
        if (this.skipObjects < 0) {
            startIndex = size + this.skipObjects;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        return startIndex;
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    protected CMSOAPConstants.XMLNamespace getMethodNamespace() {
        return CMSOAPConstants.NS_CM_1;
    }

    protected void setQueryHelper(CMStoreQueryHelper helper) {
        this.query = helper;
    }

    protected void setSkipAndMax(int skip, int max) {
        this.skipObjects = skip;
        this.maxObjects = max;
    }

    protected int getMaxObjects() {
        return this.maxObjects;
    }

    protected int getSkipObjects() {
        return this.skipObjects;
    }

    protected void setOutputStream(OutputStream stream) {
        this.outputStream = stream;
    }
}

