/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.contentManagerService.v1;

import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreMembership;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMSOAPWriter;
import com.cognos.cmutils.xml.Namespace;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class queryTenantMembership
extends RequestHandler {
    private List<String> tenantIDs;
    private OutputStream outputStream;

    public queryTenantMembership(CMStore store) {
        super(store);
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        XMLElement identitiesElem = requestElement.getChildWithName("tenantIDs");
        if (identitiesElem.hasChildren()) {
            ArrayList<XMLElement> children = identitiesElem.getChildren();
            this.tenantIDs = new ArrayList<String>(children.size());
            for (XMLElement child : children) {
                this.tenantIDs.add(child.value_);
            }
        }
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        this.getParamsAll();
    }

    @Override
    public boolean handle(IConfiguration config_, Request r) throws CMException {
        this.ensureCurrentUserIsSysAdminOrTrustedRequest();
        Set<String> tenantIds = this.determineTenantIds();
        this.outputResponse(tenantIds);
        return false;
    }

    private Set<String> determineTenantIds() throws CMException {
        int[] tenantObjectIds = this.getTenantsForTenantIDs();
        TreeSet<String> tenantIds = new TreeSet<String>();
        for (int id : tenantObjectIds) {
            int tenantIdInt = this.store_.getCache().CMCacheGetTenantID(id);
            tenantIds.add(this.tenantRegistry.getTenantIdStringFromInt(tenantIdInt));
        }
        return tenantIds;
    }

    private void outputResponse(Set<String> tenantIds) {
        if (this.outputStream == null) {
            this.outputStream = this.oStream;
        }
        CMSOAPWriter writer = new CMSOAPWriter(this.outputStream, "UTF-8");
        writer.element(CMSOAPConstants.NS_CM_1, "queryTenantMembershipResponse");
        writer.addNamespaces(new Namespace[]{CMSOAPConstants.NS_CM_1, CMSOAPConstants.NS_BIBUS, CMSOAPConstants.NS_XMLSCHEMA});
        writer.element("result");
        writer.arrayType(CMPropertyTypes.XML_STRING, tenantIds.size());
        for (String tenantId : tenantIds) {
            ((CMSOAPWriter)writer.element("item")).type(CMPropertyTypes.XML_STRING);
            writer.text(tenantId);
            writer.end();
        }
        writer.end();
        writer.end();
        writer.flush();
    }

    protected int[] getTenantsForTenantIDs() throws CMException {
        if (this.tenantIDs == null || this.tenantIDs.isEmpty()) {
            return new int[0];
        }
        return CMDbStoreMembership.getTenantsForTenantIDs((CMDbStore)this.store_, this.tenantIDs).toArray();
    }

    private void ensureCurrentUserIsSysAdminOrTrustedRequest() throws CMException {
        CMExecutionContext context = CMExecutionContext.get();
        if (!context.getCurrentUserIsAdministrator() && context.getTrustedService() == null && !context.executingStaticRequest()) {
            throw new CMException("cmMustBeSysAdmin");
        }
    }

    public List<String> getTenantIDs() {
        return this.tenantIDs;
    }

    protected void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

