/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.contentManagerService.v1;

import com.cognos.cm.request.contentManagerService.v1.AsyncRequestHandler;
import com.cognos.cm.server.ASyncRequestManager;
import com.cognos.cm.server.AsyncRequestState;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.cognos.cm.util.CMStringUtils;

public class wait
extends AsyncRequestHandler {
    private static final int WAIT_INTERVAL = 1000;
    private int secondaryWaitThreshold_ = 30000;
    protected boolean alwaysIncludePrimaryRequest_ = false;

    public wait(CMStore store) {
        super(store);
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        super.getParams(requestElement);
        XMLElement optionsXML = requestElement.getOptionalChildWithName("options");
        if (optionsXML != null && optionsXML.children_ != null) {
            for (int i = 0; i < optionsXML.children_.size(); ++i) {
                XMLElement optionValueXML;
                XMLElement optionXML = optionsXML.children_.get(i);
                XMLElement optionNameXML = optionXML.getChildWithName("name");
                if (optionNameXML.value_ == null) continue;
                if (optionNameXML.value_.equals("secondaryWaitThreshold")) {
                    optionValueXML = optionXML.getChildWithName("value");
                    if (optionValueXML.value_ == null) continue;
                    this.secondaryWaitThreshold_ = Integer.parseInt(optionValueXML.value_) * 1000;
                    continue;
                }
                if (!optionNameXML.value_.equals("alwaysIncludePrimaryRequest")) continue;
                optionValueXML = optionXML.getChildWithName("value");
                if (optionValueXML.value_ == null) continue;
                this.alwaysIncludePrimaryRequest_ = new Boolean(optionValueXML.value_);
            }
        }
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        String responseStatus;
        String hashedId;
        ASyncRequestManager asm = ASyncRequestManager.getInstance();
        AsyncRequestState requestState = asm.getRequestStatus(hashedId = asm.getHashedId(this.id_));
        if (requestState == null) {
            throw new CMException("cmBadConversationId");
        }
        int state = requestState.getRequestState();
        for (int duration = 0; (AsyncRequestState.isRequestRunning(state) || AsyncRequestState.isRequestQueued(state)) && duration < this.secondaryWaitThreshold_; duration += 1000) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            state = requestState.getRequestState();
        }
        if (AsyncRequestState.isRequestRunning(state) || AsyncRequestState.isRequestQueued(state)) {
            responseStatus = "stillWorking";
        } else {
            if (AsyncRequestState.isRequestException(state)) {
                Exception e = requestState.getException();
                asm.removeRequestStatus(hashedId);
                if (e instanceof CMException) {
                    throw (CMException)e;
                }
                throw new CMException(e, "cmCMError");
            }
            responseStatus = "conversationComplete";
            this.alwaysIncludePrimaryRequest_ = true;
            asm.removeRequestStatus(hashedId);
        }
        this.setConversationContext(responseStatus);
        this.generateResponse(requestState, responseStatus);
        return true;
    }

    private void generateResponse(AsyncRequestState ars, String status) throws CMException {
        CMIndentedPrintStream out = new CMIndentedPrintStream(this.oStream);
        out.indent();
        out.print(baLT);
        out.print("cm1");
        out.print(baColon);
        out.print("waitResponse");
        out.print(baPropNSDecl_Seg1);
        out.print("cm1");
        out.print(baEqualsQuote);
        out.print("http://developer.cognos.com/schemas/contentManagerService/1");
        out.print(baQuote_GT_EOL);
        out.indent();
        out.print(baLT);
        out.print("result");
        out.print(baElemSP_Seg1);
        out.print("bus");
        out.print(baColon);
        out.print("asynchReply");
        out.print(baQuote_GT_EOL);
        if (this.alwaysIncludePrimaryRequest_) {
            out.print(CMStringUtils.getUTF8BytesFromString(ars.getPrimaryRequest()));
        }
        out.print(baLT);
        out.print("status");
        out.print(baElemSP_Seg1);
        out.print("bus");
        out.print(baColon);
        out.print("asynchReplyStatusEnum");
        out.print(baQuote_GT);
        out.print(status);
        out.print(baLT_Slash);
        out.print("status");
        out.print(baGT_EOL);
        out.unindent();
        out.print(baLT_Slash);
        out.print("result");
        out.print(baGT_EOL);
        out.unindent();
        out.print(baLT_Slash);
        out.print("cm1");
        out.print(baColon);
        out.print("waitResponse");
        out.print(baGT);
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

