/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.connectors.MSConnector.MSConnector;
import com.cognos.cm.constants.ContentTaskOption;
import com.cognos.cm.contentTasks.CMRunnableErrorsReporter;
import com.cognos.cm.contentTasks.MSRunnableErrorsReporter;
import com.cognos.cm.contentTasks.RunnableErrorsReporter;
import com.cognos.cm.contentTasks.Task;
import com.cognos.cm.contentTasks.TaskFactory;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePairArray;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.properties.CMTypedNameValuePairArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;

public class contentTask
extends RequestHandler {
    public static final String OPTION_ENUM_NAME = "contentTaskOptionEnum";
    public static final String OBJECT_SEARCH_PATH = "objectPath";
    private static final int DEFAULT_TIMEOUT = 1000;
    protected boolean bSucceeded_ = true;
    protected TaskFactory taskFactory = new TaskFactory();
    RunnableErrorsReporter errorsReporter;

    public contentTask(CMStore store) {
        super(store);
    }

    protected void setTaskFactory(TaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    private void setErrorsReporter() throws CMException {
        if (this.spRunHistory_ == null) {
            String eventId = this.getEventId();
            if (null == eventId) {
                throw new CMException("cmMissingEventId");
            }
            this.errorsReporter = new MSRunnableErrorsReporter(eventId);
        } else {
            if (this.spRunHistoryStorePath_ == null) {
                this.spRunHistoryStorePath_ = new CMStoreXPath(this.spRunHistory_);
            }
            if (this.spRunHistoryStorePath_ == null) {
                throw new CMException("cmMissingRunHistory");
            }
            this.errorsReporter = new CMRunnableErrorsReporter(this.store_, this.lockMgr_, this.spRunHistoryStorePath_);
        }
    }

    private int getPrimaryTimeout() {
        int nPrimaryTimeout = 1000;
        String primaryWaitThreshold = (String)this.runOptions_.get("primaryWaitThreshold");
        if (primaryWaitThreshold != null && 0 == (nPrimaryTimeout = Integer.parseInt(primaryWaitThreshold) * 1000)) {
            nPrimaryTimeout = 1000;
        }
        return nPrimaryTimeout;
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        try {
            this.doAction();
            if (this.spRunHistory_ == null) {
                int primaryTimeout = this.getPrimaryTimeout();
                MSConnector msd = MSConnector.getMSConnector();
                while (!msd.isComplete()) {
                    Thread.sleep(primaryTimeout);
                }
            }
        }
        catch (CMException ex) {
            CMIndications.logException(ex);
            throw ex;
        }
        catch (Throwable ex) {
            CMIndications.logException(ex);
            throw new CMException(ex, "cmUnexpectedError");
        }
        if (!this.bSucceeded_) {
            throw new CMException("cmContentTaskError");
        }
        return true;
    }

    public void doAction() throws CMException {
        this.setErrorsReporter();
        this.getOptions();
        Task[] tasks = this.taskFactory.getTasks(this.store_, this.lockMgr_, this.runOptions_);
        for (int i = 0; i < tasks.length; ++i) {
            this.executeTask(tasks[i]);
        }
        this.addEffectiveOptionsToDetail();
    }

    protected void executeTask(Task task) throws CMException {
        Task.Lock lock = task.getLock();
        if (!lock.aquire()) {
            throw new CMException("cmContentTaskSkipped");
        }
        try {
            task.initialize();
            task.setErrorsReporter(this.errorsReporter);
            task.execute();
            if (!task.isSucceeded()) {
                this.bSucceeded_ = false;
            }
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getOptions() throws CMException {
        if (this.runnableObjStorePath_ == null) {
            throw new CMException("cmMissingRunnableObj", new CMException.Parm("path", ""));
        }
        if (this.runOptions_ != null) {
            this.runOptions_.put(OBJECT_SEARCH_PATH, this.runnableObjSearchPath_);
        }
        CMStoreQueryResults results = null;
        if (this.store_ == null) {
            this.store_ = CMExecutionContext.get().getStore();
        }
        CMProperty[] queryProps = new CMProperty[]{CMProperty.OPTIONS};
        try {
            CMTypedNameValuePairArray arrayValue;
            results = this.store_.executeQuery(this.runnableObjStorePath_, queryProps, null, 0, 512, null);
            if (results != null && results.next() && (arrayValue = (CMTypedNameValuePairArray)results.getValue(0)) != null) {
                for (int i = 0; i < arrayValue.getSize(); ++i) {
                    String sName;
                    CMTypedNameValuePair pair = arrayValue.getPair(i);
                    if (pair == null || !ContentTaskOption.isValidOption(sName = pair.getName()) || this.runOptions_.containsKey(sName)) continue;
                    this.runOptions_.put(sName, pair.getValue());
                }
            }
        }
        finally {
            if (results == null) {
                this.store_.release();
            } else {
                results.release();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addEffectiveOptionsToDetail() throws CMException {
        CMDbStoreTypedNameValuePairArray propValue = new CMDbStoreTypedNameValuePairArray();
        if (this.runOptions_ != null) {
            for (String optionName : this.runOptions_.keySet()) {
                ContentTaskOption option = ContentTaskOption.forString(optionName);
                if (option == null) continue;
                String valueXML = this.runOptions_.get(optionName).toString();
                String nameXsiType = OPTION_ENUM_NAME;
                String optionXsiType = option.getOptionType();
                propValue.add(option.name(), nameXsiType, valueXML, optionXsiType);
            }
        }
        if (propValue.getSize() == 0) return;
        if (this.spRunHistory_ == null) {
            MSConnector msd = MSConnector.getMSConnector();
            String eventId = this.getEventId();
            if (null == eventId) throw new CMException("cmMissingEventId");
            msd.addRunOptionDetail(propValue, eventId);
            return;
        } else {
            this.addHistoryDetailReqArgs(propValue, null);
        }
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

