/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.multitenancy.TenantIdCopyAction;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.AuditContext;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandlerWithTarget;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreDuplicateObject;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMWhileDeadlockExecutor;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.CMStoreXPathStep;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMIntList;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class copy
extends RequestHandlerWithTarget {
    public copy(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
        RequestInfo requestInfo = (RequestInfo)this.requestsInfo_.get(0);
        CMStoreXPath objectContext = null;
        if (requestInfo.objectsContexts_ != null && requestInfo.objectsContexts_.size() > 0 && (objectContext = (CMStoreXPath)requestInfo.objectsContexts_.get(0)) != null && objectContext.isUnion()) {
            throw new CMException("cmBadCompoundPathOp", new CMException.Parm("Path", objectContext.getOriginalPath()));
        }
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        if (this.didGetParmUsingXMLEl_ == requestElement && this.requestsInfo_.size() > 0) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        if (this.lockedPaths_ == null) {
            this.lockedPaths_ = new ArrayList();
        }
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.requestElement_ = requestElement;
        this.requestsInfo_.add(requestInfo);
        requestInfo.objectsContexts_ = new ArrayList<ICMStorePath>();
        requestInfo.targetContext_ = null;
        requestInfo.action_ = 2;
        this.parseSearchPath(requestElement, requestInfo);
        this.parseTargetSearchPath(requestElement, requestInfo);
        this.parseOptions(requestElement, requestInfo);
        this.parseNewNames(requestElement, requestInfo);
        this.parseObjects(requestElement, requestInfo);
    }

    private void parseSearchPath(XMLElement requestElement, RequestInfo requestInfo) throws CMStoreParseException {
        String searchPath = requestElement.getOptionalChildValueWithName("search");
        if (searchPath != null && searchPath.length() > 0) {
            CMStoreXPath objectContext = (CMStoreXPath)CMStoreXPath.parse(searchPath);
            objectContext.setLockManagerUsageFlag(16);
            this.addObjectContextToLockPaths(objectContext);
            requestInfo.objectsContexts_.add(objectContext);
        }
    }

    private void parseTargetSearchPath(XMLElement requestElement, RequestInfo requestInfo) throws CMException {
        String targetSearchPath = this.getTargetSearchPath(requestElement);
        if (targetSearchPath != null && targetSearchPath.length() > 0) {
            requestInfo.targetContext_ = this.parsePath(targetSearchPath);
            this.validatePathForNonQueryCommand(requestInfo.targetContext_, "copy");
            requestInfo.targetContext_.setLockManagerUsageFlag(17);
            this.addObjectContextToLockPaths(requestInfo.targetContext_);
        }
    }

    private void parseOptions(XMLElement requestElement, RequestInfo requestInfo) throws CMException {
        XMLElement optionsXmlElm = requestElement.getOptionalChildWithName("options");
        if (optionsXmlElm != null) {
            String updateAction = optionsXmlElm.getOptionalChildValueWithName("updateAction");
            if (updateAction != null && updateAction.length() > 0) {
                if (updateAction.equalsIgnoreCase("replace")) {
                    requestInfo.action_ = 1;
                } else if (updateAction.equalsIgnoreCase("fail")) {
                    requestInfo.action_ = 2;
                } else if (updateAction.equalsIgnoreCase("update")) {
                    requestInfo.action_ = 3;
                } else {
                    throw new CMException("cmBadAttrValue", new CMException.Parm("Value", updateAction), new CMException.Parm("Attribute", "updateAction"));
                }
            }
            requestInfo.bRecursive_ = optionsXmlElm.getOptionalChildBooleanValueWithName("recursive", false);
            requestInfo.clearInvalidReferences_ = !optionsXmlElm.getOptionalChildBooleanValueWithName("faultIfObjectReferenced", false);
            requestInfo.keepTenancy = optionsXmlElm.getOptionalChildBooleanValueWithName("keepTenancy", false);
            XMLElement xmlEl = optionsXmlElm.getOptionalChildWithName("targetTenantID");
            if (xmlEl != null) {
                String targetTenantIdString = xmlEl.value_;
                requestInfo.targetTenantId = targetTenantIdString != null ? new Integer(this.tenantRegistry.getTenantIdIntFromString(targetTenantIdString, false)) : new Integer(0);
            }
        }
    }

    private void parseNewNames(XMLElement requestElement, RequestInfo requestInfo) throws CMException {
        XMLElement newNameEle = this.getNewNames(requestElement);
        if (newNameEle != null) {
            requestInfo.newNames_ = new ArrayList<String>();
            if (newNameEle.isArray_) {
                if (newNameEle.hasChildren()) {
                    for (XMLElement xmlElName : newNameEle.getChildren()) {
                        String value = CMStringUtils.collapseWhitespace(xmlElName.value_);
                        copy.validateName(value);
                        requestInfo.newNames_.add(value);
                    }
                }
            } else {
                String value = CMStringUtils.collapseWhitespace(newNameEle.value_);
                copy.validateName(value);
                requestInfo.newNames_.add(value);
            }
        }
    }

    private void parseObjects(XMLElement requestElement, RequestInfo requestInfo) throws CMStoreParseException, CMException {
        ArrayList<XMLElement> aClassList;
        XMLElement objectsEle = requestElement.getOptionalChildWithName("objects");
        if (objectsEle != null && null != (aClassList = objectsEle.getChildren())) {
            ListIterator iterClass = aClassList.listIterator();
            while (iterClass.hasNext()) {
                XMLElement xmlElClass = (XMLElement)iterClass.next();
                CMStoreXPath objectContext = this.getClassObjSearchPath(xmlElClass);
                if (objectContext == null) continue;
                objectContext.setLockManagerUsageFlag(16);
                this.addObjectContextToLockPaths(objectContext);
                requestInfo.objectsContexts_.add(objectContext);
            }
        }
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        boolean rc = this.runCommands("copyResponse", "copyReply");
        return rc;
    }

    @Override
    protected void prepareLocks() {
    }

    protected String getCopyResultString() {
        return "copyResult";
    }

    protected String getTargetSearchPath(XMLElement requestElement) {
        return requestElement.getOptionalChildValueWithName("target");
    }

    protected XMLElement getNewNames(XMLElement requestElement) {
        return requestElement.getOptionalChildWithName("newName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doCommand(Object requestInfoObj, String tabPrefix) throws CMException {
        RequestInfo requestInfo = (RequestInfo)requestInfoObj;
        if (requestInfo.objectsContexts_.size() < 1) {
            throw new CMException("cmNoSelectPath");
        }
        if (requestInfo.targetContext_ == null) {
            throw new CMException("cmNoTargetPath");
        }
        this.out.print(tabPrefix);
        this.emitArrayElement(this.getCopyResultString(), "cm", "baseClass");
        this.addBuffer_ = new StringBuffer();
        CMStore store = CMExecutionContext.get().getStore();
        int objectTotalCount = 0;
        int objectCount = 0;
        ListIterator<ICMStorePath> iter = requestInfo.objectsContexts_.listIterator();
        ListIterator<String> iterNames = null;
        if (requestInfo.newNames_ != null) {
            iterNames = requestInfo.newNames_.listIterator();
        }
        int perm = 0;
        ArrayList<String> permissions = null;
        if (CMExecutionContext.get().getCurrentUserIsAdministrator()) {
            perm = 512;
        } else {
            perm = 1024;
            permissions = new ArrayList<String>();
            permissions.add("read");
        }
        int groupCount = 0;
        while (iter.hasNext()) {
            CMStorePath objectContext = (CMStorePath)iter.next();
            String newName = null;
            if (iterNames != null) {
                newName = iterNames.next();
            }
            if (objectContext.size() == 0) {
                throw new CMException("cmBadCopySelectionRoot", new CMException.Parm("Path", CMQueryUtils.getPath(store, objectContext)));
            }
            CMStoreQueryResults resultsSrc = null;
            try {
                this.handleTarget(requestInfo.targetContext_);
                try {
                    resultsSrc = store.executeQuery(objectContext, null, null, 3, perm, permissions);
                }
                catch (CMStoreObjectNotFound e) {
                    throw new CMException("cmBadTargetNotFound", new CMException.Parm("Path", CMQueryUtils.getPath(store, objectContext)));
                }
                CMStoreQueryResults results = null;
                try {
                    objectCount = 0;
                    while (resultsSrc.next()) {
                        CMStoreXPathStep firstStep;
                        String camid;
                        CMStoreXPathStep firstStep2;
                        String camid2;
                        CMObjectClass objectClass = resultsSrc.getObjectClass();
                        String objectSearchPath = resultsSrc.getSearchPath();
                        CMStoreXPath objectPath = new CMStoreXPath(objectSearchPath);
                        if (objectPath.size() == 1 && (camid2 = (firstStep2 = (CMStoreXPathStep)objectPath.stepAt(0)).getCAMIDLiteral()) != null && CMCAMIDHelper.isSpecialCAMID(camid2)) {
                            throw new CMException("cmBadCopySelectionSpecial", new CMException.Parm("Path", resultsSrc.getPath()));
                        }
                        String tenantIdString = this.getAndValidateTenantString(requestInfo, resultsSrc.getTenantID());
                        this.assertIsValidChildClass(this.sTargetSearchPath_, this.targetClass_, objectClass);
                        this.validateMaxOccurs(this.sTargetSearchPath_, this.targetClass_, objectClass, tenantIdString);
                        if (objectPath.size() == 1 && !objectClass.isExternal() && (camid = (firstStep = (CMStoreXPathStep)objectPath.stepAt(0)).getCAMIDLiteral()) == null) {
                            throw new CMException("cmBadCopySelectionRoot", new CMException.Parm("Path", CMQueryUtils.getPath(store, objectPath)));
                        }
                        if (store.isDescendantOrSelf(requestInfo.targetContext_, objectPath)) {
                            throw new CMException("cmBadTargetDescendantOfSearch", new CMException.Parm("Target", CMQueryUtils.getPath(store, requestInfo.targetContext_)), new CMException.Parm("Search", CMQueryUtils.getPath(store, objectPath)));
                        }
                        this.handleTargetOverwrite(store, resultsSrc, objectPath, newName);
                        if (objectClass == CMObjectClass.HISTORY) {
                            throw new CMException("cmInvalidCopyRunhistory", new CMException.Parm("Class", objectClass.getName()));
                        }
                        ++objectCount;
                    }
                    if (objectCount == 0) {
                        if (!requestInfo.copyAccount_) throw new CMException("cmBadTargetNotFound", new CMException.Parm("Path", CMQueryUtils.getPath(store, objectContext)));
                        boolean objectClass = true;
                        return objectClass;
                    }
                    if (objectCount > 1 && newName != null) {
                        throw new CMException("cmBadNewName");
                    }
                    resultsSrc.reset();
                    DeadlockContext context = new DeadlockContext();
                    context.sourceIds = new CMIntList();
                    context.targetIds = new CMIntList();
                    context.correctOwnerIds = new CMIntList();
                    context.requestInfo = requestInfo;
                    context.resultsSrc = resultsSrc;
                    context.results = results;
                    context.permissions = permissions;
                    context.perm = perm;
                    context.groupCount = groupCount;
                    context.objectCount = objectCount;
                    context.objectContext = objectContext;
                    context.newName = newName;
                    try {
                        CMWhileDeadlockExecutor.execute(this, context, Class.forName("com.cognos.cm.request.copy").getDeclaredMethod("executeInDeadlockLoop", DeadlockContext.class, Integer.class));
                    }
                    catch (CMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new CMException(t, "cmUnexpectedError");
                    }
                    groupCount = context.groupCount;
                    objectCount = context.objectCount;
                    results = context.results;
                    objectCount = 0;
                    CMExecutionContext ctx = CMExecutionContext.get();
                    AuditContext auditContext = ctx.getAuditContext();
                    while (results.next()) {
                        CMObjectClass objectClass = results.getObjectClass();
                        String searchPath = results.getSearchPath();
                        int objectID = results.getObjectID();
                        String storeID = store.getObjectStoreID(objectID);
                        String defaultName = results.getName();
                        auditContext.add(objectID, objectClass);
                        this.configurationModified(searchPath, objectClass);
                        ++objectCount;
                        this.emitObject(tabPrefix, objectClass, defaultName, searchPath, storeID);
                    }
                    objectTotalCount += objectCount;
                    this.postSuccessfulOperation();
                }
                finally {
                    if (results != null) {
                        results.release();
                    }
                    if (resultsSrc == null) continue;
                    resultsSrc.release();
                }
            }
            catch (CMStoreDuplicateObject e) {
                String errorName = objectContext.getName();
                StringBuffer listofNames = new StringBuffer();
                String parentPath = null;
                try {
                    parentPath = this.getPath(requestInfo.targetContext_.toString());
                    if (newName == null) {
                        CMLocalizedStringArray names = (CMLocalizedStringArray)CMQueryUtils.getProp(store, objectContext, CMProperty.NAME);
                        for (int x = 0; x < names.getSize(); ++x) {
                            if (x > 0) {
                                listofNames.append(",");
                            }
                            listofNames.append(names.get(x).getValue());
                        }
                        throw new CMException("cmNameConflict", new CMException.Parm("Names", listofNames), new CMException.Parm("Root", parentPath));
                    } else {
                        listofNames.append(newName);
                    }
                    throw new CMException("cmNameConflict", new CMException.Parm("Names", listofNames), new CMException.Parm("Root", parentPath));
                }
                catch (CMException ex) {
                    throw new CMException((Exception)ex, "cmDuplicateNameFail", new CMException.Parm("Name", errorName));
                }
            }
            catch (Exception ex) {
                throw new CMException(ex, "cmCopyFailed");
            }
        }
        if (groupCount > 0) {
            DeadlockContext context = new DeadlockContext();
            context.groupCount = groupCount;
            try {
                CMWhileDeadlockExecutor.execute(this, context, Class.forName("com.cognos.cm.request.copy").getDeclaredMethod("executeInDeadlockLoop2", DeadlockContext.class, Integer.class));
            }
            catch (CMException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new CMException(t, "cmUnexpectedError");
            }
        }
        this.out.print(Integer.toString(objectTotalCount));
        this.out.print("]\">\r\n");
        this.out.print(this.addBuffer_.toString());
        this.addBuffer_ = null;
        this.out.print(tabPrefix);
        this.out.print("</");
        this.out.print(this.getCopyResultString());
        this.out.print(">\r\n");
        return true;
    }

    private String getAndValidateTenantString(RequestInfo requestInfo, int sourceTenantId) throws CMException {
        String tenantIdString;
        if (requestInfo.targetTenantId != null) {
            tenantIdString = this.tenantRegistry.getTenantIdStringFromInt(requestInfo.targetTenantId);
            this.validateTenantContainment(requestInfo.targetTenantId);
        } else if (requestInfo.keepTenancy) {
            tenantIdString = this.tenantRegistry.getTenantIdStringFromInt(sourceTenantId);
            this.validateTenantContainment(sourceTenantId);
        } else {
            int tenantIdInt = MultiTenancyUtils.determineTenantIdWithVirtualInheritance(this.targetTenantId_);
            tenantIdString = this.tenantRegistry.getTenantIdStringFromInt(tenantIdInt);
        }
        return tenantIdString;
    }

    private void validateTenantContainment(int tenantIdToBeUsed) throws CMException {
        if (!MultiTenancyUtils.isValidContainment(this.targetTenantId_, tenantIdToBeUsed)) {
            throw new CMException("cmInvalidTenantContainment", new CMException.Parm("tenant", this.tenantRegistry.getTenantIdStringFromInt(tenantIdToBeUsed)), new CMException.Parm("path", this.sTargetSearchPath_), new CMException.Parm("parentTenant", this.tenantRegistry.getTenantIdStringFromInt(this.targetTenantId_)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInDeadlockLoop(DeadlockContext context, Integer deadlockRetryNumber) throws CMException {
        CMStore store;
        context.sourceIds.setSize(0);
        context.targetIds.setSize(0);
        context.correctOwnerIds.setSize(0);
        if (context.results != null) {
            context.results.release();
            context.results = null;
        }
        if (context.resultsSrc2 != null) {
            context.resultsSrc2.release();
            context.resultsSrc2 = null;
        }
        if (deadlockRetryNumber != AdvancedSettings.DBDEADLOCKRETRYMAX) {
            store = CMExecutionContext.get().getStore();
            context.resultsSrc.release();
            context.resultsSrc = null;
            try {
                context.resultsSrc = store.executeQuery(context.objectContext, null, null, 3, context.perm, context.permissions);
            }
            catch (CMStoreObjectNotFound e) {
                throw new CMException("cmBadTargetNotFound", new CMException.Parm("Path", CMQueryUtils.getPath(store, context.objectContext)));
            }
        }
        store = CMExecutionContext.get().getStore();
        try {
            block23: {
                store.beginTransaction();
                TenantIdCopyAction copyAction = context.requestInfo.targetTenantId != null ? TenantIdCopyAction.setTargetTenantId(context.requestInfo.targetTenantId) : (context.requestInfo.keepTenancy ? TenantIdCopyAction.keep() : TenantIdCopyAction.sessionFallbackVirtualInheritance());
                try {
                    if (context.requestInfo.action_ == 3) {
                        context.results = this.copy(context.resultsSrc, this.targetObjectID_, context.newName, context.requestInfo.bRecursive_, context.requestInfo.clearInvalidReferences_, context.requestInfo.action_, context.perm, context.permissions, context.sourceIds, context.targetIds, context.correctOwnerIds, copyAction);
                        CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                    } else {
                        context.results = store.copy(context.resultsSrc, context.objectCount, this.targetObjectID_, context.newName, context.requestInfo.bRecursive_, context.sourceIds, context.targetIds, context.correctOwnerIds, copyAction);
                        CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                    }
                }
                catch (CMStoreDuplicateObject e) {
                    if (context.requestInfo.action_ != 1 || this.sTargetSearchPath_ == null) {
                        throw e;
                    }
                    try {
                        context.resultsSrc2 = store.executeQuery(context.objectContext, null, null, 3, context.perm, context.permissions);
                    }
                    catch (CMStoreObjectNotFound ex) {
                        throw new CMException("cmBadTargetNotFound", new CMException.Parm("Path", CMQueryUtils.getPath(store, context.objectContext)));
                    }
                    while (context.resultsSrc2.next()) {
                        if (context.newName != null) {
                            this.deleteConflictingObjects(store, context.newName, context.resultsSrc2.getSearchPath(), context.requestInfo.clearInvalidReferences_);
                            continue;
                        }
                        this.deleteConflictingObjects(store, context.resultsSrc2.getName(), context.resultsSrc2.getSearchPath(), context.requestInfo.clearInvalidReferences_);
                    }
                    context.resultsSrc2.reset();
                    context.results = store.copy(context.resultsSrc2, context.objectCount, this.targetObjectID_, context.newName, context.requestInfo.bRecursive_, context.sourceIds, context.targetIds, context.correctOwnerIds, copyAction);
                    CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                    if (context.results != null) break block23;
                    throw e;
                }
            }
            store.copyReferencesInGroup(this, context.groupCount, context.sourceIds, context.targetIds, context.correctOwnerIds, context.requestInfo.ownerUser_);
            store.commitTransaction();
            ++context.groupCount;
        }
        finally {
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
            if (context.resultsSrc2 != null) {
                context.resultsSrc2.release();
            }
        }
    }

    public void executeInDeadlockLoop2(DeadlockContext context, Integer deadlockRetryNumber) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        try {
            store.beginTransaction();
            if (context.groupCount > 1) {
                store.updateReferencesBetweenGroups(this);
            }
            store.cleanReferenceGroups();
            store.commitTransaction();
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmCopyFailed");
        }
        finally {
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected String getOperationName() {
        return "copy";
    }

    private static class DeadlockContext {
        public CMIntList sourceIds;
        public CMIntList targetIds;
        public CMIntList correctOwnerIds;
        public CMStoreQueryResults resultsSrc;
        public CMStoreQueryResults resultsSrc2;
        public CMStoreQueryResults results;
        public RequestInfo requestInfo;
        public List<String> permissions;
        public int perm = 0;
        public int groupCount = 0;
        public int objectCount = 0;
        public CMStorePath objectContext;
        public String newName;

        private DeadlockContext() {
        }
    }

    public class RequestInfo {
        public boolean bRecursive_;
        public CMStoreXPath targetContext_;
        public CMStorePath ownerUser_ = null;
        public List<ICMStorePath> objectsContexts_;
        public List<String> newNames_;
        public int action_;
        public XMLElement requestElement_;
        public boolean clearInvalidReferences_ = true;
        public boolean copyAccount_ = false;
        public Integer targetTenantId;
        public boolean keepTenancy;
    }
}

