/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.customFunctions;

import com.cognos.cm.request.customFunctions.ICustomFunctionStep;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cmutils.resource.CMResourceLoader;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class CustomFunctionPlugin {
    private static final byte[] RESPONSES_START = CMStringUtils.getUTF8BytesFromString("<responses>");
    private static final byte[] RESPONSES_END = CMStringUtils.getUTF8BytesFromString("</responses>");
    private static final byte[] RESPONSE_END = CMStringUtils.getUTF8BytesFromString("</response>");
    private static final byte[] HINTS_START = CMStringUtils.getUTF8BytesFromString("<hints>");
    private static final byte[] HINTS_END = CMStringUtils.getUTF8BytesFromString("</hints>");
    private static final byte[] HINT_END = CMStringUtils.getUTF8BytesFromString("</hint>");
    private static final byte[] HINT_START = CMStringUtils.getUTF8BytesFromString("<hint>");
    private static final String CUSTOM_FUNCTION_RESOURCE = "/WEB-INF/cm/customFunctions/";
    public static final String ID = "id";
    public static final String NAME = "name";
    private CMResourceLoader loader_;
    private Map<String, ICustomFunctionStep> stepMap;
    private XMLElement incomingHeader;

    public abstract void run(List<XMLElement> var1, OutputStream var2) throws CMException, SAXException;

    protected abstract void initializeStep(String var1, Element var2);

    protected abstract ICustomFunctionStep getCustomFunctionStep(String var1, String var2, XMLElement var3) throws CMException;

    protected abstract void initialize();

    public CustomFunctionPlugin() {
        this.loader_ = CMResourceUtils.getResourceLoader();
        XMLElement originalHeader = CMExecutionContext.get().getBiBusHeaderElement();
        if (originalHeader != null) {
            this.incomingHeader = XMLElement.copyFrom(originalHeader);
        }
        this.initialize();
    }

    public CustomFunctionPlugin(CMResourceLoader loader) {
        this.setResourceLoader(loader);
        this.initialize();
    }

    InputStream getResourceStream(CustomFunctionPlugin plugin, String fileName) {
        String pathToFile = this.getResourcePath(plugin, fileName);
        InputStream resourceStream = this.getResourceInputStream(pathToFile);
        return resourceStream;
    }

    private InputStream getResourceInputStream(String pathToFile) {
        InputStream resourceStream = this.loader_.getResourceInputStream(pathToFile);
        return resourceStream;
    }

    private String getResourcePath(CustomFunctionPlugin plugin, String fileName) {
        String className = plugin.getClass().getSimpleName();
        return CUSTOM_FUNCTION_RESOURCE + className + "/" + fileName;
    }

    void addToStepMap(ICustomFunctionStep step) {
        String id = step.getID();
        if (id == null) {
            return;
        }
        if (this.stepMap == null) {
            this.stepMap = new HashMap<String, ICustomFunctionStep>();
        }
        this.stepMap.put(id, step);
    }

    void setResourceLoader(CMResourceLoader loader) {
        this.loader_ = loader;
    }

    public ICustomFunctionStep getFunctionStep(String id) {
        if (this.stepMap == null || id == null) {
            return null;
        }
        return this.stepMap.get(id);
    }

    InputStream getInputStreamFromRequest(Element requestContent) {
        byte[] requestBytes = CMStringUtils.getUTF8BytesFromString(requestContent.asXML());
        ByteArrayInputStream is = new ByteArrayInputStream(requestBytes);
        return is;
    }

    private void write(byte[] output, OutputStream os) throws IOException {
        os.write(output, 0, output.length);
    }

    void runSteps(List<ICustomFunctionStep> steps, OutputStream response) throws CMException, IOException, SAXException {
        this.write(RESPONSES_START, response);
        for (ICustomFunctionStep step : steps) {
            this.runStep(response, step);
        }
        this.write(RESPONSES_END, response);
    }

    private void runStep(OutputStream os, ICustomFunctionStep step) throws IOException, CMException, SAXException {
        step.preQuery();
        this.writeResponseStart(os, step);
        step.runFunctionStep(os);
        this.writeResponseHints(step, os);
        this.writeResponseEnd(os);
    }

    private void writeResponseHints(ICustomFunctionStep step, OutputStream os) throws IOException {
        Map<String, String> hints = step.getResponseHints();
        if (hints != null && hints.size() > 0) {
            this.writeHintsStart(os);
            this.writeHints(os, hints);
            this.writeHintsEnd(os);
        }
    }

    private void writeHintsEnd(OutputStream os) throws IOException {
        this.write(HINTS_END, os);
    }

    private void writeHintsStart(OutputStream os) throws IOException {
        this.write(HINTS_START, os);
    }

    private void writeResponseStart(OutputStream os, ICustomFunctionStep step) throws IOException {
        StringBuilder response = new StringBuilder();
        response.append("<response ");
        if (step.getID() != null) {
            this.addAttribute(response, ID, step.getID());
        }
        this.addAttribute(response, NAME, step.getName());
        this.addOptionalAttributes(response, step);
        response.append(">");
        byte[] responseBytes = CMStringUtils.getUTF8BytesFromString(response.toString());
        os.write(responseBytes, 0, responseBytes.length);
    }

    private void writeHint(String hint, String hintValue, OutputStream os) throws IOException {
        String output = "<" + hint + ">" + XMLUtils.encode((String)hintValue) + "</" + hint + ">";
        byte[] hintBytes = CMStringUtils.getUTF8BytesFromString(output);
        this.write(hintBytes, os);
    }

    private void writeHintEnd(OutputStream os) throws IOException {
        this.write(HINT_END, os);
    }

    private void writeHintStart(OutputStream os) throws IOException {
        this.write(HINT_START, os);
    }

    private void writeResponseEnd(OutputStream os) throws IOException {
        os.write(RESPONSE_END, 0, RESPONSE_END.length);
    }

    private void addOptionalAttributes(StringBuilder response, ICustomFunctionStep step) {
        Map<String, String> addOptionalAttributes = step.getOptionalAttributes();
        if (addOptionalAttributes != null) {
            for (String name : addOptionalAttributes.keySet()) {
                this.addAttribute(response, name, addOptionalAttributes.get(name));
            }
        }
    }

    private void addAttribute(StringBuilder response, String name, String value) {
        response.append(name + "=\"" + XMLUtils.encode((String)value) + "\" ");
    }

    private void writeHints(OutputStream os, Map<String, String> hints) throws IOException {
        Set<String> keys = hints.keySet();
        for (String hint : keys) {
            this.writeHint(os, hints, hint);
        }
    }

    private void writeHint(OutputStream os, Map<String, String> hints, String hint) throws IOException {
        this.writeHintStart(os);
        String hintValue = hints.get(hint);
        this.writeHint(hint, hintValue, os);
        this.writeHintEnd(os);
    }

    protected void loadRequests() {
        InputStream resourceStream = this.getResourceStream(this, "requests.xml");
        Document resourceDocument = null;
        SAXReader reader = new SAXReader();
        try {
            resourceDocument = reader.read(new InputSource(resourceStream));
        }
        catch (DocumentException e) {
            throw new CMRuntimeException(e);
        }
        this.parseRequests(resourceDocument);
    }

    private void parseRequests(Document document) {
        Element requests = document.getRootElement();
        Iterator iter = requests.elementIterator();
        while (iter.hasNext()) {
            Element request = (Element)iter.next();
            String requestName = request.attributeValue(NAME);
            Element requestContent = (Element)request.elements().get(0);
            this.initializeStep(requestName, requestContent);
        }
    }

    protected List<ICustomFunctionStep> buildFunctionSteps(List<XMLElement> functionSteps) throws CMException {
        ArrayList<ICustomFunctionStep> steps = new ArrayList<ICustomFunctionStep>();
        for (XMLElement stepSpecification : functionSteps) {
            String name = stepSpecification.getAttribute(NAME);
            String id = stepSpecification.getAttribute(ID);
            if (name == null) {
                throw new CMException("cmExpectedElementAttrMissing", new CMException.Parm("Name", stepSpecification.name_), new CMException.Parm("Attribute", NAME), new CMException.Parm("Value", ""));
            }
            ICustomFunctionStep step = this.getCustomFunctionStep(name, id, stepSpecification);
            if (step == null) continue;
            steps.add(step);
            this.addToStepMap(step);
        }
        return steps;
    }

    Map<String, ICustomFunctionStep> getStepMap_test() {
        return this.stepMap;
    }

    protected XMLElement getIncomingHeader() {
        return this.incomingHeader;
    }
}

