/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.customFunctions;

import com.cognos.cm.server.Header;
import com.cognos.pogo.contentmanager.cache.CMCacheService;
import com.cognos.pogo.contentmanager.cache.CacheServiceConfiguration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CustomReportQueryCookie {
    private static Set<String> watchedSessions = Collections.synchronizedSet(new HashSet());
    private static final String COOKIE_NAME = "CogCacheService";
    private Header header;

    public CustomReportQueryCookie(Header header) {
        this.header = header;
    }

    public void create(String passportID) {
        watchedSessions.add(passportID);
    }

    public void delete(String passportID) {
        watchedSessions.remove(passportID);
    }

    private void setCookieValue() {
        if (this.header == null) {
            return;
        }
        String value = Long.toString(System.nanoTime());
        this.header.setCookie(COOKIE_NAME, value, this.getMaxAge());
    }

    public void setCookie(String passportID) {
        if (passportID != null && watchedSessions.contains(passportID)) {
            this.setCookieValue();
        }
    }

    protected String getMaxAge() {
        CacheServiceConfiguration config = CMCacheService.getConfig();
        long maxAge = config.getCacheValidatorTimeToLinger() / 1000L;
        return Long.toString(maxAge);
    }

    public void reset_test() {
        watchedSessions.clear();
    }
}

