/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.customFunctions;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomXMLDocumentContainer;
import com.cognos.cm.request.customFunctions.QueryFunctionStep;
import com.cognos.cm.request.customFunctions.XMLDocPool;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xml.sax.SAXException;

public class DataSourceFunctionStep
extends QueryFunctionStep {
    private static XMLDocPool xmlDocPool;
    private String searchPath;
    private String validator;

    public DataSourceFunctionStep(String _name, String _id, CustomFunctionPlugin _plugin, XMLElement stepSpecification) throws CMException {
        super(_name, _id, _plugin);
        this.searchPath = this.getSearchPath(stepSpecification);
        this.addOptionalResponseAttribute("searchPath", this.searchPath);
        this.validator = this.getValidator(stepSpecification);
    }

    @Override
    public void runFunctionStep(OutputStream os) throws SAXException, CMException {
        if (xmlDocPool == null) {
            throw new RuntimeException("The doc pool has not been initialized");
        }
        CustomXMLDocumentContainer doc = xmlDocPool.getDocFromPool();
        this.replaceVariablesInXMLDoc(this.searchPath, this.validator, doc);
        this.runStaticRequest(doc.getXMLDoc(), os);
        xmlDocPool.returnDocToPool(doc);
    }

    private void replaceVariablesInXMLDoc(String searchPath, String validator, CustomXMLDocumentContainer doc) {
        this.replaceHeaderInDoc(doc);
        doc.replaceVariable("DATASOURCE_SEARCHPATH", searchPath);
        doc.replaceVariable("DATASOURCE_VALIDATOR", validator);
    }

    public static void initialize(InputStream request) throws CMException, SAXException, IOException {
        xmlDocPool = new XMLDocPool(request);
    }
}

