/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.customFunctions;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomXMLDocumentContainer;
import com.cognos.cm.request.customFunctions.QueryFunctionStep;
import com.cognos.cm.request.customFunctions.ReportFunctionStep;
import com.cognos.cm.request.customFunctions.XMLDocPool;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.XMLElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.xml.sax.SAXException;

public class PackageFunctionStep
extends QueryFunctionStep {
    private static final String HINTS = "hints";
    private static final String NO_VALIDATOR = "?";
    private static final String PACKAGE_VALIDATOR = "PACKAGE_VALIDATOR";
    private static final String PACKAGE_SEARCHPATH4 = "PACKAGE_SEARCHPATH4";
    private static final String PACKAGE_SEARCHPATH3 = "PACKAGE_SEARCHPATH3";
    private static final String PACKAGE_SEARCHPATH2 = "PACKAGE_SEARCHPATH2";
    private static final String PACKAGE_SEARCHPATH1 = "PACKAGE_SEARCHPATH1";
    private static final String SOURCE = "source";
    private static final String SEARCH_PATH = "searchPath";
    private static XMLDocPool xmlDocPool;
    private String searchPath;
    private String validator;
    private XMLElement spec;

    public PackageFunctionStep(String _name, String _id, CustomFunctionPlugin _plugin, XMLElement stepSpecification) throws CMException {
        super(_name, _id, _plugin);
        this.searchPath = this.getSearchPath(stepSpecification);
        this.spec = stepSpecification;
        this.validator = this.getValidator(stepSpecification);
        if (this.validator == null) {
            this.validator = NO_VALIDATOR;
        }
        if (this.searchPath != null) {
            this.lookUpValidator(stepSpecification, this.searchPath);
        }
    }

    @Override
    public void runFunctionStep(OutputStream os) throws SAXException, CMException {
        if (xmlDocPool == null) {
            throw new RuntimeException("The doc pool has not been initialized");
        }
        if (this.hasRequiredInfo()) {
            CustomXMLDocumentContainer doc = xmlDocPool.getDocFromPool();
            this.replaceVariablesInXMLDoc(this.searchPath, this.validator, doc);
            this.runStaticRequest(doc.getXMLDoc(), os);
            xmlDocPool.returnDocToPool(doc);
        }
    }

    private void replaceVariablesInXMLDoc(String searchPath, String validator, CustomXMLDocumentContainer doc) {
        this.replaceHeaderInDoc(doc);
        doc.replaceVariable(PACKAGE_SEARCHPATH1, searchPath + "/model");
        doc.replaceVariable(PACKAGE_SEARCHPATH2, searchPath + "/model/modelView");
        doc.replaceVariable(PACKAGE_SEARCHPATH3, searchPath);
        doc.replaceVariable(PACKAGE_SEARCHPATH4, searchPath + "/packageConfiguration");
        doc.replaceVariable(PACKAGE_VALIDATOR, validator);
    }

    private void lookUpValidator(XMLElement stepSpecification, String searchPath) throws CMException {
        String val;
        Map<String, String> hints;
        if (this.validator.equals(NO_VALIDATOR) && (hints = this.getHints(stepSpecification)) != null && (val = hints.get(searchPath)) != null) {
            this.validator = val;
        }
    }

    private Map<String, String> getHints(XMLElement stepSpecification) throws CMException {
        HashMap<String, String> hintMap = new HashMap<String, String>();
        XMLElement hints = stepSpecification.getOptionalChildWithName(HINTS);
        if (hints == null) {
            return null;
        }
        ArrayList<XMLElement> listProps = hints.getChildren();
        if (listProps != null) {
            ListIterator iter = listProps.listIterator();
            while (iter.hasNext()) {
                XMLElement xmlEl = (XMLElement)iter.next();
                this.populateHintMap(hintMap, xmlEl);
            }
        }
        return hintMap;
    }

    private void populateHintMap(HashMap<String, String> hintMap, XMLElement xmlEl) throws CMException {
        String searchPath = this.getSearchPath(xmlEl);
        String validator = this.getValidator(xmlEl);
        hintMap.put(searchPath, validator);
    }

    void getOptionalSearchPath() throws CMException {
        ReportFunctionStep reportFunctionStep = this.getReportFunctionStep();
        if (reportFunctionStep == null) {
            return;
        }
        String reportQueryOutputSearchPath = reportFunctionStep.getMetadataModelPackageSearchPath();
        if (reportQueryOutputSearchPath != null) {
            this.searchPath = reportQueryOutputSearchPath;
        }
        if (this.searchPath != null) {
            this.lookUpValidator(this.spec, this.searchPath);
        }
    }

    private ReportFunctionStep getReportFunctionStep() {
        XMLElement sp;
        try {
            sp = this.spec.getChildWithName(SEARCH_PATH);
        }
        catch (CMException e) {
            throw new CMRuntimeException(e);
        }
        String source = sp.getAttribute(SOURCE);
        CustomFunctionPlugin plugin = this.getPlugin();
        if (plugin == null) {
            return null;
        }
        ReportFunctionStep reportFunctionStep = (ReportFunctionStep)plugin.getFunctionStep(source);
        return reportFunctionStep;
    }

    public static void initialize(InputStream request) throws CMException, SAXException, IOException {
        xmlDocPool = new XMLDocPool(request);
    }

    @Override
    public void preQuery() throws CMException {
        this.getOptionalSearchPath();
        if (this.hasRequiredInfo()) {
            this.addOptionalResponseAttribute(SEARCH_PATH, this.searchPath);
        }
    }

    boolean hasRequiredInfo() {
        return this.searchPath != null;
    }
}

